/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.model.types;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jupnp.model.types.InvalidValueException;
import org.jupnp.model.types.ServiceId;
import org.jupnp.util.SpecificationViolationReporter;

public class UDAServiceId
extends ServiceId {
    public static final String DEFAULT_NAMESPACE = "upnp-org";
    public static final String BROKEN_DEFAULT_NAMESPACE = "schemas-upnp-org";
    public static final Pattern PATTERN = Pattern.compile("urn:upnp-org:serviceId:([a-zA-Z_0-9\\-:\\.]{1,64})");
    public static final Pattern BROKEN_PATTERN = Pattern.compile("urn:schemas-upnp-org:service:([a-zA-Z_0-9\\-:\\.]{1,64})");

    /*
     * WARNING - void declaration
     */
    public UDAServiceId(String id) {
        super(DEFAULT_NAMESPACE, (String)var1_1);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static UDAServiceId valueOf(String s) throws InvalidValueException {
        String string;
        Matcher matcher = PATTERN.matcher(s);
        if (matcher.matches() && matcher.groupCount() > 0) {
            return new UDAServiceId(matcher.group(1));
        }
        matcher = BROKEN_PATTERN.matcher(s);
        if (matcher.matches() && matcher.groupCount() > 0) {
            return new UDAServiceId(matcher.group(1));
        }
        matcher = Pattern.compile("urn:upnp-orgerviceId:urnchemas-upnp-orgervice:([a-zA-Z_0-9\\-:\\.]{1,64})").matcher(s);
        if (matcher.matches()) {
            void var1_1;
            SpecificationViolationReporter.report("Recovering from Eyecon garbage: {}", s);
            return new UDAServiceId(var1_1.group(1));
        }
        if ("ContentDirectory".equals(s) || "ConnectionManager".equals(s) || "RenderingControl".equals(s) || "AVTransport".equals(s)) {
            SpecificationViolationReporter.report("Fixing broken Service ID: {}", s);
            return new UDAServiceId(s);
        }
        throw new InvalidValueException("Can't parse UDA service ID string (upnp-org/id): " + string);
    }
}

