/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.model.types;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jupnp.model.types.InvalidValueException;
import org.jupnp.model.types.UDAServiceType;
import org.jupnp.util.SpecificationViolationReporter;

public class ServiceType {
    public static final Pattern PATTERN = Pattern.compile("urn:([a-zA-Z0-9\\-\\.]+):service:([a-zA-Z_0-9\\-]{1,64}):([0-9]+).*");
    public static final Pattern BROKEN_PATTERN = Pattern.compile("urn:([a-zA-Z0-9\\-\\.]+):serviceId:([a-zA-Z_0-9\\-]{1,64}):([0-9]+).*");
    private static final Pattern PATTERN_WHITESPACE = Pattern.compile("\\s");
    private static final Pattern PATTERN_NAMESPACE = Pattern.compile("[a-zA-Z0-9\\-\\.]+");
    private static final Pattern PATTERN_TYPE = Pattern.compile("[a-zA-Z_0-9\\-]{1,64}");
    private String namespace;
    private String type;
    private int version = 1;

    /*
     * WARNING - void declaration
     */
    public ServiceType(String namespace, String type) {
        this((String)var1_1, (String)var2_2, 1);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public ServiceType(String namespace, String type, int version) {
        void var3_3;
        void var2_2;
        void var1_1;
        if (namespace != null && !PATTERN_NAMESPACE.matcher(namespace).matches()) {
            throw new IllegalArgumentException("Service type namespace contains illegal characters");
        }
        this.namespace = var1_1;
        if (type != null && !PATTERN_TYPE.matcher(type).matches()) {
            throw new IllegalArgumentException("Service type suffix too long (64) or contains illegal characters");
        }
        this.type = var2_2;
        this.version = var3_3;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getType() {
        return this.type;
    }

    public int getVersion() {
        return this.version;
    }

    /*
     * WARNING - void declaration
     */
    public static ServiceType valueOf(String s) throws InvalidValueException {
        String string;
        if (s == null) {
            throw new InvalidValueException("Can't parse null string");
        }
        UDAServiceType serviceType = null;
        s = PATTERN_WHITESPACE.matcher(s).replaceAll("");
        try {
            serviceType = UDAServiceType.valueOf(s);
        }
        catch (Exception exception) {}
        if (serviceType != null) {
            return serviceType;
        }
        try {
            Matcher matcher = PATTERN.matcher(s);
            if (matcher.matches() && matcher.groupCount() >= 3) {
                return new ServiceType(matcher.group(1), matcher.group(2), Integer.parseInt(matcher.group(3)));
            }
            matcher = BROKEN_PATTERN.matcher(s);
            if (matcher.matches() && matcher.groupCount() >= 3) {
                return new ServiceType(matcher.group(1), matcher.group(2), Integer.parseInt(matcher.group(3)));
            }
            matcher = Pattern.compile("urn:([a-zA-Z0-9\\-\\.]+):service:(.+?):([0-9]+).*").matcher(s);
            if (matcher.matches() && matcher.groupCount() >= 3) {
                String cleanToken = matcher.group(2).replaceAll("[^a-zA-Z_0-9\\-]", "-");
                SpecificationViolationReporter.report("Replacing invalid service type token '{}' with: {}", matcher.group(2), cleanToken);
                return new ServiceType(matcher.group(1), cleanToken, Integer.parseInt(matcher.group(3)));
            }
            matcher = Pattern.compile("urn:([a-zA-Z0-9\\-\\.]+):serviceId:(.+?):([0-9]+).*").matcher(s);
            if (matcher.matches() && matcher.groupCount() >= 3) {
                void var2_4;
                String cleanToken = matcher.group(2).replaceAll("[^a-zA-Z_0-9\\-]", "-");
                SpecificationViolationReporter.report("Replacing invalid service type token '{}' with: {}", matcher.group(2), cleanToken);
                return new ServiceType(matcher.group(1), (String)var2_4, Integer.parseInt(matcher.group(3)));
            }
        }
        catch (RuntimeException e) {
            void var1_2;
            throw new InvalidValueException(String.format("Can't parse service type string (namespace/type/version) '%s'", s), (Throwable)var1_2);
        }
        throw new InvalidValueException("Can't parse service type string (namespace/type/version): " + string);
    }

    /*
     * WARNING - void declaration
     */
    public boolean implementsVersion(ServiceType that) {
        void var1_1;
        if (that == null) {
            return false;
        }
        if (!this.namespace.equals(that.namespace)) {
            return false;
        }
        if (!this.type.equals(that.type)) {
            return false;
        }
        return this.version >= var1_1.version;
    }

    public String toFriendlyString() {
        return this.getNamespace() + ":" + this.getType() + ":" + this.getVersion();
    }

    public String toString() {
        return "urn:" + this.getNamespace() + ":service:" + this.getType() + ":" + this.getVersion();
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(Object o) {
        void var1_1;
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof ServiceType)) {
            return false;
        }
        ServiceType that = (ServiceType)o;
        if (this.version != that.version) {
            return false;
        }
        if (!this.namespace.equals(that.namespace)) {
            return false;
        }
        return this.type.equals(var1_1.type);
    }

    /*
     * WARNING - void declaration
     */
    public int hashCode() {
        void var1_1;
        int result = this.namespace.hashCode();
        result = result * 31 + this.type.hashCode();
        var1_1 = var1_1 * 31 + this.version;
        return (int)var1_1;
    }
}

