/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.model.types;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jupnp.model.types.InvalidValueException;
import org.jupnp.model.types.UDAServiceId;
import org.jupnp.util.SpecificationViolationReporter;

public class ServiceId {
    public static final String UNKNOWN = "UNKNOWN";
    public static final Pattern PATTERN = Pattern.compile("urn:([a-zA-Z0-9\\-\\.]+):serviceId:([a-zA-Z_0-9\\-:\\.]{1,64})");
    public static final Pattern BROKEN_PATTERN = Pattern.compile("urn:([a-zA-Z0-9\\-\\.]+):service:([a-zA-Z_0-9\\-:\\.]{1,64})");
    private String namespace;
    private String id;

    /*
     * WARNING - void declaration
     */
    public ServiceId(String namespace, String id) {
        void var2_2;
        void var1_1;
        if (namespace != null && !namespace.matches("[a-zA-Z0-9\\-\\.]+")) {
            throw new IllegalArgumentException("Service ID namespace contains illegal characters");
        }
        this.namespace = var1_1;
        if (id != null && !id.matches("[a-zA-Z_0-9\\-:\\.]{1,64}")) {
            throw new IllegalArgumentException("Service ID suffix too long (64) or contains illegal characters");
        }
        this.id = var2_2;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getId() {
        return this.id;
    }

    /*
     * WARNING - void declaration
     */
    public static ServiceId valueOf(String s) throws InvalidValueException {
        String string;
        UDAServiceId serviceId = null;
        try {
            serviceId = UDAServiceId.valueOf(s);
        }
        catch (Exception exception) {}
        if (serviceId != null) {
            return serviceId;
        }
        Matcher matcher = PATTERN.matcher(s);
        if (matcher.matches() && matcher.groupCount() >= 2) {
            return new ServiceId(matcher.group(1), matcher.group(2));
        }
        matcher = BROKEN_PATTERN.matcher(s);
        if (matcher.matches() && matcher.groupCount() >= 2) {
            return new ServiceId(matcher.group(1), matcher.group(2));
        }
        matcher = Pattern.compile("urn:([a-zA-Z0-9\\-\\.]+):serviceId:").matcher(s);
        if (matcher.matches() && matcher.groupCount() > 0) {
            SpecificationViolationReporter.report("No service ID token, defaulting to {}: {}", UNKNOWN, s);
            return new ServiceId(matcher.group(1), UNKNOWN);
        }
        String[] tokens = s.split("[:]");
        if (tokens.length == 4) {
            void var1_1;
            SpecificationViolationReporter.report("Trying a simple colon-split of: {}", s);
            return new ServiceId(tokens[1], (String)var1_1[3]);
        }
        throw new InvalidValueException("Can't parse service ID string (namespace/id): " + string);
    }

    public String toString() {
        return "urn:" + this.getNamespace() + ":serviceId:" + this.getId();
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(Object o) {
        void var1_1;
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof ServiceId)) {
            return false;
        }
        ServiceId serviceId = (ServiceId)o;
        if (!this.id.equals(serviceId.id)) {
            return false;
        }
        return this.namespace.equals(var1_1.namespace);
    }

    /*
     * WARNING - void declaration
     */
    public int hashCode() {
        void var1_1;
        int result = this.namespace.hashCode();
        var1_1 = var1_1 * 31 + this.id.hashCode();
        return (int)var1_1;
    }
}

