/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.model.types;

import org.jupnp.model.types.InvalidValueException;
import org.jupnp.model.types.ServiceType;
import org.jupnp.model.types.UDN;

public class NamedServiceType {
    private UDN udn;
    private ServiceType serviceType;

    /*
     * WARNING - void declaration
     */
    public NamedServiceType(UDN udn, ServiceType serviceType) {
        void var2_2;
        void var1_1;
        this.udn = var1_1;
        this.serviceType = var2_2;
    }

    public UDN getUdn() {
        return this.udn;
    }

    public ServiceType getServiceType() {
        return this.serviceType;
    }

    /*
     * WARNING - void declaration
     */
    public static NamedServiceType valueOf(String s) throws InvalidValueException {
        void var1_1;
        UDN uDN;
        String[] strings = s.split("::");
        if (strings.length != 2) {
            throw new InvalidValueException("Can't parse UDN::ServiceType from: " + s);
        }
        try {
            UDN udn = UDN.valueOf(strings[0]);
        }
        catch (Exception exception) {
            throw new InvalidValueException("Can't parse UDN: " + strings[0]);
        }
        ServiceType serviceType = ServiceType.valueOf(strings[1]);
        return new NamedServiceType(uDN, (ServiceType)var1_1);
    }

    public String toString() {
        return this.getUdn().toString() + "::" + this.getServiceType().toString();
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(Object o) {
        void var1_1;
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof NamedServiceType)) {
            return false;
        }
        NamedServiceType that = (NamedServiceType)o;
        if (!this.serviceType.equals(that.serviceType)) {
            return false;
        }
        return this.udn.equals(var1_1.udn);
    }

    /*
     * WARNING - void declaration
     */
    public int hashCode() {
        void var1_1;
        int result = this.udn.hashCode();
        var1_1 = var1_1 * 31 + this.serviceType.hashCode();
        return (int)var1_1;
    }
}

