/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.model.types;

import org.jupnp.model.types.DeviceType;
import org.jupnp.model.types.InvalidValueException;
import org.jupnp.model.types.UDN;

public class NamedDeviceType {
    private UDN udn;
    private DeviceType deviceType;

    /*
     * WARNING - void declaration
     */
    public NamedDeviceType(UDN udn, DeviceType deviceType) {
        void var2_2;
        void var1_1;
        this.udn = var1_1;
        this.deviceType = var2_2;
    }

    public UDN getUdn() {
        return this.udn;
    }

    public DeviceType getDeviceType() {
        return this.deviceType;
    }

    /*
     * WARNING - void declaration
     */
    public static NamedDeviceType valueOf(String s) throws InvalidValueException {
        void var1_1;
        UDN uDN;
        String[] strings = s.split("::");
        if (strings.length != 2) {
            throw new InvalidValueException("Can't parse UDN::DeviceType from: " + s);
        }
        try {
            UDN udn = UDN.valueOf(strings[0]);
        }
        catch (Exception exception) {
            throw new InvalidValueException("Can't parse UDN: " + strings[0]);
        }
        DeviceType deviceType = DeviceType.valueOf(strings[1]);
        return new NamedDeviceType(uDN, (DeviceType)var1_1);
    }

    public String toString() {
        return this.getUdn().toString() + "::" + this.getDeviceType().toString();
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(Object o) {
        void var1_1;
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof NamedDeviceType)) {
            return false;
        }
        NamedDeviceType that = (NamedDeviceType)o;
        if (!this.deviceType.equals(that.deviceType)) {
            return false;
        }
        return this.udn.equals(var1_1.udn);
    }

    /*
     * WARNING - void declaration
     */
    public int hashCode() {
        void var1_1;
        int result = this.udn.hashCode();
        var1_1 = var1_1 * 31 + this.deviceType.hashCode();
        return (int)var1_1;
    }
}

