/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.model.types;

import org.jupnp.model.types.AbstractDatatype;
import org.jupnp.model.types.InvalidValueException;

public class IntegerDatatype
extends AbstractDatatype<Integer> {
    private int byteSize;

    /*
     * WARNING - void declaration
     */
    public IntegerDatatype(int byteSize) {
        void var1_1;
        this.byteSize = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean isHandlingJavaType(Class type) {
        void var1_1;
        return type == Integer.TYPE || Integer.class.isAssignableFrom((Class<?>)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Integer valueOf(String s) throws InvalidValueException {
        if (s.isEmpty()) {
            return null;
        }
        try {
            Integer value = Integer.parseInt(s.trim());
            if (!this.isValid(value)) {
                throw new InvalidValueException("Not a " + this.getByteSize() + " byte(s) integer: " + s);
            }
            return value;
        }
        catch (NumberFormatException e) {
            void var2_3;
            void var1_1;
            if (s.equals("NOT_IMPLEMENTED")) {
                return this.getMaxValue();
            }
            throw new InvalidValueException("Can't convert string to number: " + (String)var1_1, (Throwable)var2_3);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean isValid(Integer value) {
        void var1_1;
        return value == null || value >= this.getMinValue() && var1_1.intValue() <= this.getMaxValue();
    }

    public int getMinValue() {
        switch (this.getByteSize()) {
            case 1: {
                return -128;
            }
            case 2: {
                return Short.MIN_VALUE;
            }
            case 4: {
                return Integer.MIN_VALUE;
            }
        }
        throw new IllegalArgumentException("Invalid integer byte size: " + this.getByteSize());
    }

    public int getMaxValue() {
        switch (this.getByteSize()) {
            case 1: {
                return 127;
            }
            case 2: {
                return Short.MAX_VALUE;
            }
            case 4: {
                return Integer.MAX_VALUE;
            }
        }
        throw new IllegalArgumentException("Invalid integer byte size: " + this.getByteSize());
    }

    public int getByteSize() {
        return this.byteSize;
    }
}

