/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.model.types;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jupnp.model.types.InvalidValueException;

public class DLNADoc {
    public static final Pattern PATTERN = Pattern.compile("(.+?)[ -]([0-9].[0-9]{2})");
    private final String devClass;
    private final String version;

    /*
     * WARNING - void declaration
     */
    public DLNADoc(String devClass, String version) {
        void var2_2;
        void var1_1;
        this.devClass = var1_1;
        this.version = var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public DLNADoc(String devClass, Version version) {
        void var2_2;
        void var1_1;
        this.devClass = var1_1;
        this.version = var2_2.s;
    }

    public String getDevClass() {
        return this.devClass;
    }

    public String getVersion() {
        return this.version;
    }

    /*
     * WARNING - void declaration
     */
    public static DLNADoc valueOf(String s) throws InvalidValueException {
        String string;
        Matcher matcher = PATTERN.matcher(s);
        if (matcher.matches()) {
            void var1_1;
            return new DLNADoc(matcher.group(1), var1_1.group(2));
        }
        throw new InvalidValueException("Can't parse DLNADoc: " + string);
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(Object o) {
        void var1_1;
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DLNADoc dlnaDoc = (DLNADoc)o;
        if (!this.devClass.equals(dlnaDoc.devClass)) {
            return false;
        }
        return this.version.equals(var1_1.version);
    }

    /*
     * WARNING - void declaration
     */
    public int hashCode() {
        void var1_1;
        int result = this.devClass.hashCode();
        var1_1 = var1_1 * 31 + this.version.hashCode();
        return (int)var1_1;
    }

    public String toString() {
        return this.getDevClass() + "-" + this.getVersion();
    }

    public static enum Version {
        V1_0("1.00"),
        V1_5("1.50");

        final String s;

        /*
         * WARNING - void declaration
         */
        private Version(String s) {
            void var3_3;
            this.s = var3_3;
        }

        public final String toString() {
            return this.s;
        }
    }
}

