/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.model.profile;

import java.net.InetAddress;
import org.jupnp.http.RequestInfo;
import org.jupnp.model.message.Connection;
import org.jupnp.model.message.StreamRequestMessage;
import org.jupnp.model.message.UpnpHeaders;
import org.jupnp.model.message.header.UpnpHeader;
import org.jupnp.model.message.header.UserAgentHeader;
import org.jupnp.model.profile.ClientInfo;

public class RemoteClientInfo
extends ClientInfo {
    protected final Connection connection;
    protected final UpnpHeaders extraResponseHeaders = new UpnpHeaders();

    public RemoteClientInfo() {
        this((StreamRequestMessage)null);
    }

    /*
     * WARNING - void declaration
     */
    public RemoteClientInfo(StreamRequestMessage requestMessage) {
        this(requestMessage != null ? requestMessage.getConnection() : null, requestMessage != null ? var1_1.getHeaders() : new UpnpHeaders());
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public RemoteClientInfo(Connection connection, UpnpHeaders requestHeaders) {
        super((UpnpHeaders)var2_2);
        void var1_1;
        void var2_2;
        this.connection = var1_1;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public boolean isRequestCancelled() {
        return !this.getConnection().isOpen();
    }

    public void throwIfRequestCancelled() throws InterruptedException {
        if (this.isRequestCancelled()) {
            throw new InterruptedException("Client's request cancelled");
        }
    }

    public InetAddress getRemoteAddress() {
        return this.getConnection().getRemoteAddress();
    }

    public InetAddress getLocalAddress() {
        return this.getConnection().getLocalAddress();
    }

    public UpnpHeaders getExtraResponseHeaders() {
        return this.extraResponseHeaders;
    }

    /*
     * WARNING - void declaration
     */
    public void setResponseUserAgent(String userAgent) {
        void var1_1;
        this.setResponseUserAgent(new UserAgentHeader((String)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public void setResponseUserAgent(UserAgentHeader userAgentHeader) {
        void var1_1;
        this.getExtraResponseHeaders().add(UpnpHeader.Type.USER_AGENT, (UpnpHeader)var1_1);
    }

    public boolean isWMPRequest() {
        return RequestInfo.isWMPRequest(this.getRequestUserAgent());
    }

    public boolean isXbox360Request() {
        return RequestInfo.isXbox360Request(this.getRequestUserAgent(), this.getRequestHeaders().getFirstHeaderString(UpnpHeader.Type.SERVER));
    }

    public boolean isPS3Request() {
        return RequestInfo.isPS3Request(this.getRequestUserAgent(), this.getRequestHeaders().getFirstHeaderString(UpnpHeader.Type.EXT_AV_CLIENT_INFO));
    }

    @Override
    public String toString() {
        return "(" + this.getClass().getSimpleName() + ") Remote Address: " + String.valueOf(this.getRemoteAddress());
    }
}

