/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.model.meta;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jupnp.model.Validatable;
import org.jupnp.model.ValidationError;
import org.jupnp.model.meta.StateVariableAllowedValueRange;
import org.jupnp.model.types.Datatype;
import org.jupnp.util.SpecificationViolationReporter;

public class StateVariableTypeDetails
implements Validatable {
    private final Datatype datatype;
    private final String defaultValue;
    private final String[] allowedValues;
    private final StateVariableAllowedValueRange allowedValueRange;

    /*
     * WARNING - void declaration
     */
    public StateVariableTypeDetails(Datatype datatype) {
        this((Datatype)var1_1, null, null, null);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public StateVariableTypeDetails(Datatype datatype, String defaultValue) {
        this((Datatype)var1_1, (String)var2_2, null, null);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public StateVariableTypeDetails(Datatype datatype, String defaultValue, String[] allowedValues, StateVariableAllowedValueRange allowedValueRange) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.datatype = var1_1;
        this.defaultValue = var2_2;
        this.allowedValues = var3_3;
        this.allowedValueRange = allowedValueRange;
    }

    public Datatype getDatatype() {
        return this.datatype;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    /*
     * WARNING - void declaration
     */
    public String[] getAllowedValues() {
        StateVariableTypeDetails stateVariableTypeDetails = this;
        if (!stateVariableTypeDetails.foundDefaultInAllowedValues(stateVariableTypeDetails.defaultValue, this.allowedValues)) {
            void var1_1;
            ArrayList<String> list = new ArrayList<String>(Arrays.asList(this.allowedValues));
            list.add(this.getDefaultValue());
            void v1 = var1_1;
            return v1.toArray(new String[v1.size()]);
        }
        return this.allowedValues;
    }

    public StateVariableAllowedValueRange getAllowedValueRange() {
        return this.allowedValueRange;
    }

    /*
     * WARNING - void declaration
     */
    protected boolean foundDefaultInAllowedValues(String defaultValue, String[] allowedValues) {
        void var2_2;
        if (defaultValue == null || allowedValues == null) {
            return true;
        }
        void var5_3 = var2_2;
        int n = ((void)var5_3).length;
        int n2 = 0;
        while (n2 < n) {
            var2_2 = var5_3[n2];
            if (var2_2.equals(defaultValue)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public List<ValidationError> validate() {
        void var1_1;
        ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
        if (this.getDatatype() == null) {
            errors.add(new ValidationError(this.getClass(), "datatype", "Service state variable has no datatype"));
        }
        if (this.getAllowedValues() != null) {
            if (this.getAllowedValueRange() != null) {
                errors.add(new ValidationError(this.getClass(), "allowedValues", "Allowed value list of state variable can not also be restricted with allowed value range"));
            }
            if (!Datatype.Builtin.STRING.equals((Object)this.getDatatype().getBuiltin())) {
                errors.add(new ValidationError(this.getClass(), "allowedValues", "Allowed value list of state variable only available for string datatype, not: " + String.valueOf(this.getDatatype())));
            }
            String[] stringArray = this.getAllowedValues();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                if (s.length() > 31) {
                    void var2_5;
                    SpecificationViolationReporter.report("Allowed value string must be less than 32 chars: {}", var2_5);
                }
                ++n2;
            }
            StateVariableTypeDetails stateVariableTypeDetails = this;
            if (!stateVariableTypeDetails.foundDefaultInAllowedValues(stateVariableTypeDetails.defaultValue, this.allowedValues)) {
                SpecificationViolationReporter.report("Allowed string values don't contain default value: {}", this.defaultValue);
            }
        }
        if (this.getAllowedValueRange() != null) {
            errors.addAll(this.getAllowedValueRange().validate());
        }
        return var1_1;
    }
}

