/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.model.meta;

import java.util.ArrayList;
import java.util.List;
import org.jupnp.model.ModelUtil;
import org.jupnp.model.Validatable;
import org.jupnp.model.ValidationError;
import org.jupnp.model.meta.Service;
import org.jupnp.model.meta.StateVariableEventDetails;
import org.jupnp.model.meta.StateVariableTypeDetails;
import org.jupnp.model.types.Datatype;
import org.jupnp.util.SpecificationViolationReporter;

public class StateVariable<S extends Service>
implements Validatable {
    private final String name;
    private final StateVariableTypeDetails type;
    private final StateVariableEventDetails eventDetails;
    private S service;

    /*
     * WARNING - void declaration
     */
    public StateVariable(String name, StateVariableTypeDetails type) {
        this((String)var1_1, (StateVariableTypeDetails)var2_2, new StateVariableEventDetails());
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public StateVariable(String name, StateVariableTypeDetails type, StateVariableEventDetails eventDetails) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.name = var1_1;
        this.type = var2_2;
        this.eventDetails = var3_3;
    }

    public String getName() {
        return this.name;
    }

    public StateVariableTypeDetails getTypeDetails() {
        return this.type;
    }

    public StateVariableEventDetails getEventDetails() {
        return this.eventDetails;
    }

    public S getService() {
        return this.service;
    }

    /*
     * WARNING - void declaration
     */
    void setService(S service) {
        void var1_1;
        if (this.service != null) {
            throw new IllegalStateException("Final value has been set already, model is immutable");
        }
        this.service = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public List<ValidationError> validate() {
        void var1_1;
        ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
        if (this.getName() == null || this.getName().isEmpty()) {
            errors.add(new ValidationError(this.getClass(), "name", "StateVariable without name of: " + String.valueOf(this.getService())));
        } else if (!ModelUtil.isValidUDAName(this.getName())) {
            SpecificationViolationReporter.report(((Service)this.getService()).getDevice(), "Invalid state variable name: {}", new Object[]{this});
        }
        errors.addAll(this.getTypeDetails().validate());
        return var1_1;
    }

    public boolean isModeratedNumericType() {
        return Datatype.Builtin.isNumeric(this.getTypeDetails().getDatatype().getBuiltin()) && this.getEventDetails().getEventMinimumDelta() > 0;
    }

    public StateVariable<S> deepCopy() {
        return new StateVariable<S>(this.getName(), this.getTypeDetails(), this.getEventDetails());
    }

    /*
     * WARNING - void declaration
     */
    public String toString() {
        void var1_1;
        StringBuilder sb = new StringBuilder();
        sb.append("(").append(this.getClass().getSimpleName());
        sb.append(", Name: ").append(this.getName());
        sb.append(", Type: ").append(this.getTypeDetails().getDatatype().getDisplayString()).append(")");
        if (!this.getEventDetails().isSendEvents()) {
            sb.append(" (No Events)");
        }
        if (this.getTypeDetails().getDefaultValue() != null) {
            sb.append(" Default Value: '").append(this.getTypeDetails().getDefaultValue()).append("'");
        }
        if (this.getTypeDetails().getAllowedValues() != null) {
            sb.append(" Allowed Values: ");
            String[] stringArray = this.getTypeDetails().getAllowedValues();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                void var2_5;
                String s = stringArray[n2];
                sb.append((String)var2_5).append("|");
                ++n2;
            }
        }
        return var1_1.toString();
    }
}

