/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.model.meta;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jupnp.model.ServiceReference;
import org.jupnp.model.Validatable;
import org.jupnp.model.ValidationError;
import org.jupnp.model.ValidationException;
import org.jupnp.model.meta.Action;
import org.jupnp.model.meta.ActionArgument;
import org.jupnp.model.meta.Device;
import org.jupnp.model.meta.DeviceIdentity;
import org.jupnp.model.meta.StateVariable;
import org.jupnp.model.meta.StateVariableTypeDetails;
import org.jupnp.model.types.Datatype;
import org.jupnp.model.types.ServiceId;
import org.jupnp.model.types.ServiceType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Service<D extends Device, S extends Service> {
    private final Logger logger = LoggerFactory.getLogger(Service.class);
    private final ServiceType serviceType;
    private final ServiceId serviceId;
    private final Map<String, Action> actions = new HashMap<String, Action>();
    private final Map<String, StateVariable> stateVariables = new HashMap<String, StateVariable>();
    private D device;

    /*
     * WARNING - void declaration
     */
    protected Service(ServiceType serviceType, ServiceId serviceId) throws ValidationException {
        this((ServiceType)var1_1, (ServiceId)var2_2, null, null);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    protected Service(ServiceType serviceType, ServiceId serviceId, Action<S>[] actions, StateVariable<S>[] stateVariables) throws ValidationException {
        StateVariable<S>[] stateVariableArray;
        void var2_2;
        this.serviceType = serviceType;
        this.serviceId = var2_2;
        if (actions != null) {
            void var3_5;
            stateVariableArray = var3_5;
            int n = stateVariableArray.length;
            int n2 = 0;
            while (n2 < n) {
                StateVariable<Service> action = stateVariableArray[n2];
                this.actions.put(((Action)((Object)action)).getName(), (Action)((Object)action));
                ((Action)((Object)action)).setService(this);
                ++n2;
            }
        }
        if (stateVariables != null) {
            stateVariableArray = stateVariables;
            int n = stateVariables.length;
            int n3 = 0;
            while (n3 < n) {
                void var1_1;
                StateVariable<S> stateVariable = stateVariableArray[n3];
                this.stateVariables.put(stateVariable.getName(), stateVariable);
                var1_1.setService(this);
                ++n3;
            }
        }
    }

    public ServiceType getServiceType() {
        return this.serviceType;
    }

    public ServiceId getServiceId() {
        return this.serviceId;
    }

    public boolean hasActions() {
        return this.getActions() != null && this.getActions().length > 0;
    }

    public Action<S>[] getActions() {
        if (this.actions == null) {
            return null;
        }
        return this.actions.values().toArray(new Action[this.actions.values().size()]);
    }

    public boolean hasStateVariables() {
        return this.getStateVariables() != null && this.getStateVariables().length > 0;
    }

    public StateVariable<S>[] getStateVariables() {
        if (this.stateVariables == null) {
            return null;
        }
        return this.stateVariables.values().toArray(new StateVariable[this.stateVariables.values().size()]);
    }

    public D getDevice() {
        return this.device;
    }

    /*
     * WARNING - void declaration
     */
    void setDevice(D device) {
        void var1_1;
        if (this.device != null) {
            throw new IllegalStateException("Final value has been set already, model is immutable");
        }
        this.device = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public Action<S> getAction(String name) {
        void var1_1;
        if (this.actions == null) {
            return null;
        }
        return this.actions.get(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public StateVariable<S> getStateVariable(String name) {
        void var1_1;
        if ("VirtualQueryActionInput".equals(name)) {
            return new StateVariable("VirtualQueryActionInput", new StateVariableTypeDetails(Datatype.Builtin.STRING.getDatatype()));
        }
        if ("VirtualQueryActionOutput".equals(name)) {
            return new StateVariable("VirtualQueryActionOutput", new StateVariableTypeDetails(Datatype.Builtin.STRING.getDatatype()));
        }
        if (this.stateVariables == null) {
            return null;
        }
        return this.stateVariables.get(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public StateVariable<S> getRelatedStateVariable(ActionArgument argument) {
        void var1_1;
        return this.getStateVariable(var1_1.getRelatedStateVariableName());
    }

    /*
     * WARNING - void declaration
     */
    public Datatype<S> getDatatype(ActionArgument argument) {
        void var1_1;
        return this.getRelatedStateVariable((ActionArgument)var1_1).getTypeDetails().getDatatype();
    }

    public ServiceReference getReference() {
        return new ServiceReference(((DeviceIdentity)((Device)this.getDevice()).getIdentity()).getUdn(), this.getServiceId());
    }

    /*
     * WARNING - void declaration
     */
    public List<ValidationError> validate() {
        void var1_1;
        int n;
        int n2;
        Validatable[] validatableArray;
        ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
        if (this.getServiceType() == null) {
            errors.add(new ValidationError(this.getClass(), "serviceType", "Service type/info is required"));
        }
        if (this.getServiceId() == null) {
            errors.add(new ValidationError(this.getClass(), "serviceId", "Service ID is required"));
        }
        if (this.hasStateVariables()) {
            validatableArray = this.getStateVariables();
            n2 = validatableArray.length;
            n = 0;
            while (n < n2) {
                Validatable stateVariable = validatableArray[n];
                errors.addAll(((StateVariable)stateVariable).validate());
                ++n;
            }
        }
        if (this.hasActions()) {
            validatableArray = this.getActions();
            n2 = validatableArray.length;
            n = 0;
            while (n < n2) {
                Validatable action = validatableArray[n];
                List<ValidationError> actionErrors = ((Action)action).validate();
                if (!actionErrors.isEmpty()) {
                    this.actions.remove(((Action)action).getName());
                    this.logger.warn("Discarding invalid action of service '{}': {}", (Object)this.getServiceId(), (Object)((Action)action).getName());
                    if (this.logger.isDebugEnabled()) {
                        for (ValidationError actionError : actionErrors) {
                            this.logger.debug("Invalid action '{}': {}", (Object)((Action)action).getName(), (Object)actionError);
                        }
                    }
                }
                ++n;
            }
        }
        return var1_1;
    }

    public abstract Action getQueryStateVariableAction();

    public String toString() {
        return "(" + this.getClass().getSimpleName() + ") ServiceId: " + String.valueOf(this.getServiceId());
    }
}

