/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.model.meta;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.jupnp.model.ValidationError;
import org.jupnp.model.ValidationException;
import org.jupnp.model.meta.Action;
import org.jupnp.model.meta.QueryStateVariableAction;
import org.jupnp.model.meta.RemoteDevice;
import org.jupnp.model.meta.Service;
import org.jupnp.model.meta.StateVariable;
import org.jupnp.model.types.ServiceId;
import org.jupnp.model.types.ServiceType;

public class RemoteService
extends Service<RemoteDevice, RemoteService> {
    private final URI descriptorURI;
    private final URI controlURI;
    private final URI eventSubscriptionURI;

    /*
     * WARNING - void declaration
     */
    public RemoteService(ServiceType serviceType, ServiceId serviceId, URI descriptorURI, URI controlURI, URI eventSubscriptionURI) throws ValidationException {
        this((ServiceType)var1_1, (ServiceId)var2_2, (URI)var3_3, controlURI, eventSubscriptionURI, null, null);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public RemoteService(ServiceType serviceType, ServiceId serviceId, URI descriptorURI, URI controlURI, URI eventSubscriptionURI, Action<RemoteService>[] actions, StateVariable<RemoteService>[] stateVariables) throws ValidationException {
        super(serviceType, (ServiceId)var2_2, actions, stateVariables);
        void var3_3;
        void var2_2;
        this.descriptorURI = var3_3;
        this.controlURI = controlURI;
        this.eventSubscriptionURI = eventSubscriptionURI;
        List<ValidationError> errors = this.validateThis();
        if (!errors.isEmpty()) {
            void var1_1;
            throw new ValidationException("Validation of device graph failed, call getErrors() on exception", (List<ValidationError>)var1_1);
        }
    }

    @Override
    public Action getQueryStateVariableAction() {
        return new QueryStateVariableAction<RemoteService>(this);
    }

    public URI getDescriptorURI() {
        return this.descriptorURI;
    }

    public URI getControlURI() {
        return this.controlURI;
    }

    public URI getEventSubscriptionURI() {
        return this.eventSubscriptionURI;
    }

    /*
     * WARNING - void declaration
     */
    public List<ValidationError> validateThis() {
        void var1_1;
        ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
        if (this.getDescriptorURI() == null) {
            errors.add(new ValidationError(this.getClass(), "descriptorURI", "Descriptor location (SCPDURL) is required"));
        }
        if (this.getControlURI() == null) {
            errors.add(new ValidationError(this.getClass(), "controlURI", "Control URL is required"));
        }
        if (this.getEventSubscriptionURI() == null) {
            errors.add(new ValidationError(this.getClass(), "eventSubscriptionURI", "Event subscription URL is required"));
        }
        return var1_1;
    }

    @Override
    public String toString() {
        return "(" + this.getClass().getSimpleName() + ") Descriptor: " + String.valueOf(this.getDescriptorURI());
    }
}

