/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.model.meta;

import java.net.InetAddress;
import java.net.URL;
import org.jupnp.model.ModelUtil;
import org.jupnp.model.message.discovery.IncomingNotificationRequest;
import org.jupnp.model.message.discovery.IncomingSearchResponse;
import org.jupnp.model.meta.DeviceIdentity;
import org.jupnp.model.types.UDN;

public class RemoteDeviceIdentity
extends DeviceIdentity {
    private final URL descriptorURL;
    private final byte[] interfaceMacAddress;
    private final InetAddress discoveredOnLocalAddress;

    /*
     * WARNING - void declaration
     */
    public RemoteDeviceIdentity(UDN udn, RemoteDeviceIdentity template) {
        this((UDN)var1_1, template.getMaxAgeSeconds(), template.getDescriptorURL(), template.getInterfaceMacAddress(), var2_2.getDiscoveredOnLocalAddress());
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public RemoteDeviceIdentity(UDN udn, Integer maxAgeSeconds, URL descriptorURL, byte[] interfaceMacAddress, InetAddress discoveredOnLocalAddress) {
        super((UDN)var1_1, (Integer)var2_2);
        void var3_3;
        void var2_2;
        void var1_1;
        this.descriptorURL = var3_3;
        this.interfaceMacAddress = interfaceMacAddress;
        this.discoveredOnLocalAddress = discoveredOnLocalAddress;
    }

    /*
     * WARNING - void declaration
     */
    public RemoteDeviceIdentity(IncomingNotificationRequest notificationRequest) {
        this(notificationRequest.getUDN(), notificationRequest.getMaxAge(), notificationRequest.getLocationURL(), notificationRequest.getInterfaceMacHeader(), var1_1.getLocalAddress());
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public RemoteDeviceIdentity(IncomingSearchResponse searchResponse) {
        this(searchResponse.getRootDeviceUDN(), searchResponse.getMaxAge(), searchResponse.getLocationURL(), searchResponse.getInterfaceMacHeader(), var1_1.getLocalAddress());
        void var1_1;
    }

    public URL getDescriptorURL() {
        return this.descriptorURL;
    }

    public byte[] getInterfaceMacAddress() {
        return this.interfaceMacAddress;
    }

    public InetAddress getDiscoveredOnLocalAddress() {
        return this.discoveredOnLocalAddress;
    }

    /*
     * WARNING - void declaration
     */
    public byte[] getWakeOnLANBytes() {
        void var1_1;
        if (this.getInterfaceMacAddress() == null) {
            return null;
        }
        byte[] bytes = new byte[6 + 16 * this.getInterfaceMacAddress().length];
        int i = 0;
        while (i < 6) {
            bytes[i] = -1;
            ++i;
        }
        i = 6;
        while (i < bytes.length) {
            System.arraycopy(this.getInterfaceMacAddress(), 0, bytes, i, this.getInterfaceMacAddress().length);
            i += this.getInterfaceMacAddress().length;
        }
        return var1_1;
    }

    @Override
    public String toString() {
        if (ModelUtil.ANDROID_RUNTIME) {
            return "(RemoteDeviceIdentity) UDN: " + String.valueOf(this.getUdn()) + ", Descriptor: " + String.valueOf(this.getDescriptorURL());
        }
        return "(" + this.getClass().getSimpleName() + ") UDN: " + String.valueOf(this.getUdn()) + ", Descriptor: " + String.valueOf(this.getDescriptorURL());
    }
}

