/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.model.meta;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jupnp.model.ModelUtil;
import org.jupnp.model.ServiceManager;
import org.jupnp.model.ValidationException;
import org.jupnp.model.action.ActionExecutor;
import org.jupnp.model.meta.Action;
import org.jupnp.model.meta.LocalDevice;
import org.jupnp.model.meta.Service;
import org.jupnp.model.meta.StateVariable;
import org.jupnp.model.state.StateVariableAccessor;
import org.jupnp.model.types.ServiceId;
import org.jupnp.model.types.ServiceType;

public class LocalService<T>
extends Service<LocalDevice, LocalService> {
    protected final Map<Action, ActionExecutor> actionExecutors;
    protected final Map<StateVariable, StateVariableAccessor> stateVariableAccessors;
    protected final Set<Class> stringConvertibleTypes;
    protected final boolean supportsQueryStateVariables;
    protected ServiceManager manager;

    /*
     * WARNING - void declaration
     */
    public LocalService(ServiceType serviceType, ServiceId serviceId, Action[] actions, StateVariable[] stateVariables) throws ValidationException {
        super((ServiceType)var1_1, (ServiceId)var2_2, (Action<S>[])var3_3, stateVariables);
        void var3_3;
        void var2_2;
        void var1_1;
        this.manager = null;
        this.actionExecutors = new HashMap<Action, ActionExecutor>();
        this.stateVariableAccessors = new HashMap<StateVariable, StateVariableAccessor>();
        this.stringConvertibleTypes = new HashSet<Class>();
        this.supportsQueryStateVariables = true;
    }

    /*
     * WARNING - void declaration
     */
    public LocalService(ServiceType serviceType, ServiceId serviceId, Map<Action, ActionExecutor> actionExecutors, Map<StateVariable, StateVariableAccessor> stateVariableAccessors, Set<Class> stringConvertibleTypes, boolean supportsQueryStateVariables) throws ValidationException {
        super((ServiceType)var1_1, (ServiceId)var2_2, actionExecutors.keySet().toArray(new Action[actionExecutors.size()]), stateVariableAccessors.keySet().toArray(new StateVariable[stateVariableAccessors.size()]));
        void var3_3;
        void var2_2;
        void var1_1;
        this.supportsQueryStateVariables = supportsQueryStateVariables;
        this.stringConvertibleTypes = stringConvertibleTypes;
        this.stateVariableAccessors = stateVariableAccessors;
        this.actionExecutors = var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public synchronized void setManager(ServiceManager<T> manager) {
        void var1_1;
        if (this.manager != null) {
            throw new IllegalStateException("Manager is final");
        }
        this.manager = var1_1;
    }

    public synchronized ServiceManager<T> getManager() {
        if (this.manager == null) {
            throw new IllegalStateException("Unmanaged service, no implementation instance available");
        }
        return this.manager;
    }

    public boolean isSupportsQueryStateVariables() {
        return this.supportsQueryStateVariables;
    }

    public Set<Class> getStringConvertibleTypes() {
        return this.stringConvertibleTypes;
    }

    /*
     * WARNING - void declaration
     */
    public boolean isStringConvertibleType(Object o) {
        void var1_1;
        return o != null && this.isStringConvertibleType(var1_1.getClass());
    }

    /*
     * WARNING - void declaration
     */
    public boolean isStringConvertibleType(Class clazz) {
        void var1_1;
        return ModelUtil.isStringConvertibleType(this.getStringConvertibleTypes(), (Class)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public StateVariableAccessor getAccessor(String stateVariableName) {
        StateVariable sv = this.getStateVariable(stateVariableName);
        if (sv != null) {
            void var1_1;
            return this.getAccessor((StateVariable)var1_1);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public StateVariableAccessor getAccessor(StateVariable stateVariable) {
        void var1_1;
        return this.stateVariableAccessors.get(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public ActionExecutor getExecutor(String actionName) {
        Action action = this.getAction(actionName);
        if (action != null) {
            void var1_1;
            return this.getExecutor((Action)var1_1);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public ActionExecutor getExecutor(Action action) {
        void var1_1;
        return this.actionExecutors.get(var1_1);
    }

    @Override
    public Action getQueryStateVariableAction() {
        return this.getAction("QueryStateVariable");
    }

    @Override
    public String toString() {
        return super.toString() + ", Manager: " + String.valueOf(this.manager);
    }
}

