/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.model.meta;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.List;
import org.jupnp.model.Validatable;
import org.jupnp.model.ValidationError;
import org.jupnp.model.meta.Device;
import org.jupnp.model.types.BinHexDatatype;
import org.jupnp.util.MimeType;
import org.jupnp.util.SpecificationViolationReporter;
import org.jupnp.util.URIUtil;
import org.jupnp.util.io.IO;

public class Icon
implements Validatable {
    private final MimeType mimeType;
    private final int width;
    private final int height;
    private final int depth;
    private final URI uri;
    private final byte[] data;
    private Device device;

    /*
     * WARNING - void declaration
     */
    public Icon(String mimeType, int width, int height, int depth, URI uri) {
        this(mimeType != null && !mimeType.isEmpty() ? MimeType.valueOf((String)var1_1) : null, (int)var2_2, (int)var3_3, depth, uri, null);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public Icon(String mimeType, int width, int height, int depth, URL url) throws IOException {
        this((String)var1_1, (int)var2_2, (int)var3_3, depth, new File(URIUtil.toURI(url)));
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public Icon(String mimeType, int width, int height, int depth, File file) throws IOException {
        this((String)var1_1, (int)var2_2, (int)var3_3, depth, file.getName(), Files.readAllBytes(file.toPath()));
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public Icon(String mimeType, int width, int height, int depth, String uniqueName, InputStream is) throws IOException {
        this((String)var1_1, (int)var2_2, (int)var3_3, depth, uniqueName, IO.readAllBytes(is));
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public Icon(String mimeType, int width, int height, int depth, String uniqueName, byte[] data) {
        this(mimeType != null && !mimeType.isEmpty() ? MimeType.valueOf((String)var1_1) : null, (int)var2_2, (int)var3_3, depth, URI.create(uniqueName), data);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public Icon(String mimeType, int width, int height, int depth, String uniqueName, String binHexEncoded) {
        this((String)var1_1, (int)var2_2, (int)var3_3, depth, uniqueName, binHexEncoded != null && !binHexEncoded.isEmpty() ? new BinHexDatatype().valueOf(binHexEncoded) : null);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    protected Icon(MimeType mimeType, int width, int height, int depth, URI uri, byte[] data) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.mimeType = var1_1;
        this.width = var2_2;
        this.height = var3_3;
        this.depth = depth;
        this.uri = uri;
        this.data = data;
    }

    public MimeType getMimeType() {
        return this.mimeType;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getDepth() {
        return this.depth;
    }

    public URI getUri() {
        return this.uri;
    }

    public byte[] getData() {
        return this.data;
    }

    public Device getDevice() {
        return this.device;
    }

    /*
     * WARNING - void declaration
     */
    void setDevice(Device device) {
        void var1_1;
        if (this.device != null) {
            throw new IllegalStateException("Final value has been set already, model is immutable");
        }
        this.device = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public List<ValidationError> validate() {
        void var1_1;
        ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
        if (this.getMimeType() == null) {
            SpecificationViolationReporter.report(this.getDevice(), "Invalid icon, missing mime type: {}", this);
        }
        if (this.getWidth() == 0) {
            SpecificationViolationReporter.report(this.getDevice(), "Invalid icon, missing width: {}", this);
        }
        if (this.getHeight() == 0) {
            SpecificationViolationReporter.report(this.getDevice(), "Invalid icon, missing height: {}", this);
        }
        if (this.getDepth() == 0) {
            SpecificationViolationReporter.report(this.getDevice(), "Invalid icon, missing bitmap depth: {}", this);
        }
        if (this.getUri() == null) {
            errors.add(new ValidationError(this.getClass(), "uri", "URL is required"));
        } else {
            try {
                URL uRL = this.getUri().toURL();
                if (uRL == null) {
                    throw new MalformedURLException();
                }
            }
            catch (MalformedURLException e) {
                void var2_3;
                errors.add(new ValidationError(this.getClass(), "uri", "URL must be valid: " + var2_3.getMessage()));
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        return var1_1;
    }

    public Icon deepCopy() {
        return new Icon(this.getMimeType(), this.getWidth(), this.getHeight(), this.getDepth(), this.getUri(), this.getData());
    }

    public String toString() {
        return "Icon(" + this.getWidth() + "x" + this.getHeight() + ", MIME: " + String.valueOf(this.getMimeType()) + ") " + String.valueOf(this.getUri());
    }
}

