/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.model.meta;

import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.jupnp.model.Validatable;
import org.jupnp.model.ValidationError;
import org.jupnp.model.meta.ManufacturerDetails;
import org.jupnp.model.meta.ModelDetails;
import org.jupnp.model.types.DLNACaps;
import org.jupnp.model.types.DLNADoc;
import org.jupnp.util.SpecificationViolationReporter;

public class DeviceDetails
implements Validatable {
    private final URL baseURL;
    private final String friendlyName;
    private final ManufacturerDetails manufacturerDetails;
    private final ModelDetails modelDetails;
    private final String serialNumber;
    private final String upc;
    private final URI presentationURI;
    private final DLNADoc[] dlnaDocs;
    private final DLNACaps dlnaCaps;
    private final DLNACaps secProductCaps;

    /*
     * WARNING - void declaration
     */
    public DeviceDetails(String friendlyName) {
        this(null, (String)var1_1, null, null, null, null, null);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public DeviceDetails(String friendlyName, DLNADoc[] dlnaDocs, DLNACaps dlnaCaps) {
        this(null, (String)var1_1, null, null, null, null, null, (DLNADoc[])var2_2, (DLNACaps)var3_3);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public DeviceDetails(String friendlyName, ManufacturerDetails manufacturerDetails) {
        this(null, (String)var1_1, (ManufacturerDetails)var2_2, null, null, null, null);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public DeviceDetails(String friendlyName, ManufacturerDetails manufacturerDetails, DLNADoc[] dlnaDocs, DLNACaps dlnaCaps) {
        this(null, (String)var1_1, (ManufacturerDetails)var2_2, null, null, null, null, (DLNADoc[])var3_3, dlnaCaps);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public DeviceDetails(String friendlyName, ManufacturerDetails manufacturerDetails, ModelDetails modelDetails) {
        this(null, (String)var1_1, (ManufacturerDetails)var2_2, (ModelDetails)var3_3, null, null, null);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public DeviceDetails(String friendlyName, ManufacturerDetails manufacturerDetails, ModelDetails modelDetails, DLNADoc[] dlnaDocs, DLNACaps dlnaCaps) {
        this(null, (String)var1_1, (ManufacturerDetails)var2_2, (ModelDetails)var3_3, null, null, null, dlnaDocs, dlnaCaps);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public DeviceDetails(String friendlyName, ManufacturerDetails manufacturerDetails, ModelDetails modelDetails, DLNADoc[] dlnaDocs, DLNACaps dlnaCaps, DLNACaps secProductCaps) {
        this(null, (String)var1_1, (ManufacturerDetails)var2_2, (ModelDetails)var3_3, null, null, null, dlnaDocs, dlnaCaps, secProductCaps);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public DeviceDetails(String friendlyName, ManufacturerDetails manufacturerDetails, ModelDetails modelDetails, String serialNumber, String upc) {
        this(null, (String)var1_1, (ManufacturerDetails)var2_2, (ModelDetails)var3_3, serialNumber, upc, null);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public DeviceDetails(String friendlyName, ManufacturerDetails manufacturerDetails, ModelDetails modelDetails, String serialNumber, String upc, DLNADoc[] dlnaDocs, DLNACaps dlnaCaps) {
        this(null, (String)var1_1, (ManufacturerDetails)var2_2, (ModelDetails)var3_3, serialNumber, upc, null, dlnaDocs, dlnaCaps);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public DeviceDetails(String friendlyName, URI presentationURI) {
        this(null, (String)var1_1, null, null, null, null, (URI)var2_2);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public DeviceDetails(String friendlyName, URI presentationURI, DLNADoc[] dlnaDocs, DLNACaps dlnaCaps) {
        this(null, (String)var1_1, null, null, null, null, (URI)var2_2, (DLNADoc[])var3_3, dlnaCaps);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public DeviceDetails(String friendlyName, ManufacturerDetails manufacturerDetails, ModelDetails modelDetails, URI presentationURI) {
        this(null, (String)var1_1, (ManufacturerDetails)var2_2, (ModelDetails)var3_3, null, null, presentationURI);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public DeviceDetails(String friendlyName, ManufacturerDetails manufacturerDetails, ModelDetails modelDetails, URI presentationURI, DLNADoc[] dlnaDocs, DLNACaps dlnaCaps) {
        this(null, (String)var1_1, (ManufacturerDetails)var2_2, (ModelDetails)var3_3, null, null, presentationURI, dlnaDocs, dlnaCaps);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public DeviceDetails(String friendlyName, ManufacturerDetails manufacturerDetails, ModelDetails modelDetails, String serialNumber, String upc, URI presentationURI) {
        this(null, (String)var1_1, (ManufacturerDetails)var2_2, (ModelDetails)var3_3, serialNumber, upc, presentationURI);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public DeviceDetails(String friendlyName, ManufacturerDetails manufacturerDetails, ModelDetails modelDetails, String serialNumber, String upc, URI presentationURI, DLNADoc[] dlnaDocs, DLNACaps dlnaCaps) {
        this(null, (String)var1_1, (ManufacturerDetails)var2_2, (ModelDetails)var3_3, serialNumber, upc, presentationURI, dlnaDocs, dlnaCaps);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public DeviceDetails(String friendlyName, ManufacturerDetails manufacturerDetails, ModelDetails modelDetails, String serialNumber, String upc, String presentationURI) throws IllegalArgumentException {
        this(null, (String)var1_1, (ManufacturerDetails)var2_2, (ModelDetails)var3_3, serialNumber, upc, URI.create(presentationURI));
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public DeviceDetails(String friendlyName, ManufacturerDetails manufacturerDetails, ModelDetails modelDetails, String serialNumber, String upc, String presentationURI, DLNADoc[] dlnaDocs, DLNACaps dlnaCaps) throws IllegalArgumentException {
        this(null, (String)var1_1, (ManufacturerDetails)var2_2, (ModelDetails)var3_3, serialNumber, upc, URI.create(presentationURI), dlnaDocs, dlnaCaps);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public DeviceDetails(URL baseURL, String friendlyName, ManufacturerDetails manufacturerDetails, ModelDetails modelDetails, String serialNumber, String upc, URI presentationURI) {
        this((URL)var1_1, (String)var2_2, (ManufacturerDetails)var3_3, modelDetails, serialNumber, upc, presentationURI, null, null);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public DeviceDetails(URL baseURL, String friendlyName, ManufacturerDetails manufacturerDetails, ModelDetails modelDetails, String serialNumber, String upc, URI presentationURI, DLNADoc[] dlnaDocs, DLNACaps dlnaCaps) {
        this((URL)var1_1, (String)var2_2, (ManufacturerDetails)var3_3, modelDetails, serialNumber, upc, presentationURI, dlnaDocs, dlnaCaps, null);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public DeviceDetails(URL baseURL, String friendlyName, ManufacturerDetails manufacturerDetails, ModelDetails modelDetails, String serialNumber, String upc, URI presentationURI, DLNADoc[] dlnaDocs, DLNACaps dlnaCaps, DLNACaps secProductCaps) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.baseURL = var1_1;
        this.friendlyName = var2_2;
        this.manufacturerDetails = manufacturerDetails == null ? new ManufacturerDetails() : var3_3;
        this.modelDetails = modelDetails == null ? new ModelDetails() : modelDetails;
        this.serialNumber = serialNumber;
        this.upc = upc;
        this.presentationURI = presentationURI;
        this.dlnaDocs = dlnaDocs != null ? dlnaDocs : new DLNADoc[]{};
        this.dlnaCaps = dlnaCaps;
        this.secProductCaps = secProductCaps;
    }

    public URL getBaseURL() {
        return this.baseURL;
    }

    public String getFriendlyName() {
        return this.friendlyName;
    }

    public ManufacturerDetails getManufacturerDetails() {
        return this.manufacturerDetails;
    }

    public ModelDetails getModelDetails() {
        return this.modelDetails;
    }

    public String getSerialNumber() {
        return this.serialNumber;
    }

    public String getUpc() {
        return this.upc;
    }

    public URI getPresentationURI() {
        return this.presentationURI;
    }

    public DLNADoc[] getDlnaDocs() {
        return this.dlnaDocs;
    }

    public DLNACaps getDlnaCaps() {
        return this.dlnaCaps;
    }

    public DLNACaps getSecProductCaps() {
        return this.secProductCaps;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public List<ValidationError> validate() {
        void var1_1;
        ArrayList errors = new ArrayList();
        if (this.getUpc() != null) {
            if (this.getUpc().length() != 12) {
                SpecificationViolationReporter.report("UPC must be 12 digits: '" + this.getUpc() + "' for device '" + this.getFriendlyName() + "'", new Object[0]);
            } else {
                try {
                    Long.parseLong(this.getUpc());
                }
                catch (NumberFormatException numberFormatException) {
                    SpecificationViolationReporter.report("UPC must be 12 digits all-numeric: '{}' for device '{}'", this.getUpc(), this.getFriendlyName());
                }
            }
        }
        return var1_1;
    }
}

