/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.model.meta;

import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.jupnp.model.Namespace;
import org.jupnp.model.Validatable;
import org.jupnp.model.ValidationError;
import org.jupnp.model.ValidationException;
import org.jupnp.model.meta.Action;
import org.jupnp.model.meta.DeviceDetails;
import org.jupnp.model.meta.DeviceIdentity;
import org.jupnp.model.meta.Icon;
import org.jupnp.model.meta.ModelDetails;
import org.jupnp.model.meta.Service;
import org.jupnp.model.meta.StateVariable;
import org.jupnp.model.meta.UDAVersion;
import org.jupnp.model.profile.RemoteClientInfo;
import org.jupnp.model.resource.Resource;
import org.jupnp.model.types.DeviceType;
import org.jupnp.model.types.ServiceId;
import org.jupnp.model.types.ServiceType;
import org.jupnp.model.types.UDN;
import org.jupnp.util.SpecificationViolationReporter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Device<DI extends DeviceIdentity, D extends Device, S extends Service>
implements Validatable {
    private final Logger logger = LoggerFactory.getLogger(Device.class);
    private final DI identity;
    private final UDAVersion version;
    private final DeviceType type;
    private final DeviceDetails details;
    private final Icon[] icons;
    protected final S[] services;
    protected final D[] embeddedDevices;
    private D parentDevice;

    /*
     * WARNING - void declaration
     */
    protected Device(DI identity) throws ValidationException {
        this((DeviceIdentity)var1_1, null, null, null, null, null);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    protected Device(DI identity, DeviceType type, DeviceDetails details, Icon[] icons, S[] services) throws ValidationException {
        this((DeviceIdentity)var1_1, null, (DeviceType)var2_2, (DeviceDetails)var3_3, icons, (Service[])services, null);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    protected Device(DI identity, DeviceType type, DeviceDetails details, Icon[] icons, S[] services, D[] embeddedDevices) throws ValidationException {
        this((DeviceIdentity)var1_1, null, (DeviceType)var2_2, (DeviceDetails)var3_3, icons, (Service[])services, (Device[])embeddedDevices);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    protected Device(DI identity, UDAVersion version, DeviceType type2, DeviceDetails details2, Icon[] icons2, S[] services, D[] embeddedDevices) throws ValidationException {
        void var3_6;
        void var2_3;
        D[] DArray;
        this.identity = identity;
        this.version = version == null ? new UDAVersion() : version;
        this.type = type2;
        this.details = details2;
        ArrayList<Icon> validIcons = new ArrayList<Icon>();
        if (icons2 != null) {
            int details2 = icons2.length;
            int type2 = 0;
            while (type2 < details2) {
                Icon icon = icons2[type2];
                if (icon != null) {
                    icon.setDevice(this);
                    List<ValidationError> iconErrors = icon.validate();
                    if (iconErrors.isEmpty()) {
                        validIcons.add(icon);
                    } else {
                        SpecificationViolationReporter.report("Discarding invalid '" + String.valueOf(icon) + "': " + String.valueOf(iconErrors), new Object[0]);
                    }
                }
                ++type2;
            }
        }
        void v0 = DArray;
        this.icons = v0.toArray(new Icon[v0.size()]);
        boolean allNullServices = true;
        if (services != null) {
            S[] SArray = services;
            int icons2 = services.length;
            int details2 = 0;
            while (details2 < icons2) {
                S service = SArray[details2];
                if (service != null) {
                    allNullServices = false;
                    ((Service)service).setDevice((Device)this);
                }
                ++details2;
            }
        }
        this.services = services == null || var2_3 != false ? null : services;
        boolean allNullEmbedded = true;
        if (embeddedDevices != null) {
            DArray = embeddedDevices;
            int n = embeddedDevices.length;
            int icons2 = 0;
            while (icons2 < n) {
                Device embeddedDevice = DArray[icons2];
                if (embeddedDevice != null) {
                    allNullEmbedded = false;
                    embeddedDevice.setParentDevice((Device)this);
                }
                ++icons2;
            }
        }
        this.embeddedDevices = embeddedDevices == null || var3_6 != false ? null : embeddedDevices;
        List<ValidationError> errors = this.validate();
        if (!errors.isEmpty()) {
            if (this.logger.isTraceEnabled()) {
                for (ValidationError error : errors) {
                    this.logger.trace(error.toString());
                }
            }
            throw new ValidationException("Validation of device graph failed, call getErrors() on exception", errors);
        }
    }

    public DI getIdentity() {
        return this.identity;
    }

    public UDAVersion getVersion() {
        return this.version;
    }

    public DeviceType getType() {
        return this.type;
    }

    public DeviceDetails getDetails() {
        return this.details;
    }

    public DeviceDetails getDetails(RemoteClientInfo info) {
        return this.getDetails();
    }

    public Icon[] getIcons() {
        return this.icons;
    }

    public boolean hasIcons() {
        return this.getIcons() != null && this.getIcons().length > 0;
    }

    public boolean hasServices() {
        return this.getServices() != null && this.getServices().length > 0;
    }

    public boolean hasEmbeddedDevices() {
        return this.getEmbeddedDevices() != null && this.getEmbeddedDevices().length > 0;
    }

    public D getParentDevice() {
        return this.parentDevice;
    }

    /*
     * WARNING - void declaration
     */
    void setParentDevice(D parentDevice) {
        void var1_1;
        if (this.parentDevice != null) {
            throw new IllegalStateException("Final value has been set already, model is immutable");
        }
        this.parentDevice = var1_1;
    }

    public boolean isRoot() {
        return this.getParentDevice() == null;
    }

    public abstract S[] getServices();

    public abstract D[] getEmbeddedDevices();

    public abstract D getRoot();

    public abstract D findDevice(UDN var1);

    public D[] findEmbeddedDevices() {
        Device device = this;
        return device.toDeviceArray(device.findEmbeddedDevices(this));
    }

    /*
     * WARNING - void declaration
     */
    public D[] findDevices(DeviceType deviceType) {
        void var1_1;
        Device device = this;
        return device.toDeviceArray(device.find((DeviceType)var1_1, this));
    }

    /*
     * WARNING - void declaration
     */
    public D[] findDevices(ServiceType serviceType) {
        void var1_1;
        Device device = this;
        return device.toDeviceArray(device.find((ServiceType)var1_1, this));
    }

    /*
     * WARNING - void declaration
     */
    public Icon[] findIcons() {
        void var1_1;
        Device[] deviceArray;
        ArrayList<Icon> icons = new ArrayList<Icon>();
        if (this.hasIcons()) {
            icons.addAll(Arrays.asList(this.getIcons()));
        }
        Device[] deviceArray2 = deviceArray = this.findEmbeddedDevices();
        int n = deviceArray.length;
        int n2 = 0;
        while (n2 < n) {
            Device embeddedDevice = deviceArray2[n2];
            if (embeddedDevice.hasIcons()) {
                icons.addAll(Arrays.asList(deviceArray.getIcons()));
            }
            ++n2;
        }
        void v0 = var1_1;
        return v0.toArray(new Icon[v0.size()]);
    }

    public S[] findServices() {
        Device device = this;
        return device.toServiceArray(device.findServices(null, null, this));
    }

    /*
     * WARNING - void declaration
     */
    public S[] findServices(ServiceType serviceType) {
        void var1_1;
        Device device = this;
        return device.toServiceArray(device.findServices((ServiceType)var1_1, null, this));
    }

    /*
     * WARNING - void declaration
     */
    protected D find(UDN udn, D current) {
        if (((DeviceIdentity)((Device)current).getIdentity()).getUdn().equals(udn)) {
            return current;
        }
        if (((Device)current).hasEmbeddedDevices()) {
            Device[] deviceArray = current.getEmbeddedDevices();
            int n = deviceArray.length;
            int n2 = 0;
            while (n2 < n) {
                Device embeddedDevice = deviceArray[n2];
                Device match = this.find(udn, embeddedDevice);
                if (match != null) {
                    void var2_2;
                    return var2_2;
                }
                ++n2;
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    protected Collection<D> findEmbeddedDevices(D current) {
        void var2_2;
        HashSet<D> devices = new HashSet<D>();
        if (!((Device)current).isRoot()) {
            devices.add(current);
        }
        if (((Device)current).hasEmbeddedDevices()) {
            Device[] deviceArray = current.getEmbeddedDevices();
            int n = deviceArray.length;
            int n2 = 0;
            while (n2 < n) {
                void var1_1;
                Device embeddedDevice = deviceArray[n2];
                devices.addAll(this.findEmbeddedDevices(var1_1));
                ++n2;
            }
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    protected Collection<D> find(DeviceType deviceType, D current) {
        void var3_3;
        HashSet<D> devices = new HashSet<D>();
        if (((Device)current).getType() != null && ((Device)current).getType().implementsVersion(deviceType)) {
            devices.add(current);
        }
        if (((Device)current).hasEmbeddedDevices()) {
            Device[] deviceArray = current.getEmbeddedDevices();
            int n = deviceArray.length;
            int n2 = 0;
            while (n2 < n) {
                void var2_2;
                Device embeddedDevice = deviceArray[n2];
                devices.addAll(this.find(deviceType, var2_2));
                ++n2;
            }
        }
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    protected Collection<D> find(ServiceType serviceType, D current) {
        void var2_2;
        Collection<S> services = this.findServices(serviceType, null, current);
        HashSet devices = new HashSet();
        for (Service service : services) {
            void var1_1;
            devices.add(var1_1.getDevice());
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    protected Collection<S> findServices(ServiceType serviceType, ServiceId serviceId, D current) {
        void var3_3;
        Collection<void> embeddedDevices;
        HashSet<Service> services = new HashSet<Service>();
        if (((Device)current).hasServices()) {
            Service[] serviceArray = current.getServices();
            int n = serviceArray.length;
            boolean n2 = false;
            while (serviceArray < n) {
                Service service = serviceArray[serviceArray];
                if (this.isMatch(service, serviceType, serviceId)) {
                    services.add(service);
                }
                ++serviceArray;
            }
        }
        if ((embeddedDevices = this.findEmbeddedDevices(var3_3)) != null) {
            for (Device device : embeddedDevices) {
                if (!device.hasServices()) continue;
                Service[] serviceArray = device.getServices();
                int n = serviceArray.length;
                int n3 = 0;
                while (n3 < n) {
                    Service service = serviceArray[n3];
                    if (this.isMatch(service, serviceType, serviceId)) {
                        services.add(service);
                    }
                    ++n3;
                }
            }
        }
        return services;
    }

    /*
     * WARNING - void declaration
     */
    public S findService(ServiceId serviceId) {
        Collection<S> services = this.findServices(null, serviceId, this);
        if (services.size() == 1) {
            void var1_1;
            return (S)((Service)var1_1.iterator().next());
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public S findService(ServiceType serviceType) {
        Collection<S> services = this.findServices(serviceType, null, this);
        if (!services.isEmpty()) {
            void var1_1;
            return (S)((Service)var1_1.iterator().next());
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public ServiceType[] findServiceTypes() {
        void var2_2;
        Collection<S> services = this.findServices(null, null, this);
        HashSet<ServiceType> col = new HashSet<ServiceType>();
        for (Service service : services) {
            void var1_1;
            col.add(var1_1.getServiceType());
        }
        void v0 = var2_2;
        return v0.toArray(new ServiceType[v0.size()]);
    }

    /*
     * WARNING - void declaration
     */
    private boolean isMatch(Service s, ServiceType serviceType, ServiceId serviceId) {
        void var1_2;
        void var2_4;
        void var3_5;
        boolean matchesId;
        boolean matchesType = serviceType == null || s.getServiceType().implementsVersion(serviceType);
        boolean bl = matchesId = serviceId == null || s.getServiceId().equals(var3_5);
        return var2_4 != false && var1_2 != false;
    }

    public boolean isFullyHydrated() {
        Object object;
        Service[] serviceArray = object = this.findServices();
        int n = ((Service[])object).length;
        int n2 = 0;
        while (n2 < n) {
            object = serviceArray[n2];
            if (object.hasStateVariables()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public String getDisplayString() {
        void var3_3;
        void var2_2;
        void var1_1;
        String cleanModelName = null;
        String cleanModelNumber = null;
        if (this.getDetails() != null && this.getDetails().getModelDetails() != null) {
            ModelDetails modelDetails = this.getDetails().getModelDetails();
            if (modelDetails.getModelName() != null) {
                String string = cleanModelName = modelDetails.getModelNumber() != null && modelDetails.getModelName().endsWith(modelDetails.getModelNumber()) ? modelDetails.getModelName().substring(0, modelDetails.getModelName().length() - modelDetails.getModelNumber().length()) : modelDetails.getModelName();
            }
            cleanModelNumber = cleanModelName != null ? (modelDetails.getModelNumber() != null && !cleanModelName.startsWith(modelDetails.getModelNumber()) ? modelDetails.getModelNumber() : "") : modelDetails.getModelNumber();
        }
        StringBuilder sb = new StringBuilder();
        if (this.getDetails() != null && this.getDetails().getManufacturerDetails() != null) {
            if (cleanModelName != null && this.getDetails().getManufacturerDetails().getManufacturer() != null) {
                String string = cleanModelName = cleanModelName.startsWith(this.getDetails().getManufacturerDetails().getManufacturer()) ? cleanModelName.substring(this.getDetails().getManufacturerDetails().getManufacturer().length()).trim() : cleanModelName.trim();
            }
            if (this.getDetails().getManufacturerDetails().getManufacturer() != null) {
                sb.append(this.getDetails().getManufacturerDetails().getManufacturer());
            }
        }
        sb.append((String)(cleanModelName != null && !cleanModelName.isEmpty() ? " " + (String)var1_1 : ""));
        sb.append((String)(cleanModelNumber != null && !cleanModelNumber.isEmpty() ? " " + var2_2.trim() : ""));
        return var3_3.toString();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public List<ValidationError> validate() {
        void var1_1;
        ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
        if (this.getType() != null) {
            int n;
            int n2;
            Object[] objectArray;
            errors.addAll(this.getVersion().validate());
            if (this.getIdentity() != null) {
                errors.addAll(((DeviceIdentity)this.getIdentity()).validate());
            }
            if (this.getDetails() != null) {
                errors.addAll(this.getDetails().validate());
            }
            if (this.hasServices()) {
                objectArray = this.getServices();
                n2 = objectArray.length;
                n = 0;
                while (n < n2) {
                    Object service = objectArray[n];
                    if (service != null) {
                        errors.addAll(((Service)service).validate());
                    }
                    ++n;
                }
            }
            if (this.hasEmbeddedDevices()) {
                objectArray = this.getEmbeddedDevices();
                n2 = objectArray.length;
                n = 0;
                while (n < n2) {
                    Object embeddedDevice = objectArray[n];
                    if (embeddedDevice != null) {
                        void var2_5;
                        errors.addAll(var2_5.validate());
                    }
                    ++n;
                }
            }
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(Object o) {
        void var1_1;
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Device device = (Device)o;
        return ((DeviceIdentity)this.identity).equals(var1_1.identity);
    }

    public int hashCode() {
        return ((DeviceIdentity)this.identity).hashCode();
    }

    public abstract D newInstance(UDN var1, UDAVersion var2, DeviceType var3, DeviceDetails var4, Icon[] var5, S[] var6, List<D> var7) throws ValidationException;

    public abstract S newInstance(ServiceType var1, ServiceId var2, URI var3, URI var4, URI var5, Action<S>[] var6, StateVariable<S>[] var7) throws ValidationException;

    public abstract D[] toDeviceArray(Collection<D> var1);

    public abstract S[] newServiceArray(int var1);

    public abstract S[] toServiceArray(Collection<S> var1);

    public abstract Resource[] discoverResources(Namespace var1);

    public String toString() {
        return "(" + this.getClass().getSimpleName() + ") Identity: " + ((DeviceIdentity)this.getIdentity()).toString() + ", Root: " + this.isRoot();
    }
}

