/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.model.message.header;

import java.io.Serializable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jupnp.model.message.header.InvalidHeaderException;
import org.jupnp.model.message.header.UpnpHeader;

public class TimeoutHeader
extends UpnpHeader<Integer> {
    public static final Integer INFINITE_VALUE = Integer.MAX_VALUE;
    public static final Pattern PATTERN = Pattern.compile("Second-(?:([0-9]+)|infinite)");

    public TimeoutHeader() {
        this.setValue(1800);
    }

    /*
     * WARNING - void declaration
     */
    public TimeoutHeader(int timeoutSeconds) {
        void var1_1;
        this.setValue((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public TimeoutHeader(Integer timeoutSeconds) {
        void var1_1;
        this.setValue(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setString(String s) throws InvalidHeaderException {
        Matcher matcher = PATTERN.matcher(s);
        if (!matcher.matches()) {
            void var1_1;
            throw new InvalidHeaderException("Can't parse timeout seconds integer from: " + (String)var1_1);
        }
        if (matcher.group(1) != null) {
            void var2_2;
            this.setValue(Integer.parseInt(var2_2.group(1)));
            return;
        }
        this.setValue(INFINITE_VALUE);
    }

    @Override
    public String getString() {
        return "Second-" + String.valueOf(((Integer)this.getValue()).equals(INFINITE_VALUE) ? "infinite" : (Serializable)this.getValue());
    }
}

