/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.model.message.header;

import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jupnp.model.message.header.InvalidHeaderException;
import org.jupnp.model.message.header.UpnpHeader;

public class MaxAgeHeader
extends UpnpHeader<Integer> {
    public static final Pattern MAX_AGE_REGEX = Pattern.compile(".*max-age\\s*=\\s*([0-9]+).*");

    /*
     * WARNING - void declaration
     */
    public MaxAgeHeader(Integer maxAge) {
        void var1_1;
        this.setValue(var1_1);
    }

    public MaxAgeHeader() {
        this.setValue(1800);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setString(String s) throws InvalidHeaderException {
        void var1_1;
        void var2_2;
        Matcher matcher = MAX_AGE_REGEX.matcher(s.toLowerCase(Locale.ENGLISH));
        if (!matcher.matches()) {
            throw new InvalidHeaderException("Invalid cache-control value, can't parse max-age seconds: " + s);
        }
        Integer maxAge = Integer.parseInt(var2_2.group(1));
        this.setValue(var1_1);
    }

    @Override
    public String getString() {
        return "max-age=" + ((Integer)this.getValue()).toString();
    }
}

