/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.model.message.header;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jupnp.model.message.header.InvalidHeaderException;
import org.jupnp.model.message.header.UpnpHeader;

public class MANHeader
extends UpnpHeader<String> {
    public static final Pattern PATTERN = Pattern.compile("\"(.+?)\"(;.+?)??");
    public static final Pattern NAMESPACE_PATTERN = Pattern.compile(";\\s?ns\\s?=\\s?([0-9]{2})");
    public String namespace;

    public MANHeader() {
    }

    /*
     * WARNING - void declaration
     */
    public MANHeader(String value) {
        void var1_1;
        this.setValue(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public MANHeader(String value, String namespace) {
        this((String)var1_1);
        void var2_2;
        void var1_1;
        this.namespace = var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setString(String s) throws InvalidHeaderException {
        Matcher matcher = PATTERN.matcher(s);
        if (matcher.matches()) {
            this.setValue(matcher.group(1));
            if (matcher.group(2) != null) {
                Matcher nsMatcher = NAMESPACE_PATTERN.matcher(matcher.group(2));
                if (nsMatcher.matches()) {
                    void var2_2;
                    this.setNamespace(var2_2.group(1));
                    return;
                }
                throw new InvalidHeaderException("Invalid namespace in MAN header value: " + s);
            }
        } else {
            void var1_1;
            throw new InvalidHeaderException("Invalid MAN header value: " + (String)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String getString() {
        void var1_1;
        if (this.getValue() == null) {
            return null;
        }
        StringBuilder s = new StringBuilder();
        s.append("\"").append((String)this.getValue()).append("\"");
        if (this.getNamespace() != null) {
            s.append("; ns=").append(this.getNamespace());
        }
        return var1_1.toString();
    }

    public String getNamespace() {
        return this.namespace;
    }

    /*
     * WARNING - void declaration
     */
    public void setNamespace(String namespace) {
        void var1_1;
        this.namespace = var1_1;
    }
}

