/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.model.message;

import org.jupnp.model.message.UpnpOperation;

public class UpnpResponse
extends UpnpOperation {
    private int statusCode;
    private String statusMessage;

    /*
     * WARNING - void declaration
     */
    public UpnpResponse(int statusCode, String statusMessage) {
        void var2_2;
        void var1_1;
        this.statusCode = var1_1;
        this.statusMessage = var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public UpnpResponse(Status status) {
        void var1_1;
        this.statusCode = status.getStatusCode();
        this.statusMessage = var1_1.getStatusMsg();
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public String getStatusMessage() {
        return this.statusMessage;
    }

    public boolean isFailed() {
        return this.statusCode >= 300;
    }

    public String getResponseDetails() {
        return this.getStatusCode() + " " + this.getStatusMessage();
    }

    public String toString() {
        return this.getResponseDetails();
    }

    public static enum Status {
        OK(200, "OK"),
        BAD_REQUEST(400, "Bad Request"),
        NOT_FOUND(404, "Not Found"),
        METHOD_NOT_SUPPORTED(405, "Method Not Supported"),
        PRECONDITION_FAILED(412, "Precondition Failed"),
        UNSUPPORTED_MEDIA_TYPE(415, "Unsupported Media Type"),
        INTERNAL_SERVER_ERROR(500, "Internal Server Error"),
        NOT_IMPLEMENTED(501, "Not Implemented");

        private final int statusCode;
        private final String statusMsg;

        /*
         * WARNING - void declaration
         */
        private Status(int statusCode, String statusMsg) {
            void var3_3;
            this.statusCode = var3_3;
            this.statusMsg = statusMsg;
        }

        public final int getStatusCode() {
            return this.statusCode;
        }

        public final String getStatusMsg() {
            return this.statusMsg;
        }

        /*
         * WARNING - void declaration
         */
        public static Status getByStatusCode(int statusCode) {
            Status[] statusArray = Status.values();
            int n = statusArray.length;
            int n2 = 0;
            while (n2 < n) {
                Status status = statusArray[n2];
                if (status.getStatusCode() == statusCode) {
                    void var1_4;
                    return var1_4;
                }
                ++n2;
            }
            return null;
        }
    }
}

