/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.model.message;

import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.jupnp.model.message.UpnpOperation;

public class UpnpRequest
extends UpnpOperation {
    private Method method;
    private URI uri;

    /*
     * WARNING - void declaration
     */
    public UpnpRequest(Method method) {
        void var1_1;
        this.method = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public UpnpRequest(Method method, URI uri) {
        void var2_2;
        void var1_1;
        this.method = var1_1;
        this.uri = var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public UpnpRequest(Method method, URL url) {
        this.method = method;
        try {
            if (url != null) {
                void var2_3;
                this.uri = var2_3.toURI();
                return;
            }
        }
        catch (URISyntaxException e) {
            void var1_2;
            throw new IllegalArgumentException((Throwable)var1_2);
        }
    }

    public Method getMethod() {
        return this.method;
    }

    public String getHttpMethodName() {
        return this.method.getHttpName();
    }

    public URI getURI() {
        return this.uri;
    }

    /*
     * WARNING - void declaration
     */
    public void setUri(URI uri) {
        void var1_1;
        this.uri = var1_1;
    }

    public String toString() {
        return this.getHttpMethodName() + (String)(this.getURI() != null ? " " + String.valueOf(this.getURI()) : "");
    }

    public static enum Method {
        GET("GET"),
        POST("POST"),
        NOTIFY("NOTIFY"),
        MSEARCH("M-SEARCH"),
        SUBSCRIBE("SUBSCRIBE"),
        UNSUBSCRIBE("UNSUBSCRIBE"),
        UNKNOWN("UNKNOWN");

        private static final Map<String, Method> byName;
        private final String httpName;

        static {
            byName = new HashMap<String, Method>(){
                {
                    Method[] methodArray = Method.values();
                    int n = methodArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        void var1_4;
                        Method m = methodArray[n2];
                        this.put(m.getHttpName(), var1_4);
                        ++n2;
                    }
                }
            };
        }

        /*
         * WARNING - void declaration
         */
        private Method(String httpName) {
            void var3_3;
            this.httpName = var3_3;
        }

        public final String getHttpName() {
            return this.httpName;
        }

        public static Method getByHttpName(String httpName) {
            if (httpName == null) {
                return UNKNOWN;
            }
            Object m = byName.get(httpName.toUpperCase(Locale.ENGLISH));
            if (m != null) {
                Object object;
                return object;
            }
            return UNKNOWN;
        }
    }
}

