/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.model.message;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.charset.UnsupportedCharsetException;
import org.jupnp.model.message.UpnpHeaders;
import org.jupnp.model.message.UpnpOperation;
import org.jupnp.model.message.header.ContentTypeHeader;
import org.jupnp.model.message.header.UpnpHeader;
import org.jupnp.util.MimeType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class UpnpMessage<O extends UpnpOperation> {
    private static final Logger LOGGER = LoggerFactory.getLogger(UpnpMessage.class);
    private int udaMajorVersion = 1;
    private int udaMinorVersion = 0;
    private O operation;
    private UpnpHeaders headers = new UpnpHeaders();
    private Object body;
    private BodyType bodyType = BodyType.STRING;

    /*
     * WARNING - void declaration
     */
    protected UpnpMessage(UpnpMessage<O> source) {
        void var1_1;
        this.operation = source.getOperation();
        this.headers = source.getHeaders();
        this.body = source.getBody();
        this.bodyType = source.getBodyType();
        this.udaMajorVersion = source.getUdaMajorVersion();
        this.udaMinorVersion = var1_1.getUdaMinorVersion();
    }

    /*
     * WARNING - void declaration
     */
    protected UpnpMessage(O operation) {
        void var1_1;
        this.operation = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    protected UpnpMessage(O operation, BodyType bodyType, Object body) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.operation = var1_1;
        this.bodyType = var2_2;
        this.body = var3_3;
    }

    public int getUdaMajorVersion() {
        return this.udaMajorVersion;
    }

    /*
     * WARNING - void declaration
     */
    public void setUdaMajorVersion(int udaMajorVersion) {
        void var1_1;
        this.udaMajorVersion = var1_1;
    }

    public int getUdaMinorVersion() {
        return this.udaMinorVersion;
    }

    /*
     * WARNING - void declaration
     */
    public void setUdaMinorVersion(int udaMinorVersion) {
        void var1_1;
        this.udaMinorVersion = var1_1;
    }

    public UpnpHeaders getHeaders() {
        return this.headers;
    }

    /*
     * WARNING - void declaration
     */
    public void setHeaders(UpnpHeaders headers) {
        void var1_1;
        this.headers = var1_1;
    }

    public Object getBody() {
        return this.body;
    }

    /*
     * WARNING - void declaration
     */
    public void setBody(String string) {
        void var1_1;
        this.bodyType = BodyType.STRING;
        this.body = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setBody(BodyType bodyType, Object body) {
        void var2_2;
        void var1_1;
        this.bodyType = var1_1;
        this.body = var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public void setBodyCharacters(byte[] characterData) {
        void var1_1;
        this.setBody(BodyType.STRING, new String((byte[])var1_1, this.getContentTypeCharset()));
    }

    public boolean hasBody() {
        return this.getBody() != null;
    }

    public BodyType getBodyType() {
        return this.bodyType;
    }

    /*
     * WARNING - void declaration
     */
    public void setBodyType(BodyType bodyType) {
        void var1_1;
        this.bodyType = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public String getBodyString() {
        block5: {
            try {
                if (this.hasBody()) break block5;
                return null;
            }
            catch (Exception e) {
                void var1_2;
                throw new RuntimeException((Throwable)var1_2);
            }
        }
        if (this.getBodyType().equals((Object)BodyType.STRING)) {
            String body = (String)this.getBody();
            if (body.charAt(0) == '\ufeff') {
                body = body.substring(1);
            }
            return body;
        }
        return new String((byte[])this.getBody(), this.getContentTypeCharset());
    }

    /*
     * WARNING - void declaration
     */
    public byte[] getBodyBytes() {
        block4: {
            try {
                if (this.hasBody()) break block4;
                return null;
            }
            catch (Exception e) {
                void var1_1;
                throw new RuntimeException((Throwable)var1_1);
            }
        }
        if (this.getBodyType().equals((Object)BodyType.STRING)) {
            return this.getBodyString().getBytes(this.getContentTypeCharset());
        }
        return (byte[])this.getBody();
    }

    public O getOperation() {
        return this.operation;
    }

    /*
     * WARNING - void declaration
     */
    public boolean isContentTypeMissingOrText() {
        void var1_1;
        ContentTypeHeader contentTypeHeader = this.getContentTypeHeader();
        if (contentTypeHeader == null) {
            return true;
        }
        return var1_1.isText();
    }

    public ContentTypeHeader getContentTypeHeader() {
        return this.getHeaders().getFirstHeader(UpnpHeader.Type.CONTENT_TYPE, ContentTypeHeader.class);
    }

    /*
     * WARNING - void declaration
     */
    public boolean isContentTypeText() {
        void var1_1;
        ContentTypeHeader ct = this.getContentTypeHeader();
        return ct != null && var1_1.isText();
    }

    /*
     * WARNING - void declaration
     */
    public boolean isContentTypeTextUDA() {
        void var1_1;
        ContentTypeHeader ct = this.getContentTypeHeader();
        return ct != null && var1_1.isUDACompliantXML();
    }

    /*
     * WARNING - void declaration
     */
    public Charset getContentTypeCharset() {
        ContentTypeHeader ct = this.getContentTypeHeader();
        if (ct == null) {
            return StandardCharsets.UTF_8;
        }
        String charsetValue = ((MimeType)ct.getValue()).getParameters().get("charset");
        if (charsetValue == null) {
            return StandardCharsets.UTF_8;
        }
        try {
            return Charset.forName(charsetValue);
        }
        catch (UnsupportedCharsetException e) {
            void var2_2;
            void var1_1;
            LOGGER.warn("UpnpMessage has unsupported charset '{}' using UTF-8 instead", (Object)var1_1, (Object)var2_2);
            return StandardCharsets.UTF_8;
        }
    }

    public boolean hasHostHeader() {
        return this.getHeaders().getFirstHeader(UpnpHeader.Type.HOST) != null;
    }

    public boolean isBodyNonEmptyString() {
        return this.hasBody() && this.getBodyType().equals((Object)BodyType.STRING) && !this.getBodyString().isEmpty();
    }

    public String toString() {
        return "(" + this.getClass().getSimpleName() + ") " + this.getOperation().toString();
    }

    public static enum BodyType {
        STRING,
        BYTES;

    }
}

