/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.model.message;

import java.io.ByteArrayInputStream;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.jupnp.http.Headers;
import org.jupnp.model.message.header.UpnpHeader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpnpHeaders
extends Headers {
    private final Logger logger = LoggerFactory.getLogger(UpnpHeaders.class);
    protected Map<UpnpHeader.Type, List<UpnpHeader>> parsedHeaders;

    public UpnpHeaders() {
    }

    /*
     * WARNING - void declaration
     */
    public UpnpHeaders(Map<String, List<String>> headers) {
        super((Map<String, List<String>>)var1_1);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public UpnpHeaders(ByteArrayInputStream inputStream) {
        super((ByteArrayInputStream)var1_1);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public UpnpHeaders(boolean normalizeHeaders) {
        super((boolean)var1_1);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    protected void parseHeaders() {
        this.parsedHeaders = new LinkedHashMap<UpnpHeader.Type, List<UpnpHeader>>();
        this.logger.trace("Parsing all HTTP headers for known UPnP headers: {}", (Object)this.size());
        for (Map.Entry<String, List<String>> entry : this.entrySet()) {
            if (entry.getKey() == null) continue;
            UpnpHeader.Type type = UpnpHeader.Type.getByHttpName(entry.getKey());
            if (type == null) {
                this.logger.trace("Ignoring non-UPNP HTTP header: {}", (Object)entry.getKey());
                continue;
            }
            for (String value : entry.getValue()) {
                UpnpHeader upnpHeader = UpnpHeader.newInstance(type, value);
                if (upnpHeader == null || upnpHeader.getValue() == null) {
                    void var1_2;
                    this.logger.trace("Ignoring known but irrelevant header (value violates the UDA specification?) '{}': {}", (Object)type.getHttpName(), (Object)var1_2);
                    continue;
                }
                this.addParsedValue(type, upnpHeader);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void addParsedValue(UpnpHeader.Type type, UpnpHeader value) {
        void var2_2;
        List list;
        this.logger.trace("Adding parsed header: {}", (Object)value);
        list = this.parsedHeaders.computeIfAbsent((UpnpHeader.Type)((Object)list), k -> new LinkedList());
        list.add(var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public List<String> put(String key, List<String> values) {
        void var2_2;
        void var1_1;
        this.parsedHeaders = null;
        return super.put((String)var1_1, (List<String>)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void add(String key, String value) {
        void var2_2;
        void var1_1;
        this.parsedHeaders = null;
        super.add((String)var1_1, (String)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public List<String> remove(Object key) {
        void var1_1;
        this.parsedHeaders = null;
        return super.remove(var1_1);
    }

    @Override
    public void clear() {
        this.parsedHeaders = null;
        super.clear();
    }

    /*
     * WARNING - void declaration
     */
    public boolean containsKey(UpnpHeader.Type type) {
        void var1_1;
        if (this.parsedHeaders == null) {
            this.parseHeaders();
        }
        return this.parsedHeaders.containsKey(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public List<UpnpHeader> get(UpnpHeader.Type type) {
        void var1_1;
        if (this.parsedHeaders == null) {
            this.parseHeaders();
        }
        return this.parsedHeaders.get(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void add(UpnpHeader.Type type, UpnpHeader value) {
        super.add(type.getHttpName(), value.getString());
        if (this.parsedHeaders != null) {
            void var2_2;
            void var1_1;
            this.addParsedValue((UpnpHeader.Type)var1_1, (UpnpHeader)var2_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void remove(UpnpHeader.Type type) {
        super.remove(type.getHttpName());
        if (this.parsedHeaders != null) {
            void var1_1;
            this.parsedHeaders.remove(var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public UpnpHeader[] getAsArray(UpnpHeader.Type type) {
        if (this.parsedHeaders == null) {
            this.parseHeaders();
        }
        if (this.parsedHeaders.get((Object)type) != null) {
            void var1_1;
            return this.parsedHeaders.get((Object)type).toArray(new UpnpHeader[this.parsedHeaders.get(var1_1).size()]);
        }
        return new UpnpHeader[0];
    }

    /*
     * WARNING - void declaration
     */
    public UpnpHeader getFirstHeader(UpnpHeader.Type type) {
        if (this.getAsArray(type).length > 0) {
            void var1_1;
            return this.getAsArray((UpnpHeader.Type)var1_1)[0];
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public <H extends UpnpHeader> H getFirstHeader(UpnpHeader.Type type, Class<H> subtype) {
        UpnpHeader[] upnpHeaderArray = type = this.getAsArray((UpnpHeader.Type)type);
        int n = type.length;
        int n2 = 0;
        while (n2 < n) {
            UpnpHeader header = upnpHeaderArray[n2];
            if (subtype.isAssignableFrom(header.getClass())) {
                void var1_1;
                return var1_1;
            }
            ++n2;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public String getFirstHeaderString(UpnpHeader.Type type) {
        UpnpHeader header = this.getFirstHeader(type);
        if (header != null) {
            void var1_1;
            return var1_1.getString();
        }
        return null;
    }

    public void log() {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("############################ RAW HEADERS ###########################");
            for (Map.Entry<String, List<String>> entry : this.entrySet()) {
                this.logger.trace("=== NAME : {}", (Object)entry.getKey());
                for (String string : entry.getValue()) {
                    this.logger.trace("VALUE: {}", (Object)string);
                }
            }
            if (this.parsedHeaders != null && !this.parsedHeaders.isEmpty()) {
                this.logger.trace("########################## PARSED HEADERS ##########################");
                for (Map.Entry<Object, List<Object>> entry : this.parsedHeaders.entrySet()) {
                    this.logger.trace("=== TYPE: {}", entry.getKey());
                    for (UpnpHeader upnpHeader : entry.getValue()) {
                        this.logger.trace("HEADER: {}", (Object)upnpHeader);
                    }
                }
            }
            this.logger.trace("####################################################################");
        }
    }
}

