/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.model.gena;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jupnp.internal.compat.java.beans.PropertyChangeSupport;
import org.jupnp.model.Location;
import org.jupnp.model.Namespace;
import org.jupnp.model.NetworkAddress;
import org.jupnp.model.UnsupportedDataException;
import org.jupnp.model.gena.CancelReason;
import org.jupnp.model.gena.GENASubscription;
import org.jupnp.model.message.UpnpResponse;
import org.jupnp.model.meta.RemoteDevice;
import org.jupnp.model.meta.RemoteService;
import org.jupnp.model.meta.Service;
import org.jupnp.model.state.StateVariableValue;
import org.jupnp.model.types.UnsignedIntegerFourBytes;
import org.jupnp.model.types.UnsignedVariableInteger;

public abstract class RemoteGENASubscription
extends GENASubscription<RemoteService> {
    protected PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

    /*
     * WARNING - void declaration
     */
    protected RemoteGENASubscription(RemoteService service, int requestedDurationSeconds) {
        super(var1_1, (int)var2_2);
        void var2_2;
        void var1_1;
    }

    public URL getEventSubscriptionURL() {
        return ((RemoteDevice)((RemoteService)this.getService()).getDevice()).normalizeURI(((RemoteService)this.getService()).getEventSubscriptionURI());
    }

    /*
     * WARNING - void declaration
     */
    public List<URL> getEventCallbackURLs(List<NetworkAddress> activeStreamServers, Namespace namespace) {
        void var3_3;
        ArrayList<URL> callbackURLs = new ArrayList<URL>();
        for (NetworkAddress activeStreamServer : activeStreamServers) {
            void var1_1;
            callbackURLs.add(new Location((NetworkAddress)var1_1, namespace.getEventCallbackPathString((Service)this.getService())).getURL());
        }
        return var3_3;
    }

    public synchronized void establish() {
        this.established();
    }

    /*
     * WARNING - void declaration
     */
    public synchronized void fail(UpnpResponse responseStatus) {
        void var1_1;
        this.failed((UpnpResponse)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public synchronized void end(CancelReason reason, UpnpResponse response) {
        void var2_2;
        void var1_1;
        this.ended((CancelReason)var1_1, (UpnpResponse)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public synchronized void receive(UnsignedIntegerFourBytes sequence, Collection<StateVariableValue> newValues) {
        void var2_2;
        void var1_1;
        if (this.currentSequence != null) {
            if (this.currentSequence.getValue().equals(((UnsignedVariableInteger)this.currentSequence).getBits().getMaxValue()) && sequence.getValue() == 1L) {
                System.err.println("TODO: HANDLE ROLLOVER");
                return;
            }
            if (this.currentSequence.getValue() >= sequence.getValue()) {
                return;
            }
            long expectedValue = this.currentSequence.getValue() + 1L;
            int difference = (int)(sequence.getValue() - expectedValue);
            if (difference != 0) {
                this.eventsMissed(difference);
            }
        }
        this.currentSequence = var1_1;
        for (StateVariableValue newValue : var2_2) {
            void var3_6;
            this.currentValues.put(newValue.getStateVariable().getName(), var3_6);
        }
        this.eventReceived();
    }

    public abstract void invalidMessage(UnsupportedDataException var1);

    public abstract void failed(UpnpResponse var1);

    public abstract void ended(CancelReason var1, UpnpResponse var2);

    public abstract void eventsMissed(int var1);

    @Override
    public String toString() {
        return "(SID: " + this.getSubscriptionId() + ") " + String.valueOf(this.getService());
    }
}

