/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.model.gena;

import java.net.URL;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.jupnp.internal.compat.java.beans.PropertyChangeEvent;
import org.jupnp.internal.compat.java.beans.PropertyChangeListener;
import org.jupnp.model.gena.CancelReason;
import org.jupnp.model.gena.GENASubscription;
import org.jupnp.model.meta.LocalService;
import org.jupnp.model.meta.StateVariable;
import org.jupnp.model.state.StateVariableValue;
import org.jupnp.model.types.UnsignedIntegerFourBytes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class LocalGENASubscription
extends GENASubscription<LocalService>
implements PropertyChangeListener {
    private final Logger logger = LoggerFactory.getLogger(LocalGENASubscription.class);
    final List<URL> callbackURLs;
    final Map<String, Long> lastSentTimestamp = new HashMap<String, Long>();
    final Map<String, Long> lastSentNumericValue = new HashMap<String, Long>();

    /*
     * WARNING - void declaration
     */
    protected LocalGENASubscription(LocalService service, List<URL> callbackURLs) throws Exception {
        super(var1_1);
        void var2_2;
        void var1_1;
        this.callbackURLs = var2_2;
    }

    /*
     * WARNING - void declaration
     */
    protected LocalGENASubscription(LocalService service, Integer requestedDurationSeconds, List<URL> callbackURLs) throws Exception {
        super(service);
        void var3_3;
        Iterator<StateVariableValue> iterator;
        this.setSubscriptionDuration((Integer)((Object)iterator));
        this.logger.trace("Reading initial state of local service at subscription time");
        long currentTime = new Date().getTime();
        this.currentValues.clear();
        Collection<StateVariableValue> values = ((LocalService)this.getService()).getManager().getCurrentState();
        this.logger.trace("Got evented state variable values: {}", (Object)values.size());
        for (StateVariableValue value : values) {
            void var1_1;
            this.currentValues.put(value.getStateVariable().getName(), value);
            this.logger.trace("Read state variable value '{}': {}", (Object)value.getStateVariable().getName(), (Object)value);
            this.lastSentTimestamp.put(value.getStateVariable().getName(), currentTime);
            if (!value.getStateVariable().isModeratedNumericType()) continue;
            this.lastSentNumericValue.put(value.getStateVariable().getName(), Long.valueOf(var1_1.toString()));
        }
        this.subscriptionId = "uuid:" + String.valueOf(UUID.randomUUID());
        this.currentSequence = new UnsignedIntegerFourBytes(0L);
        this.callbackURLs = var3_3;
    }

    public synchronized List<URL> getCallbackURLs() {
        return this.callbackURLs;
    }

    public synchronized void registerOnService() {
        ((LocalService)this.getService()).getManager().getPropertyChangeSupport().addPropertyChangeListener(this);
    }

    public synchronized void establish() {
        this.established();
    }

    /*
     * WARNING - void declaration
     */
    public synchronized void end(CancelReason reason) {
        void var1_1;
        try {
            ((LocalService)this.getService()).getManager().getPropertyChangeSupport().removePropertyChangeListener(this);
        }
        catch (Exception e) {
            void var2_2;
            this.logger.warn("Removal of local service property change listener failed", (Throwable)var2_2);
        }
        this.ended((CancelReason)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public synchronized void propertyChange(PropertyChangeEvent e) {
        if (!e.getPropertyName().equals("_EventedStateVariables")) {
            return;
        }
        this.logger.trace("Eventing triggered, getting state for subscription: {}", (Object)this.getSubscriptionId());
        long currentTime = new Date().getTime();
        Collection newValues = (Collection)e.getNewValue();
        Set<String> excludedVariables = this.moderateStateVariables(currentTime, newValues);
        this.currentValues.clear();
        for (StateVariableValue newValue : newValues) {
            void var1_1;
            String name = newValue.getStateVariable().getName();
            if (excludedVariables.contains(name)) continue;
            this.logger.trace("Adding state variable value to current values of event: {} = {}", newValue.getStateVariable(), (Object)newValue);
            this.currentValues.put(newValue.getStateVariable().getName(), newValue);
            this.lastSentTimestamp.put(name, currentTime);
            if (!newValue.getStateVariable().isModeratedNumericType()) continue;
            this.lastSentNumericValue.put(name, Long.valueOf(var1_1.toString()));
        }
        if (!this.currentValues.isEmpty()) {
            this.logger.trace("Propagating new state variable values to subscription: {}", (Object)this);
            this.eventReceived();
            return;
        }
        this.logger.trace("No state variable values for event (all moderated out?), not triggering event");
    }

    /*
     * WARNING - void declaration
     */
    protected synchronized Set<String> moderateStateVariables(long currentTime, Collection<StateVariableValue> values) {
        HashSet<String> excludedVariables = new HashSet<String>();
        for (StateVariableValue stateVariableValue : values) {
            void var3_2;
            long l;
            long timestampNextSend;
            StateVariable stateVariable = stateVariableValue.getStateVariable();
            String stateVariableName = stateVariableValue.getStateVariable().getName();
            if (stateVariable.getEventDetails().getEventMaximumRateMilliseconds() == 0 && stateVariable.getEventDetails().getEventMinimumDelta() == 0) {
                this.logger.trace("Variable is not moderated: {}", stateVariable);
                continue;
            }
            if (!this.lastSentTimestamp.containsKey(stateVariableName)) {
                this.logger.trace("Variable is moderated but was never sent before: {}", stateVariable);
                continue;
            }
            if (stateVariable.getEventDetails().getEventMaximumRateMilliseconds() > 0 && currentTime <= (timestampNextSend = (l = this.lastSentTimestamp.get(stateVariableName).longValue()) + (long)stateVariable.getEventDetails().getEventMaximumRateMilliseconds())) {
                this.logger.trace("Excluding state variable with maximum rate: {}", stateVariable);
                excludedVariables.add(stateVariableName);
                continue;
            }
            if (!stateVariable.isModeratedNumericType() || this.lastSentNumericValue.get(stateVariableName) == null) continue;
            long oldValue = this.lastSentNumericValue.get(stateVariableName);
            long newValue = Long.parseLong(var3_2.toString());
            long minDelta = stateVariable.getEventDetails().getEventMinimumDelta();
            if (newValue > oldValue && newValue - oldValue < minDelta) {
                this.logger.trace("Excluding state variable with minimum delta: {}", stateVariable);
                excludedVariables.add(stateVariableName);
                continue;
            }
            if (newValue >= oldValue || oldValue - newValue >= minDelta) continue;
            this.logger.trace("Excluding state variable with minimum delta: {}", stateVariable);
            excludedVariables.add(stateVariableName);
        }
        return excludedVariables;
    }

    public synchronized void incrementSequence() {
        this.currentSequence.increment(true);
    }

    /*
     * WARNING - void declaration
     */
    public synchronized void setSubscriptionDuration(Integer requestedDurationSeconds) {
        void var1_1;
        this.requestedDurationSeconds = requestedDurationSeconds == null ? 1800 : var1_1.intValue();
        LocalGENASubscription localGENASubscription = this;
        localGENASubscription.setActualSubscriptionDurationSeconds(localGENASubscription.requestedDurationSeconds);
    }

    public abstract void ended(CancelReason var1);
}

