/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.model.action;

import org.jupnp.model.action.AbstractActionExecutor;
import org.jupnp.model.action.ActionException;
import org.jupnp.model.action.ActionInvocation;
import org.jupnp.model.meta.LocalService;
import org.jupnp.model.meta.QueryStateVariableAction;
import org.jupnp.model.meta.StateVariable;
import org.jupnp.model.state.StateVariableAccessor;
import org.jupnp.model.types.ErrorCode;

public class QueryStateVariableExecutor
extends AbstractActionExecutor {
    /*
     * WARNING - void declaration
     */
    @Override
    protected void execute(ActionInvocation<LocalService> actionInvocation, Object serviceImpl) throws Exception {
        void var1_1;
        if (actionInvocation.getAction() instanceof QueryStateVariableAction) {
            void var2_2;
            if (!actionInvocation.getAction().getService().isSupportsQueryStateVariables()) {
                actionInvocation.setFailure(new ActionException(ErrorCode.INVALID_ACTION, "This service does not support querying state variables"));
                return;
            }
            this.executeQueryStateVariable(actionInvocation, var2_2);
            return;
        }
        throw new IllegalStateException("This class can only execute QueryStateVariableAction's, not: " + String.valueOf(var1_1.getAction()));
    }

    /*
     * WARNING - void declaration
     */
    protected void executeQueryStateVariable(ActionInvocation<LocalService> actionInvocation, Object serviceImpl) throws Exception {
        String stateVariableName;
        LocalService service = actionInvocation.getAction().getService();
        StateVariable<LocalService> stateVariable = service.getStateVariable(stateVariableName = actionInvocation.getInput("varName").toString());
        if (stateVariable == null) {
            throw new ActionException(ErrorCode.ARGUMENT_VALUE_INVALID, "No state variable found: " + stateVariableName);
        }
        StateVariableAccessor accessor = service.getAccessor(stateVariable.getName());
        if (accessor == null) {
            throw new ActionException(ErrorCode.ARGUMENT_VALUE_INVALID, "No accessor for state variable, can't read state: " + stateVariableName);
        }
        try {
            void var2_3;
            void var3_4;
            ActionInvocation<LocalService> actionInvocation2 = actionInvocation;
            this.setOutputArgumentValue(actionInvocation2, actionInvocation2.getAction().getOutputArgument("return"), var3_4.read(stateVariable, var2_3).toString());
            return;
        }
        catch (Exception e) {
            void var1_2;
            throw new ActionException(ErrorCode.ACTION_FAILED, var1_2.getMessage());
        }
    }
}

