/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.model.action;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Map;
import org.jupnp.model.action.AbstractActionExecutor;
import org.jupnp.model.action.ActionArgumentValue;
import org.jupnp.model.action.ActionException;
import org.jupnp.model.action.ActionInvocation;
import org.jupnp.model.action.RemoteActionInvocation;
import org.jupnp.model.meta.ActionArgument;
import org.jupnp.model.meta.LocalService;
import org.jupnp.model.profile.RemoteClientInfo;
import org.jupnp.model.state.StateVariableAccessor;
import org.jupnp.model.types.ErrorCode;
import org.jupnp.util.Reflections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MethodActionExecutor
extends AbstractActionExecutor {
    private final Logger logger = LoggerFactory.getLogger(MethodActionExecutor.class);
    protected Method method;

    /*
     * WARNING - void declaration
     */
    public MethodActionExecutor(Method method) {
        void var1_1;
        this.method = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public MethodActionExecutor(Map<ActionArgument<LocalService>, StateVariableAccessor> outputArgumentAccessors, Method method) {
        super((Map<ActionArgument<LocalService>, StateVariableAccessor>)var1_1);
        void var2_2;
        void var1_1;
        this.method = var2_2;
    }

    public Method getMethod() {
        return this.method;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void execute(ActionInvocation<LocalService> actionInvocation, Object serviceImpl) throws Exception {
        void var3_3;
        Object returnedInstance;
        Object result;
        Object[] inputArgumentValues = this.createInputArgumentValues(actionInvocation, this.method);
        if (!actionInvocation.getAction().hasOutputArguments()) {
            this.logger.trace("Calling local service method with no output arguments: {}", (Object)this.method);
            Reflections.invoke(this.method, serviceImpl, inputArgumentValues);
            return;
        }
        boolean isVoid = this.method.getReturnType().equals(Void.TYPE);
        this.logger.trace("Calling local service method with output arguments: {}", (Object)this.method);
        boolean isArrayResultProcessed = true;
        if (isVoid) {
            this.logger.trace("Action method is void, calling declared accessors(s) on service instance to retrieve output argument(s)");
            Reflections.invoke(this.method, serviceImpl, inputArgumentValues);
            result = this.readOutputArgumentValues(actionInvocation.getAction(), serviceImpl);
        } else if (this.isUseOutputArgumentAccessors(actionInvocation)) {
            this.logger.trace("Action method is not void, calling declared accessor(s) on returned instance to retrieve output argument(s)");
            returnedInstance = Reflections.invoke(this.method, result, inputArgumentValues);
            result = this.readOutputArgumentValues(actionInvocation.getAction(), returnedInstance);
        } else {
            this.logger.trace("Action method is not void, using returned value as (single) output argument");
            result = Reflections.invoke(this.method, result, (Object[])returnedInstance);
            isArrayResultProcessed = false;
        }
        ActionArgument<LocalService>[] outputArgs = actionInvocation.getAction().getOutputArguments();
        if (isArrayResultProcessed && result instanceof Object[]) {
            Object[] results = (Object[])result;
            this.logger.trace("Accessors returned Object[], setting output argument values: {}", (Object)results.length);
            int i = 0;
            while (i < outputArgs.length) {
                this.setOutputArgumentValue(actionInvocation, outputArgs[i], results[i]);
                ++i;
            }
            return;
        }
        if (outputArgs.length == 1) {
            void var2_2;
            void var1_1;
            this.setOutputArgumentValue((ActionInvocation<LocalService>)var1_1, outputArgs[0], var2_2);
            return;
        }
        throw new ActionException(ErrorCode.ACTION_FAILED, "Method return does not match required number of output arguments: " + ((void)var3_3).length);
    }

    /*
     * WARNING - void declaration
     */
    protected boolean isUseOutputArgumentAccessors(ActionInvocation<LocalService> actionInvocation) {
        ActionArgument<LocalService>[] actionArgumentArray = actionInvocation.getAction().getOutputArguments();
        int n = actionArgumentArray.length;
        int n2 = 0;
        while (n2 < n) {
            void var1_1;
            ActionArgument<LocalService> argument = actionArgumentArray[n2];
            if (this.getOutputArgumentAccessors().get(var1_1) != null) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    protected Object[] createInputArgumentValues(ActionInvocation<LocalService> actionInvocation, Method method) throws ActionException {
        LocalService service = actionInvocation.getAction().getService();
        ArrayList<Object> values = new ArrayList<Object>();
        int i = 0;
        ActionArgument<LocalService>[] actionArgumentArray = actionInvocation.getAction().getInputArguments();
        int n = actionArgumentArray.length;
        int n2 = 0;
        while (n2 < n) {
            ActionArgument<LocalService> argument = actionArgumentArray[n2];
            Class<?> methodParameterType = method.getParameterTypes()[i];
            ActionArgumentValue<LocalService> inputValue = actionInvocation.getInput(argument);
            if (methodParameterType.isPrimitive() && (inputValue == null || inputValue.toString().isEmpty())) {
                throw new ActionException(ErrorCode.ARGUMENT_VALUE_INVALID, "Primitive action method argument '" + argument.getName() + "' requires input value, can't be null or empty string");
            }
            if (inputValue == null) {
                values.add(i++, null);
            } else {
                String inputCallValueString = inputValue.toString();
                if (!inputCallValueString.isEmpty() && service.isStringConvertibleType(methodParameterType) && !methodParameterType.isEnum()) {
                    try {
                        Constructor<?> ctor = methodParameterType.getConstructor(String.class);
                        this.logger.trace("Creating new input argument value instance with String.class constructor of type: {}", methodParameterType);
                        Object o = ctor.newInstance(inputCallValueString);
                        values.add(i++, o);
                    }
                    catch (Exception e) {
                        this.logger.warn("Error preparing action method call: {}. Can't convert input argument string to desired type of '{}'", new Object[]{method, argument.getName(), e});
                        throw new ActionException(ErrorCode.ARGUMENT_VALUE_INVALID, "Can't convert input argument string to desired type of '" + argument.getName() + "': " + String.valueOf(e));
                    }
                } else {
                    void var11_11;
                    values.add(i++, var11_11.getValue());
                }
            }
            ++n2;
        }
        if (method.getParameterTypes().length > 0 && RemoteClientInfo.class.isAssignableFrom(method.getParameterTypes()[method.getParameterTypes().length - 1])) {
            if (actionInvocation instanceof RemoteActionInvocation && ((RemoteActionInvocation)actionInvocation).getRemoteClientInfo() != null) {
                void var1_1;
                void var2_2;
                this.logger.trace("Providing remote client info as last action method input argument: {}", (Object)var2_2);
                values.add(i, ((RemoteActionInvocation)var1_1).getRemoteClientInfo());
            } else {
                values.add(i, null);
            }
        }
        ArrayList<Object> arrayList = values;
        return arrayList.toArray(new Object[arrayList.size()]);
    }
}

