/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.model.action;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jupnp.model.action.ActionArgumentValue;
import org.jupnp.model.action.ActionException;
import org.jupnp.model.meta.Action;
import org.jupnp.model.meta.ActionArgument;
import org.jupnp.model.meta.Service;
import org.jupnp.model.profile.ClientInfo;
import org.jupnp.model.types.InvalidValueException;

public class ActionInvocation<S extends Service> {
    protected final Action<S> action;
    protected final ClientInfo clientInfo;
    protected Map<String, ActionArgumentValue<S>> input = new LinkedHashMap<String, ActionArgumentValue<S>>();
    protected Map<String, ActionArgumentValue<S>> output = new LinkedHashMap<String, ActionArgumentValue<S>>();
    protected ActionException failure = null;

    /*
     * WARNING - void declaration
     */
    public ActionInvocation(Action<S> action) {
        this((Action<S>)var1_1, null, null, null);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public ActionInvocation(Action<S> action, ClientInfo clientInfo) {
        this((Action<S>)var1_1, null, null, (ClientInfo)var2_2);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public ActionInvocation(Action<S> action, ActionArgumentValue<S>[] input) {
        this((Action<S>)var1_1, (ActionArgumentValue<S>[])var2_2, null, null);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public ActionInvocation(Action<S> action, ActionArgumentValue<S>[] input, ClientInfo clientInfo) {
        this((Action<S>)var1_1, (ActionArgumentValue<S>[])var2_2, null, (ClientInfo)var3_3);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public ActionInvocation(Action<S> action, ActionArgumentValue<S>[] input, ActionArgumentValue<S>[] output) {
        this((Action<S>)var1_1, (ActionArgumentValue<S>[])var2_2, (ActionArgumentValue<S>[])var3_3, null);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public ActionInvocation(Action<S> action, ActionArgumentValue<S>[] input, ActionArgumentValue<S>[] output, ClientInfo clientInfo) {
        void var3_3;
        void var2_2;
        void var1_1;
        if (action == null) {
            throw new IllegalArgumentException("Action can not be null");
        }
        this.action = var1_1;
        this.setInput((ActionArgumentValue<S>[])var2_2);
        this.setOutput((ActionArgumentValue<S>[])var3_3);
        this.clientInfo = clientInfo;
    }

    /*
     * WARNING - void declaration
     */
    public ActionInvocation(ActionException failure) {
        void var1_1;
        this.action = null;
        this.input = null;
        this.output = null;
        this.failure = var1_1;
        this.clientInfo = null;
    }

    public Action<S> getAction() {
        return this.action;
    }

    public ActionArgumentValue<S>[] getInput() {
        return this.input.values().toArray(new ActionArgumentValue[this.input.size()]);
    }

    /*
     * WARNING - void declaration
     */
    public ActionArgumentValue<S> getInput(String argumentName) {
        void var1_1;
        ActionInvocation actionInvocation = this;
        return actionInvocation.getInput(actionInvocation.getInputArgument((String)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public ActionArgumentValue<S> getInput(ActionArgument<S> argument) {
        void var1_1;
        return this.input.get(var1_1.getName());
    }

    public Map<String, ActionArgumentValue<S>> getInputMap() {
        return Collections.unmodifiableMap(this.input);
    }

    public ActionArgumentValue<S>[] getOutput() {
        return this.output.values().toArray(new ActionArgumentValue[this.output.size()]);
    }

    /*
     * WARNING - void declaration
     */
    public ActionArgumentValue<S> getOutput(String argumentName) {
        void var1_1;
        ActionInvocation actionInvocation = this;
        return actionInvocation.getOutput(actionInvocation.getOutputArgument((String)var1_1));
    }

    public Map<String, ActionArgumentValue<S>> getOutputMap() {
        return Collections.unmodifiableMap(this.output);
    }

    /*
     * WARNING - void declaration
     */
    public ActionArgumentValue<S> getOutput(ActionArgument<S> argument) {
        void var1_1;
        return this.output.get(var1_1.getName());
    }

    /*
     * WARNING - void declaration
     */
    public void setInput(String argumentName, Object value) throws InvalidValueException {
        void var2_2;
        void var1_1;
        this.setInput(new ActionArgumentValue<S>(this.getInputArgument((String)var1_1), (Object)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    public void setInput(ActionArgumentValue<S> value) {
        void var1_1;
        this.input.put(value.getArgument().getName(), (ActionArgumentValue<S>)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void setInput(ActionArgumentValue<S>[] input) {
        if (input == null) {
            return;
        }
        ActionArgumentValue<S>[] actionArgumentValueArray = input;
        int n = input.length;
        int n2 = 0;
        while (n2 < n) {
            void var1_1;
            ActionArgumentValue<S> argumentValue = actionArgumentValueArray[n2];
            this.input.put(argumentValue.getArgument().getName(), (ActionArgumentValue<S>)var1_1);
            ++n2;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setOutput(String argumentName, Object value) throws InvalidValueException {
        void var2_2;
        void var1_1;
        this.setOutput(new ActionArgumentValue<S>(this.getOutputArgument((String)var1_1), (Object)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    public void setOutput(ActionArgumentValue<S> value) {
        void var1_1;
        this.output.put(value.getArgument().getName(), (ActionArgumentValue<S>)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void setOutput(ActionArgumentValue<S>[] output) {
        if (output == null) {
            return;
        }
        ActionArgumentValue<S>[] actionArgumentValueArray = output;
        int n = output.length;
        int n2 = 0;
        while (n2 < n) {
            void var1_1;
            ActionArgumentValue<S> argumentValue = actionArgumentValueArray[n2];
            this.output.put(argumentValue.getArgument().getName(), (ActionArgumentValue<S>)var1_1);
            ++n2;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected ActionArgument<S> getInputArgument(String name) {
        void var2_2;
        ActionArgument<S> argument = this.getAction().getInputArgument(name);
        if (argument == null) {
            void var1_1;
            throw new IllegalArgumentException("Argument not found: " + (String)var1_1);
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    protected ActionArgument<S> getOutputArgument(String name) {
        void var2_2;
        ActionArgument<S> argument = this.getAction().getOutputArgument(name);
        if (argument == null) {
            void var1_1;
            throw new IllegalArgumentException("Argument not found: " + (String)var1_1);
        }
        return var2_2;
    }

    public ActionException getFailure() {
        return this.failure;
    }

    /*
     * WARNING - void declaration
     */
    public void setFailure(ActionException failure) {
        void var1_1;
        this.failure = var1_1;
    }

    public ClientInfo getClientInfo() {
        return this.clientInfo;
    }

    public String toString() {
        return "(" + this.getClass().getSimpleName() + ") " + String.valueOf(this.getAction());
    }
}

