/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.model.action;

import java.util.HashMap;
import java.util.Map;
import org.jupnp.model.Command;
import org.jupnp.model.ServiceManager;
import org.jupnp.model.action.ActionArgumentValue;
import org.jupnp.model.action.ActionCancelledException;
import org.jupnp.model.action.ActionException;
import org.jupnp.model.action.ActionExecutor;
import org.jupnp.model.action.ActionInvocation;
import org.jupnp.model.meta.Action;
import org.jupnp.model.meta.ActionArgument;
import org.jupnp.model.meta.LocalService;
import org.jupnp.model.state.StateVariableAccessor;
import org.jupnp.model.types.ErrorCode;
import org.jupnp.model.types.InvalidValueException;
import org.jupnp.util.Exceptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractActionExecutor
implements ActionExecutor {
    private final Logger logger = LoggerFactory.getLogger(AbstractActionExecutor.class);
    protected Map<ActionArgument<LocalService>, StateVariableAccessor> outputArgumentAccessors = new HashMap<ActionArgument<LocalService>, StateVariableAccessor>();

    protected AbstractActionExecutor() {
    }

    /*
     * WARNING - void declaration
     */
    protected AbstractActionExecutor(Map<ActionArgument<LocalService>, StateVariableAccessor> outputArgumentAccessors) {
        void var1_1;
        this.outputArgumentAccessors = var1_1;
    }

    public Map<ActionArgument<LocalService>, StateVariableAccessor> getOutputArgumentAccessors() {
        return this.outputArgumentAccessors;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void execute(final ActionInvocation<LocalService> actionInvocation) {
        this.logger.trace("Invoking on local service: {}", actionInvocation);
        LocalService service = actionInvocation.getAction().getService();
        try {
            if (service.getManager() == null) {
                throw new IllegalStateException("Service has no implementation factory, can't get service instance");
            }
            service.getManager().execute(new Command(){

                /*
                 * WARNING - void declaration
                 */
                public void execute(ServiceManager serviceManager) throws Exception {
                    void var1_1;
                    AbstractActionExecutor.this.execute(actionInvocation, var1_1.getImplementation());
                }

                public String toString() {
                    return "Action invocation: " + String.valueOf(actionInvocation.getAction());
                }
            });
            return;
        }
        catch (ActionException e) {
            this.logger.trace("ActionException thrown by service, wrapping in invocation and returning", (Throwable)e);
            actionInvocation.setFailure(e);
            return;
        }
        catch (InterruptedException e) {
            this.logger.trace("InterruptedException thrown by service, wrapping in invocation and returning", (Throwable)e);
            actionInvocation.setFailure(new ActionCancelledException(e));
            return;
        }
        catch (Exception exception) {
            void var3_5;
            void var1_1;
            void var2_2;
            Exception e = exception;
            Throwable rootCause = Exceptions.unwrap(exception);
            this.logger.trace("Execution has thrown, wrapping root cause in ActionException and returning", (Throwable)var2_2);
            var1_1.setFailure(new ActionException(ErrorCode.ACTION_FAILED, rootCause.getMessage() != null ? rootCause.getMessage() : rootCause.toString(), (Throwable)var3_5));
            return;
        }
    }

    protected abstract void execute(ActionInvocation<LocalService> var1, Object var2) throws Exception;

    /*
     * WARNING - void declaration
     */
    protected Object readOutputArgumentValues(Action<LocalService> action, Object instance) throws Exception {
        Object[] results = new Object[action.getOutputArguments().length];
        this.logger.trace("Attempting to retrieve output argument values using accessor: {}", (Object)results.length);
        int i = 0;
        ActionArgument<LocalService>[] actionArgumentArray = action.getOutputArguments();
        int n = actionArgumentArray.length;
        int n2 = 0;
        while (n2 < n) {
            ActionArgument<LocalService> outputArgument = actionArgumentArray[n2];
            this.logger.trace("Calling acccessor method for: {}", outputArgument);
            StateVariableAccessor accessor = this.getOutputArgumentAccessors().get(outputArgument);
            if (accessor == null) {
                void var1_1;
                throw new IllegalStateException("No accessor bound for: " + String.valueOf(var1_1));
            }
            this.logger.trace("Calling accessor to read output argument value: {}", (Object)accessor);
            results[i++] = accessor.read(instance);
            ++n2;
        }
        if (results.length == 1) {
            return results[0];
        }
        if (results.length > 0) {
            void var3_3;
            return var3_3;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    protected void setOutputArgumentValue(ActionInvocation<LocalService> actionInvocation, ActionArgument<LocalService> argument, Object result) throws ActionException {
        LocalService service = actionInvocation.getAction().getService();
        if (result != null) {
            try {
                void var3_4;
                if (service.isStringConvertibleType(result)) {
                    this.logger.trace("Result of invocation matches convertible type, setting toString() single output argument value");
                    actionInvocation.setOutput(new ActionArgumentValue<LocalService>(argument, (Object)result.toString()));
                    return;
                }
                this.logger.trace("Result of invocation is Object, setting single output argument value");
                actionInvocation.setOutput(new ActionArgumentValue<LocalService>(argument, (Object)var3_4));
                return;
            }
            catch (InvalidValueException e) {
                void var1_2;
                void var2_3;
                throw new ActionException(ErrorCode.ARGUMENT_VALUE_INVALID, "Wrong type or invalid value for '" + var2_3.getName() + "': " + e.getMessage(), (Throwable)var1_2);
            }
        }
        this.logger.trace("Result of invocation is null, not setting any output argument value(s)");
    }
}

