/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.model;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLUtil {
    public static String documentToString(Document document) throws Exception {
        return XMLUtil.documentToString(document, true);
    }

    public static String documentToString(Document document, boolean standalone) throws Exception {
        Document document2;
        String string = "<?xml version=\"1.0\" encoding=\"utf-8\" standalone=\"" + (standalone ? "yes" : "no") + "\"?>";
        return string + XMLUtil.nodeToString(document.getDocumentElement(), new HashSet<String>(), document2.getDocumentElement().getNamespaceURI());
    }

    public static String documentToFragmentString(Document document) throws Exception {
        Document document2;
        return XMLUtil.nodeToString(document.getDocumentElement(), new HashSet<String>(), document2.getDocumentElement().getNamespaceURI());
    }

    /*
     * WARNING - void declaration
     */
    protected static String nodeToString(Node node, Set<String> parentPrefixes, String namespaceURI) throws Exception {
        void var3_3;
        Node node2;
        StringBuilder b = new StringBuilder();
        if (node == null) {
            return "";
        }
        if (node instanceof Element) {
            Node node3;
            Node element = (Element)node;
            b.append("<");
            b.append(element.getNodeName());
            HashMap<String, String> thisLevelPrefixes = new HashMap<String, String>();
            if (element.getPrefix() != null && !parentPrefixes.contains(element.getPrefix())) {
                thisLevelPrefixes.put(element.getPrefix(), element.getNamespaceURI());
            }
            if (element.hasAttributes()) {
                NamedNodeMap map = element.getAttributes();
                int i = 0;
                while (i < map.getLength()) {
                    Node attr = map.item(i);
                    if (!attr.getNodeName().startsWith("xmlns")) {
                        if (attr.getPrefix() != null && !parentPrefixes.contains(attr.getPrefix())) {
                            thisLevelPrefixes.put(attr.getPrefix(), element.getNamespaceURI());
                        }
                        b.append(" ");
                        b.append(attr.getNodeName());
                        b.append("=\"");
                        b.append(attr.getNodeValue());
                        b.append("\"");
                    }
                    ++i;
                }
            }
            if (namespaceURI != null && !thisLevelPrefixes.containsValue(namespaceURI) && !namespaceURI.equals(element.getParentNode().getNamespaceURI())) {
                b.append(" xmlns=\"").append((String)((Object)node3)).append("\"");
            }
            for (Map.Entry entry : thisLevelPrefixes.entrySet()) {
                b.append(" xmlns:").append((String)entry.getKey()).append("=\"").append((String)entry.getValue()).append("\"");
                parentPrefixes.add((String)entry.getKey());
            }
            NodeList children = element.getChildNodes();
            boolean hasOnlyAttributes = true;
            int i = 0;
            while (i < children.getLength()) {
                node3 = children.item(i);
                if (node3.getNodeType() != 2) {
                    hasOnlyAttributes = false;
                    break;
                }
                ++i;
            }
            if (!hasOnlyAttributes) {
                b.append(">");
                i = 0;
                while (i < children.getLength()) {
                    b.append(XMLUtil.nodeToString(children.item(i), parentPrefixes, children.item(i).getNamespaceURI()));
                    ++i;
                }
                b.append("</");
                b.append(node2.getNodeName());
                b.append(">");
            } else {
                b.append("/>");
            }
            for (String thisLevelPrefix : thisLevelPrefixes.keySet()) {
                parentPrefixes.remove(thisLevelPrefix);
            }
        } else if (node2.getNodeValue() != null) {
            b.append(XMLUtil.encodeText(node2.getNodeValue(), node2 instanceof Attr));
        }
        return var3_3.toString();
    }

    public static String encodeText(String s) {
        return XMLUtil.encodeText(s, true);
    }

    /*
     * WARNING - void declaration
     */
    public static String encodeText(String s, boolean encodeQuotes) {
        String string;
        void var1_1;
        s = s.replaceAll("&", "&amp;");
        s = s.replaceAll("<", "&lt;");
        s = s.replaceAll(">", "&gt;");
        if (var1_1 != false) {
            s = s.replaceAll("'", "&apos;");
            s = s.replaceAll("\"", "&quot;");
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    public static Element appendNewElement(Document document, Element parent, Enum el) {
        void var2_2;
        void var1_1;
        return XMLUtil.appendNewElement(document, (Element)var1_1, var2_2.toString());
    }

    /*
     * WARNING - void declaration
     */
    public static Element appendNewElement(Document document, Element parent, String element) {
        Node node;
        void var1_1;
        void var2_2;
        Node child = document.createElement((String)var2_2);
        var1_1.appendChild(child);
        return node;
    }

    /*
     * WARNING - void declaration
     */
    public static Element appendNewElementIfNotNull(Document document, Element parent, Enum el, Object content) {
        void var3_3;
        void var2_2;
        void var1_1;
        return XMLUtil.appendNewElementIfNotNull(document, (Element)var1_1, (Enum)var2_2, (Object)var3_3, null);
    }

    /*
     * WARNING - void declaration
     */
    public static Element appendNewElementIfNotNull(Document document, Element parent, Enum el, Object content, String namespace) {
        void var3_3;
        void var2_2;
        void var1_1;
        return XMLUtil.appendNewElementIfNotNull(document, (Element)var1_1, var2_2.toString(), (Object)var3_3, namespace);
    }

    /*
     * WARNING - void declaration
     */
    public static Element appendNewElementIfNotNull(Document document, Element parent, String element, Object content) {
        void var3_3;
        void var2_2;
        void var1_1;
        return XMLUtil.appendNewElementIfNotNull(document, (Element)var1_1, (String)var2_2, (Object)var3_3, null);
    }

    /*
     * WARNING - void declaration
     */
    public static Element appendNewElementIfNotNull(Document document, Element parent, String element, Object content, String namespace) {
        void var3_3;
        void var2_2;
        void var1_1;
        Document document2;
        if (content == null) {
            return parent;
        }
        return XMLUtil.appendNewElement(document2, (Element)var1_1, (String)var2_2, var3_3, namespace);
    }

    /*
     * WARNING - void declaration
     */
    public static Element appendNewElement(Document document, Element parent, String element, Object content) {
        void var3_3;
        void var2_2;
        void var1_1;
        return XMLUtil.appendNewElement(document, (Element)var1_1, (String)var2_2, var3_3, null);
    }

    /*
     * WARNING - void declaration
     */
    public static Element appendNewElement(Document document, Element parent, String element, Object content, String namespace) {
        void var2_2;
        void var1_1;
        Element childElement;
        childElement = namespace != null ? document.createElementNS(namespace, element) : document.createElement((String)((Object)childElement));
        if (content != null) {
            void var3_3;
            Document document2;
            childElement.appendChild(document2.createTextNode(var3_3.toString()));
        }
        var1_1.appendChild(childElement);
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public static String getTextContent(Node node) {
        void var1_1;
        StringBuilder buffer = new StringBuilder();
        NodeList childList = node.getChildNodes();
        int i = 0;
        while (i < childList.getLength()) {
            Node child = childList.item(i);
            if (child.getNodeType() == 3) {
                void var3_3;
                buffer.append(var3_3.getNodeValue());
            }
            ++i;
        }
        return var1_1.toString();
    }
}

