/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.model;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.jupnp.model.ValidationError;
import org.jupnp.model.ValidationException;
import org.jupnp.model.meta.Device;
import org.jupnp.model.meta.DeviceIdentity;
import org.jupnp.model.meta.Icon;
import org.jupnp.model.meta.Service;
import org.jupnp.model.resource.Resource;
import org.jupnp.util.URIUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Namespace {
    private final Logger logger = LoggerFactory.getLogger(Namespace.class);
    public static final String DEVICE = "/dev";
    public static final String SERVICE = "/svc";
    public static final String CONTROL = "/action";
    public static final String EVENTS = "/event";
    public static final String DESCRIPTOR_FILE = "/desc";
    public static final String CALLBACK_FILE = "/cb";
    protected final URI basePath;
    protected final String decodedPath;

    public Namespace() {
        this("");
    }

    /*
     * WARNING - void declaration
     */
    public Namespace(String basePath) {
        this(URI.create((String)var1_1));
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public Namespace(URI basePath) {
        void var1_1;
        this.basePath = basePath;
        this.decodedPath = var1_1.getPath();
    }

    public URI getBasePath() {
        return this.basePath;
    }

    /*
     * WARNING - void declaration
     */
    public URI getPath(Device device) {
        void var1_1;
        Namespace namespace = this;
        return namespace.appendPathToBaseURI(namespace.getDevicePath((Device)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public URI getPath(Service service) {
        void var1_1;
        Namespace namespace = this;
        return namespace.appendPathToBaseURI(namespace.getServicePath((Service)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public URI getDescriptorPath(Device device) {
        void var1_1;
        Namespace namespace = this;
        return namespace.appendPathToBaseURI(namespace.getDevicePath((Device)var1_1.getRoot()) + DESCRIPTOR_FILE);
    }

    /*
     * WARNING - void declaration
     */
    public String getDescriptorPathString(Device device) {
        void var1_1;
        return this.decodedPath + this.getDevicePath((Device)var1_1.getRoot()) + DESCRIPTOR_FILE;
    }

    /*
     * WARNING - void declaration
     */
    public URI getDescriptorPath(Service service) {
        void var1_1;
        Namespace namespace = this;
        return namespace.appendPathToBaseURI(namespace.getServicePath((Service)var1_1) + DESCRIPTOR_FILE);
    }

    /*
     * WARNING - void declaration
     */
    public URI getControlPath(Service service) {
        void var1_1;
        Namespace namespace = this;
        return namespace.appendPathToBaseURI(namespace.getServicePath((Service)var1_1) + CONTROL);
    }

    /*
     * WARNING - void declaration
     */
    public URI getIconPath(Icon icon) {
        void var1_1;
        Namespace namespace = this;
        return namespace.appendPathToBaseURI(namespace.getDevicePath(icon.getDevice()) + "/" + var1_1.getUri().toString());
    }

    /*
     * WARNING - void declaration
     */
    public URI getEventSubscriptionPath(Service service) {
        void var1_1;
        Namespace namespace = this;
        return namespace.appendPathToBaseURI(namespace.getServicePath((Service)var1_1) + EVENTS);
    }

    /*
     * WARNING - void declaration
     */
    public URI getEventCallbackPath(Service service) {
        void var1_1;
        Namespace namespace = this;
        return namespace.appendPathToBaseURI(namespace.getServicePath((Service)var1_1) + "/event/cb");
    }

    /*
     * WARNING - void declaration
     */
    public String getEventCallbackPathString(Service service) {
        void var1_1;
        return this.decodedPath + this.getServicePath((Service)var1_1) + "/event/cb";
    }

    /*
     * WARNING - void declaration
     */
    public URI prefixIfRelative(Device device, URI uri) {
        void var2_2;
        if (!uri.isAbsolute() && !uri.getPath().startsWith("/")) {
            void var1_1;
            Namespace namespace = this;
            return namespace.appendPathToBaseURI(namespace.getDevicePath((Device)var1_1) + "/" + String.valueOf(uri));
        }
        return var2_2;
    }

    public boolean isControlPath(URI uri) {
        return uri.toString().endsWith(CONTROL);
    }

    public boolean isEventSubscriptionPath(URI uri) {
        return uri.toString().endsWith(EVENTS);
    }

    public boolean isEventCallbackPath(URI uri) {
        return uri.toString().endsWith(CALLBACK_FILE);
    }

    /*
     * WARNING - void declaration
     */
    public Resource[] getResources(Device device) throws ValidationException {
        void var2_2;
        if (!device.isRoot()) {
            return null;
        }
        HashSet<Resource> resources = new HashSet<Resource>();
        ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
        this.logger.trace("Discovering local resources of device graph");
        Resource[] resourceArray = device = device.discoverResources(this);
        int n = device.length;
        int n2 = 0;
        while (n2 < n) {
            Resource resource = resourceArray[n2];
            this.logger.trace("Discovered: {}", (Object)resource);
            if (!resources.add(resource)) {
                void var1_1;
                this.logger.trace("Local resource already exists, queueing validation error");
                errors.add(new ValidationError(this.getClass(), "resources", "Local URI namespace conflict between resources of device: " + String.valueOf(var1_1)));
            }
            ++n2;
        }
        if (!errors.isEmpty()) {
            void var3_3;
            throw new ValidationException("Validation of device graph failed, call getErrors() on exception", (List<ValidationError>)var3_3);
        }
        void v0 = var2_2;
        return v0.toArray(new Resource[v0.size()]);
    }

    /*
     * WARNING - void declaration
     */
    protected URI appendPathToBaseURI(String path) {
        try {
            return new URI(this.basePath.getScheme(), null, this.basePath.getHost(), this.basePath.getPort(), this.decodedPath + path, null, null);
        }
        catch (URISyntaxException uRISyntaxException) {
            void var1_1;
            return URI.create(String.valueOf(this.basePath) + (String)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected String getDevicePath(Device device) {
        void var2_2;
        void var1_1;
        if (((DeviceIdentity)device.getIdentity()).getUdn() == null) {
            throw new IllegalStateException("Can't generate local URI prefix without UDN");
        }
        StringBuilder s = new StringBuilder();
        s.append("/dev/");
        s.append(URIUtil.encodePathSegment(((DeviceIdentity)var1_1.getIdentity()).getUdn().getIdentifierString()));
        return var2_2.toString();
    }

    /*
     * WARNING - void declaration
     */
    protected String getServicePath(Service service) {
        void var2_2;
        void var1_1;
        if (service.getServiceId() == null) {
            throw new IllegalStateException("Can't generate local URI prefix without service ID");
        }
        StringBuilder s = new StringBuilder();
        s.append(SERVICE);
        s.append("/");
        s.append(service.getServiceId().getNamespace());
        s.append("/");
        s.append(service.getServiceId().getId());
        return this.getDevicePath((Device)var1_1.getDevice()) + String.valueOf(var2_2);
    }
}

