/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.model;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;

public class ModelUtil {
    public static final boolean ANDROID_RUNTIME;
    public static final boolean ANDROID_EMULATOR;

    /*
     * WARNING - void declaration
     */
    static {
        void var0;
        Class<?> clazz;
        boolean foundAndroid = false;
        try {
            clazz = Thread.currentThread().getContextClassLoader().loadClass("android.os.Build");
            foundAndroid = clazz.getField("ID").get(null) != null;
        }
        catch (Exception exception) {}
        ANDROID_RUNTIME = foundAndroid;
        boolean foundEmulator = false;
        try {
            clazz = Thread.currentThread().getContextClassLoader().loadClass("android.os.Build");
            String product = (String)clazz.getField("PRODUCT").get(null);
            if ("google_sdk".equals(product) || "sdk".equals(clazz)) {
                foundEmulator = true;
            }
        }
        catch (Exception exception) {}
        ANDROID_EMULATOR = var0;
    }

    public static boolean isStringConvertibleType(Set<Class> stringConvertibleTypes, Class clazz) {
        Class clazz2;
        if (clazz.isEnum()) {
            return true;
        }
        Iterator<Class> iterator = clazz2.iterator();
        while (iterator.hasNext()) {
            clazz2 = iterator.next();
            if (!clazz2.isAssignableFrom(clazz)) continue;
            return true;
        }
        return false;
    }

    public static boolean isValidUDAName(String name) {
        String string;
        if (ANDROID_RUNTIME) {
            return name != null && !name.isEmpty();
        }
        return name != null && !name.isEmpty() && !name.toLowerCase(Locale.ENGLISH).startsWith("xml") && string.matches("[a-zA-Z0-9^-_\\p{L}\\p{N}]{1}[a-zA-Z0-9^-_\\.\\\\p{L}\\\\p{N}\\p{Mc}\\p{Sk}]*");
    }

    /*
     * WARNING - void declaration
     */
    public static InetAddress getInetAddressByName(String name) {
        try {
            return InetAddress.getByName(name);
        }
        catch (Exception e) {
            void var0_1;
            throw new RuntimeException((Throwable)var0_1);
        }
    }

    public static String toCommaSeparatedList(Object[] o) {
        return ModelUtil.toCommaSeparatedList(o, true, false);
    }

    /*
     * WARNING - void declaration
     */
    public static String toCommaSeparatedList(Object[] o, boolean escapeCommas, boolean escapeDoubleQuotes) {
        void var3_3;
        if (o == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        Object[] objectArray = o;
        int n = ((Object[])o).length;
        int n2 = 0;
        while (n2 < n) {
            Object object;
            o = objectArray[n2];
            o = o.toString();
            Object objString = o.replaceAll("\\\\", "\\\\\\\\");
            if (escapeCommas) {
                objString = ((String)objString).replaceAll(",", "\\\\,");
            }
            if (escapeDoubleQuotes) {
                objString = ((String)objString).replaceAll("\"", "\\\"");
            }
            sb.append((String)object).append(",");
            ++n2;
        }
        if (sb.length() > 1) {
            StringBuilder stringBuilder = sb;
            stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        }
        return var3_3.toString();
    }

    public static String[] fromCommaSeparatedList(String s) {
        return ModelUtil.fromCommaSeparatedList(s, true);
    }

    public static String[] fromCommaSeparatedList(String s, boolean unescapeCommas) {
        String[] stringArray;
        if (s == null || s.isEmpty()) {
            return null;
        }
        if (unescapeCommas) {
            s = s.replaceAll("\\\\,", "XXX1122334455XXX");
        }
        String[] split = s.split(",");
        int i = 0;
        while (i < split.length) {
            split[i] = split[i].replaceAll("XXX1122334455XXX", ",");
            split[i] = split[i].replaceAll("\\\\\\\\", "\\\\");
            ++i;
        }
        return stringArray;
    }

    /*
     * WARNING - void declaration
     */
    public static String toTimeString(long seconds) {
        void var2_1;
        long l;
        long hours = seconds / 3600L;
        long remainder = l % 3600L;
        long minutes = remainder / 60L;
        long secs = remainder % 60L;
        return (hours < 10L ? "0" : "") + (long)var2_1 + ":" + (minutes < 10L ? "0" : "") + minutes + ":" + (secs < 10L ? "0" : "") + secs;
    }

    /*
     * WARNING - void declaration
     */
    public static long fromTimeString(String s) {
        void var1_1;
        String[] split;
        if (s.lastIndexOf(".") != -1) {
            s = s.substring(0, s.lastIndexOf("."));
        }
        if ((split = s.split(":")).length != 3) {
            String string;
            throw new IllegalArgumentException("Can't parse time string: " + string);
        }
        return Long.parseLong(split[0]) * 3600L + Long.parseLong(split[1]) * 60L + Long.parseLong((String)var1_1[2]);
    }

    /*
     * WARNING - void declaration
     */
    public static String commaToNewline(String s) {
        void var1_1;
        StringBuilder sb = new StringBuilder();
        String[] stringArray = s = s.split(",");
        int n = s.length;
        int n2 = 0;
        while (n2 < n) {
            String string;
            String splitString = stringArray[n2];
            sb.append(string).append(",\n");
            ++n2;
        }
        if (sb.length() > 2) {
            StringBuilder stringBuilder = sb;
            stringBuilder.deleteCharAt(stringBuilder.length() - 2);
        }
        return var1_1.toString();
    }

    /*
     * WARNING - void declaration
     */
    public static String getLocalHostName(boolean includeDomain) {
        try {
            void var1_1;
            boolean bl;
            String hostname = InetAddress.getLocalHost().getHostName();
            if (bl) {
                return hostname;
            }
            if (hostname.contains(".")) {
                return hostname.substring(0, hostname.indexOf("."));
            }
            return var1_1;
        }
        catch (Exception exception) {
            return "UNKNOWN HOST";
        }
    }

    public static byte[] getFirstNetworkInterfaceHardwareAddress() {
        try {
            Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
            for (NetworkInterface iface : Collections.list(enumeration)) {
                if (iface.isLoopback() || !iface.isUp() || iface.getHardwareAddress() == null) continue;
                return ((NetworkInterface)((Object)enumeration)).getHardwareAddress();
            }
        }
        catch (Exception exception) {
            throw new RuntimeException("Could not discover first network interface hardware address");
        }
        throw new RuntimeException("Could not discover first network interface hardware address");
    }
}

