/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.model;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import org.jupnp.internal.compat.java.beans.PropertyChangeEvent;
import org.jupnp.internal.compat.java.beans.PropertyChangeListener;
import org.jupnp.internal.compat.java.beans.PropertyChangeSupport;
import org.jupnp.model.Command;
import org.jupnp.model.ModelUtil;
import org.jupnp.model.ServiceManager;
import org.jupnp.model.meta.LocalService;
import org.jupnp.model.meta.StateVariable;
import org.jupnp.model.state.StateVariableAccessor;
import org.jupnp.model.state.StateVariableValue;
import org.jupnp.util.Reflections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultServiceManager<T>
implements ServiceManager<T> {
    private final Logger logger = LoggerFactory.getLogger(DefaultServiceManager.class);
    protected final LocalService<T> service;
    protected final Class<T> serviceClass;
    protected final ReentrantLock lock = new ReentrantLock(true);
    protected T serviceImpl;
    protected PropertyChangeSupport propertyChangeSupport;

    /*
     * WARNING - void declaration
     */
    protected DefaultServiceManager(LocalService<T> service) {
        this((LocalService<T>)var1_1, null);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public DefaultServiceManager(LocalService<T> service, Class<T> serviceClass) {
        void var2_2;
        void var1_1;
        this.service = var1_1;
        this.serviceClass = var2_2;
    }

    /*
     * WARNING - void declaration
     */
    protected void lock() {
        try {
            if (this.lock.tryLock(this.getLockTimeoutMillis(), TimeUnit.MILLISECONDS)) {
                this.logger.trace("Acquired lock");
                return;
            }
            throw new RuntimeException("Failed to acquire lock in milliseconds: " + this.getLockTimeoutMillis());
        }
        catch (InterruptedException e) {
            void var1_1;
            throw new RuntimeException("Failed to acquire lock:" + String.valueOf(var1_1));
        }
    }

    protected void unlock() {
        this.logger.trace("Releasing lock");
        this.lock.unlock();
    }

    protected int getLockTimeoutMillis() {
        return 500;
    }

    @Override
    public LocalService<T> getService() {
        return this.service;
    }

    @Override
    public T getImplementation() {
        this.lock();
        try {
            if (this.serviceImpl == null) {
                this.init();
            }
            T t = this.serviceImpl;
            return t;
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public PropertyChangeSupport getPropertyChangeSupport() {
        this.lock();
        try {
            if (this.propertyChangeSupport == null) {
                this.init();
            }
            PropertyChangeSupport propertyChangeSupport = this.propertyChangeSupport;
            return propertyChangeSupport;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void execute(Command<T> cmd) throws Exception {
        this.lock();
        try {
            void var1_1;
            var1_1.execute(this);
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Collection<StateVariableValue> getCurrentState() throws Exception {
        this.lock();
        try {
            void var1_1;
            Collection<StateVariableValue> values = this.readInitialEventedStateVariableValues();
            if (values != null) {
                this.logger.trace("Obtained initial state variable values for event, skipping individual state variable accessors");
                return values;
            }
            values = new ArrayList<StateVariableValue>();
            StateVariable<S>[] stateVariableArray = this.getService().getStateVariables();
            int n = stateVariableArray.length;
            int n2 = 0;
            while (n2 < n) {
                StateVariable stateVariable = stateVariableArray[n2];
                if (stateVariable.getEventDetails().isSendEvents()) {
                    void var2_6;
                    StateVariableAccessor accessor = this.getService().getAccessor(stateVariable);
                    if (accessor == null) {
                        throw new IllegalStateException("No accessor for evented state variable");
                    }
                    values.add(accessor.read((StateVariable<LocalService>)var2_6, this.getImplementation()));
                }
                ++n2;
            }
            return var1_1;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    protected Collection<StateVariableValue> getCurrentState(String[] variableNames) throws Exception {
        this.lock();
        try {
            void var2_3;
            void var1_1;
            ArrayList<StateVariableValue> values = new ArrayList<StateVariableValue>();
            String[] stringArray = variableNames;
            int n = ((String[])variableNames).length;
            int n2 = 0;
            while (n2 < n) {
                variableNames = stringArray[n2];
                String variableName = variableNames.trim();
                StateVariable<LocalService> stateVariable = this.getService().getStateVariable(variableName);
                if (stateVariable == null || !stateVariable.getEventDetails().isSendEvents()) {
                    this.logger.trace("Ignoring unknown or non-evented state variable: {}", (Object)variableName);
                } else {
                    StateVariableAccessor accessor = this.getService().getAccessor(stateVariable);
                    if (accessor == null) {
                        this.logger.warn("Ignoring evented state variable without accessor: {}", (Object)var1_1);
                    } else {
                        values.add(accessor.read(stateVariable, this.getImplementation()));
                    }
                }
                ++n2;
            }
            var1_1 = var2_3;
            return var1_1;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void init() {
        this.logger.trace("No service implementation instance available, initializing...");
        try {
            this.serviceImpl = this.createServiceInstance();
            this.propertyChangeSupport = this.createPropertyChangeSupport(this.serviceImpl);
            DefaultServiceManager defaultServiceManager = this;
            this.propertyChangeSupport.addPropertyChangeListener(defaultServiceManager.createPropertyChangeListener(defaultServiceManager.serviceImpl));
            return;
        }
        catch (Exception e) {
            void var1_1;
            throw new RuntimeException("Could not initialize implementation", (Throwable)var1_1);
        }
    }

    protected T createServiceInstance() throws Exception {
        if (this.serviceClass == null) {
            throw new IllegalStateException("Subclass has to provide service class or override createServiceInstance()");
        }
        try {
            return this.serviceClass.getConstructor(LocalService.class).newInstance(this.getService());
        }
        catch (NoSuchMethodException noSuchMethodException) {
            this.logger.trace("Creating new service implementation instance with no-arg constructor: {}", (Object)this.serviceClass.getName());
            return this.serviceClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected PropertyChangeSupport createPropertyChangeSupport(T serviceImpl) throws Exception {
        void var1_1;
        Method m = Reflections.getGetterMethod(serviceImpl.getClass(), "propertyChangeSupport");
        if (m != null && PropertyChangeSupport.class.isAssignableFrom(m.getReturnType())) {
            void var2_2;
            this.logger.trace("Service implementation instance offers PropertyChangeSupport, using that: {}", (Object)serviceImpl.getClass().getName());
            return (PropertyChangeSupport)var2_2.invoke(serviceImpl, new Object[0]);
        }
        this.logger.trace("Creating new PropertyChangeSupport for service implementation: {}", (Object)serviceImpl.getClass().getName());
        return new PropertyChangeSupport(var1_1);
    }

    protected PropertyChangeListener createPropertyChangeListener(T serviceImpl) throws Exception {
        return new DefaultPropertyChangeListener();
    }

    protected Collection<StateVariableValue> readInitialEventedStateVariableValues() throws Exception {
        return null;
    }

    public String toString() {
        return "(" + this.getClass().getSimpleName() + ") Implementation: " + String.valueOf(this.serviceImpl);
    }

    protected class DefaultPropertyChangeListener
    implements PropertyChangeListener {
        protected DefaultPropertyChangeListener() {
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void propertyChange(PropertyChangeEvent pce) {
            DefaultServiceManager.this.logger.trace("Property change event on local service: {}", (Object)pce.getPropertyName());
            if (pce.getPropertyName().equals("_EventedStateVariables")) {
                return;
            }
            Object[] variableNames = ModelUtil.fromCommaSeparatedList(pce.getPropertyName());
            if (DefaultServiceManager.this.logger.isTraceEnabled()) {
                DefaultServiceManager.this.logger.trace("Changed variable names: {}", (Object)Arrays.toString(variableNames));
            }
            try {
                Collection<StateVariableValue> currentValues = DefaultServiceManager.this.getCurrentState((String[])variableNames);
                if (!currentValues.isEmpty()) {
                    DefaultServiceManager.this.getPropertyChangeSupport().firePropertyChange("_EventedStateVariables", null, currentValues);
                    return;
                }
            }
            catch (Exception e) {
                void var1_2;
                DefaultServiceManager.this.logger.error("Error reading state of service after state variable update event", (Throwable)var1_2);
            }
        }
    }
}

