/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.http;

import java.util.Enumeration;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestInfo {
    /*
     * WARNING - void declaration
     */
    public static void reportRequest(StringBuilder builder, HttpServletRequest req) {
        StringBuilder stringBuilder;
        builder.append("Request: ");
        builder.append(req.getMethod());
        builder.append(' ');
        builder.append(req.getRequestURL());
        String queryString = req.getQueryString();
        if (queryString != null) {
            builder.append('?');
            builder.append(queryString);
        }
        builder.append(" - ");
        String sessionId = req.getRequestedSessionId();
        if (sessionId != null) {
            builder.append("\nSession ID: ");
        }
        if (sessionId == null) {
            builder.append("No Session");
            return;
        }
        if (req.isRequestedSessionIdValid()) {
            void var1_1;
            void var2_2;
            builder.append((String)var2_2);
            builder.append(" (from ");
            if (req.isRequestedSessionIdFromCookie()) {
                builder.append("cookie)\n");
                return;
            }
            if (var1_1.isRequestedSessionIdFromURL()) {
                builder.append("url)\n");
                return;
            }
            builder.append("unknown)\n");
            return;
        }
        stringBuilder.append("Invalid Session ID\n");
    }

    public static void reportParameters(StringBuilder builder, HttpServletRequest req) {
        Enumeration names = req.getParameterNames();
        if (names == null) {
            return;
        }
        if (names.hasMoreElements()) {
            builder.append("Parameters:\n");
            while (names.hasMoreElements()) {
                String name = (String)names.nextElement();
                String[] values = req.getParameterValues(name);
                if (values == null) continue;
                String[] stringArray = values;
                int n = values.length;
                int n2 = 0;
                while (n2 < n) {
                    String value = stringArray[n2];
                    builder.append("    ").append(name).append(" = ").append(value).append('\n');
                    ++n2;
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void reportHeaders(StringBuilder builder, HttpServletRequest req) {
        Enumeration names = req.getHeaderNames();
        if (names == null) {
            return;
        }
        if (names.hasMoreElements()) {
            builder.append("Headers:\n");
            while (names.hasMoreElements()) {
                void var3_3;
                String name = (String)names.nextElement();
                String value = req.getHeader(name);
                builder.append("    ").append((String)var3_3).append(": ").append(value).append('\n');
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void reportCookies(StringBuilder builder, HttpServletRequest req) {
        Cookie[] cookies = req.getCookies();
        if (cookies == null) {
            return;
        }
        int n = cookies.length;
        if (n > 0) {
            builder.append("Cookies:\n");
            Cookie[] cookieArray = cookies;
            int n2 = cookies.length;
            n = 0;
            while (n < n2) {
                void var1_1;
                Cookie cookie = cookieArray[n];
                builder.append("    ").append(cookie.getName()).append(" = ").append(var1_1.getValue()).append('\n');
                ++n;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void reportClient(StringBuilder builder, HttpServletRequest req) {
        builder.append("Remote Address: ").append(req.getRemoteAddr()).append("\n");
        if (!req.getRemoteAddr().equals(req.getRemoteHost())) {
            builder.append("Remote Host: ").append(req.getRemoteHost()).append("\n");
        }
        builder.append("Remote Port: ").append(req.getRemotePort()).append("\n");
        if (req.getRemoteUser() != null) {
            void var1_1;
            StringBuilder stringBuilder;
            stringBuilder.append("Remote User: ").append(var1_1.getRemoteUser()).append("\n");
        }
    }

    /*
     * WARNING - void declaration
     */
    public static boolean isPS3Request(String userAgent, String avClientInfo) {
        void var1_1;
        String string;
        return userAgent != null && string.contains("PLAYSTATION 3") || avClientInfo != null && var1_1.contains("PLAYSTATION 3");
    }

    public static boolean isAndroidBubbleUPnPRequest(String userAgent) {
        String string;
        return userAgent != null && string.contains("BubbleUPnP");
    }

    public static boolean isPS3Request(HttpServletRequest request) {
        HttpServletRequest httpServletRequest;
        return RequestInfo.isPS3Request(request.getHeader("User-Agent"), httpServletRequest.getHeader("X-AV-Client-Info"));
    }

    public static boolean isJRiverRequest(HttpServletRequest request) {
        return RequestInfo.isJRiverRequest(request.getHeader("User-Agent"));
    }

    public static boolean isJRiverRequest(String userAgent) {
        String string;
        return userAgent != null && (userAgent.contains("J-River") || string.contains("J. River"));
    }

    public static boolean isWMPRequest(String userAgent) {
        String string;
        return userAgent != null && userAgent.contains("Windows-Media-Player") && !RequestInfo.isJRiverRequest(string);
    }

    public static boolean isXbox360Request(HttpServletRequest request) {
        HttpServletRequest httpServletRequest;
        return RequestInfo.isXbox360Request(request.getHeader("User-Agent"), httpServletRequest.getHeader("Server"));
    }

    /*
     * WARNING - void declaration
     */
    public static boolean isXbox360Request(String userAgent, String server) {
        void var1_1;
        String string;
        return userAgent != null && (userAgent.contains("Xbox") || string.contains("Xenon")) || server != null && var1_1.contains("Xbox");
    }

    public static boolean isXbox360AlbumArtRequest(HttpServletRequest request) {
        HttpServletRequest httpServletRequest;
        return "true".equals(request.getParameter("albumArt")) && RequestInfo.isXbox360Request(httpServletRequest);
    }

    /*
     * WARNING - void declaration
     */
    public static void dumpRequestHeaders(long timestamp, HttpServletRequest request) {
        void var2_1;
        RequestInfo.dumpRequestHeaders(timestamp, "REQUEST HEADERS", (HttpServletRequest)var2_1);
    }

    /*
     * WARNING - void declaration
     */
    public static void dumpRequestString(long timestamp, HttpServletRequest request) {
        void var2_1;
        long l;
        LoggerFactory.getLogger(RequestInfo.class).info(RequestInfo.getRequestInfoString(l, (HttpServletRequest)var2_1));
    }

    /*
     * WARNING - void declaration
     */
    public static void dumpRequestHeaders(long timestamp, String text, HttpServletRequest request) {
        void var2_2;
        Logger logger = LoggerFactory.getLogger(RequestInfo.class);
        logger.info((String)var2_2);
        RequestInfo.dumpRequestString(timestamp, request);
        Enumeration headers = request.getHeaderNames();
        if (headers != null) {
            while (headers.hasMoreElements()) {
                void var1_5;
                String headerName = (String)headers.nextElement();
                logger.info("{}: {}", (Object)headerName, (Object)request.getHeader((String)var1_5));
            }
        }
        logger.info("----------------------------------------");
    }

    /*
     * WARNING - void declaration
     */
    public static String getRequestInfoString(long timestamp, HttpServletRequest request) {
        long l;
        void var2_1;
        return String.format("%s %s %s %s %s %d", request.getMethod(), request.getRequestURI(), request.getProtocol(), request.getParameterMap(), var2_1.getRemoteAddr(), l);
    }

    /*
     * WARNING - void declaration
     */
    public static String getRequestFullURL(HttpServletRequest req) {
        void var2_2;
        void var1_1;
        String scheme = req.getScheme();
        String serverName = req.getServerName();
        int serverPort = req.getServerPort();
        String contextPath = req.getContextPath();
        String servletPath = req.getServletPath();
        String pathInfo = req.getPathInfo();
        Object queryString = req.getQueryString();
        StringBuilder url = new StringBuilder();
        url.append((String)var1_1).append("://").append((String)var2_2);
        if (serverPort != 80 && serverPort != 443) {
            void var3_3;
            url.append(":").append((int)var3_3);
        }
        url.append(contextPath).append(servletPath);
        if (pathInfo != null) {
            url.append(pathInfo);
        }
        if (queryString != null) {
            Object object;
            url.append("?").append((String)object);
        }
        return url.toString();
    }
}

