/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.http;

import java.io.Serializable;
import java.net.URL;
import java.net.URLConnection;
import java.util.Date;
import org.jupnp.http.CacheControl;

public class Representation<E>
implements Serializable {
    private URL url;
    private CacheControl cacheControl;
    private Integer contentLength;
    private String contentType;
    private Long lastModified;
    private String entityTag;
    private E entity;

    /*
     * WARNING - void declaration
     */
    public Representation(CacheControl cacheControl, Integer contentLength, String contentType, Long lastModified, String entityTag, E entity) {
        this(null, (CacheControl)var1_1, (Integer)var2_2, (String)var3_3, lastModified, entityTag, entity);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public Representation(URL url, CacheControl cacheControl, Integer contentLength, String contentType, Long lastModified, String entityTag, E entity) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.url = var1_1;
        this.cacheControl = var2_2;
        this.contentLength = var3_3;
        this.contentType = contentType;
        this.lastModified = lastModified;
        this.entityTag = entityTag;
        this.entity = entity;
    }

    /*
     * WARNING - void declaration
     */
    public Representation(URLConnection urlConnection, E entity) {
        this(urlConnection.getURL(), CacheControl.valueOf(urlConnection.getHeaderField("Cache-Control")), urlConnection.getContentLength(), urlConnection.getContentType(), urlConnection.getLastModified(), var1_1.getHeaderField("Etag"), var2_2);
        void var2_2;
        void var1_1;
    }

    public URL getUrl() {
        return this.url;
    }

    public CacheControl getCacheControl() {
        return this.cacheControl;
    }

    public Integer getContentLength() {
        if (this.contentLength == null || this.contentLength == -1) {
            return null;
        }
        return this.contentLength;
    }

    public String getContentType() {
        return this.contentType;
    }

    public Long getLastModified() {
        if (this.lastModified == 0L) {
            return null;
        }
        return this.lastModified;
    }

    public String getEntityTag() {
        return this.entityTag;
    }

    public E getEntity() {
        return this.entity;
    }

    public Long getMaxAgeOrNull() {
        if (this.getCacheControl() == null || this.getCacheControl().getMaxAge() == -1 || this.getCacheControl().getMaxAge() == 0) {
            return null;
        }
        return this.getCacheControl().getMaxAge();
    }

    /*
     * WARNING - void declaration
     */
    public boolean isExpired(long storedOn, long maxAge) {
        void var3_2;
        return storedOn + var3_2 * 1000L < new Date().getTime();
    }

    /*
     * WARNING - void declaration
     */
    public boolean isExpired(long storedOn) {
        void var1_1;
        return this.getMaxAgeOrNull() == null || this.isExpired((long)var1_1, this.getMaxAgeOrNull());
    }

    public boolean isNoStore() {
        return this.getCacheControl() != null && this.getCacheControl().isNoStore();
    }

    public boolean isNoCache() {
        return this.getCacheControl() != null && this.getCacheControl().isNoCache();
    }

    public boolean mustRevalidate() {
        return this.getCacheControl() != null && this.getCacheControl().isProxyRevalidate();
    }

    /*
     * WARNING - void declaration
     */
    public boolean hasEntityTagChanged(String currentEtag) {
        void var1_1;
        return this.getEntityTag() != null && !this.getEntityTag().equals(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public boolean hasBeenModified(long currentModificationTime) {
        void var1_1;
        return this.getLastModified() == null || this.getLastModified() < var1_1;
    }

    public String toString() {
        return "(" + this.getClass().getSimpleName() + ") CT: " + this.getContentType();
    }
}

