/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.http;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import org.jupnp.http.Representation;
import org.jupnp.util.io.IO;

public class HttpFetch {
    public static Representation<byte[]> fetchBinary(URL url) throws IOException {
        return HttpFetch.fetchBinary(url, 500, 500);
    }

    /*
     * WARNING - void declaration
     */
    public static Representation<byte[]> fetchBinary(URL url, int connectTimeoutMillis, int readTimeoutMillis) throws IOException {
        void var2_2;
        void var1_1;
        return HttpFetch.fetch(url, (int)var1_1, (int)var2_2, (urlConnection, is) -> {
            void var1_1;
            URLConnection uRLConnection;
            return new Representation<byte[]>(uRLConnection, IO.readAllBytes((InputStream)var1_1));
        });
    }

    /*
     * WARNING - void declaration
     */
    public static Representation<String> fetchString(URL url, int connectTimeoutMillis, int readTimeoutMillis) throws IOException {
        void var2_2;
        void var1_1;
        return HttpFetch.fetch(url, (int)var1_1, (int)var2_2, (urlConnection, is) -> {
            void var1_1;
            URLConnection uRLConnection;
            return new Representation<String>(uRLConnection, IO.readLines((InputStream)var1_1));
        });
    }

    /*
     * WARNING - void declaration
     */
    public static <E> Representation<E> fetch(URL url, int connectTimeoutMillis, int readTimeoutMillis, RepresentationFactory<E> factory) throws IOException {
        void var3_3;
        void var2_2;
        void var1_1;
        return HttpFetch.fetch(url, "GET", (int)var1_1, (int)var2_2, var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public static <E> Representation<E> fetch(URL url, String method, int connectTimeoutMillis, int readTimeoutMillis, RepresentationFactory<E> factory) throws IOException {
        HttpURLConnection urlConnection = null;
        InputStream is = null;
        try {
            void var3_6;
            void var2_5;
            urlConnection = (HttpURLConnection)url.openConnection();
            urlConnection.setRequestMethod(method);
            urlConnection.setConnectTimeout((int)var2_5);
            urlConnection.setReadTimeout((int)var3_6);
            is = urlConnection.getInputStream();
            url = factory.createRepresentation(urlConnection, is);
            return url;
        }
        catch (IOException e) {
            void var0_1;
            if (urlConnection != null) {
                void var0_2;
                int responseCode = urlConnection.getResponseCode();
                InputStream errorStream = urlConnection.getErrorStream();
                if (errorStream != null) {
                    void var1_4;
                    while (errorStream.read() != -1) {
                    }
                    var1_4.close();
                }
                throw new IOException("Fetching resource failed, returned status code: " + (int)var0_2);
            }
            throw var0_1;
        }
        finally {
            if (is != null) {
                is.close();
            }
            if (urlConnection != null) {
                urlConnection.disconnect();
            }
        }
    }

    public static void validate(URL url) throws IOException {
        HttpFetch.fetch(url, "HEAD", 500, 500, (urlConnection, is) -> {
            URLConnection uRLConnection;
            return new Representation<Object>(uRLConnection, null);
        });
    }

    public static interface RepresentationFactory<E> {
        public Representation<E> createRepresentation(URLConnection var1, InputStream var2) throws IOException;
    }
}

