/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.http;

import java.io.ByteArrayInputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Headers
implements Map<String, List<String>> {
    static final byte CR = 13;
    static final byte LF = 10;
    final Map<String, List<String>> map = new HashMap<String, List<String>>(32);
    private boolean normalizeHeaders = true;

    public Headers() {
    }

    /*
     * WARNING - void declaration
     */
    public Headers(Map<String, List<String>> map) {
        void var1_1;
        this.putAll((Map<? extends String, ? extends List<String>>)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public Headers(ByteArrayInputStream inputStream) {
        void var3_3;
        StringBuilder sb = new StringBuilder(256);
        Headers headers = new Headers();
        String line = Headers.readLine(sb, inputStream);
        String lastHeader = null;
        if (!line.isEmpty()) {
            String string;
            do {
                char firstChar = line.charAt(0);
                if (lastHeader != null && (firstChar == ' ' || firstChar == '\t')) {
                    Object current = headers.get(lastHeader);
                    int lastPos = current.size() - 1;
                    String newString = (String)current.get(lastPos) + line.trim();
                    current.set(lastPos, newString);
                } else {
                    String[] header = this.splitHeader(string);
                    headers.add(header[0], header[1]);
                    lastHeader = header[0];
                }
                sb.delete(0, sb.length());
            } while (!(string = Headers.readLine(sb, inputStream)).isEmpty());
        }
        this.putAll((Map<? extends String, ? extends List<String>>)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public Headers(boolean normalizeHeaders) {
        void var1_1;
        this.normalizeHeaders = var1_1;
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean containsKey(Object key) {
        void var1_1;
        return key != null && key instanceof String && this.map.containsKey(this.normalize((String)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean containsValue(Object value) {
        void var1_1;
        return this.map.containsValue(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public List<String> get(Object key) {
        void var1_1;
        return this.map.get(this.normalize((String)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public List<String> put(String key, List<String> value) {
        void var2_2;
        void var1_1;
        return this.map.put(this.normalize((String)var1_1), (List<String>)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public List<String> remove(Object key) {
        void var1_1;
        return this.map.remove(this.normalize((String)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void putAll(Map<? extends String, ? extends List<String>> t) {
        for (Map.Entry<? extends String, ? extends List<String>> entry : t.entrySet()) {
            void var1_1;
            this.put(entry.getKey(), (List)var1_1.getValue());
        }
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public Set<String> keySet() {
        return this.map.keySet();
    }

    @Override
    public Collection<List<String>> values() {
        return this.map.values();
    }

    @Override
    public Set<Map.Entry<String, List<String>>> entrySet() {
        return this.map.entrySet();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean equals(Object o) {
        void var1_1;
        return this.map.equals(var1_1);
    }

    @Override
    public int hashCode() {
        return this.map.hashCode();
    }

    /*
     * WARNING - void declaration
     */
    public String getFirstHeader(String key) {
        List<String> l = this.map.get(this.normalize(key));
        if (l != null && !l.isEmpty()) {
            void var1_1;
            return (String)var1_1.get(0);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public void add(String key, String value) {
        void var2_2;
        List list;
        String k = this.normalize(key);
        list = this.map.computeIfAbsent((String)((Object)list), k1 -> new LinkedList());
        list.add(var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public void set(String key, String value) {
        void var3_3;
        void var1_1;
        void var2_2;
        LinkedList<void> l = new LinkedList<void>();
        l.add(var2_2);
        this.put((String)var1_1, (List<String>)var3_3);
    }

    private String normalize(String key) {
        String string;
        String result = key;
        if (this.normalizeHeaders) {
            if (key == null) {
                return null;
            }
            if (key.isEmpty()) {
                return key;
            }
            char[] b = key.toCharArray();
            if (b[0] >= 'a' && b[0] <= 'z') {
                b[0] = (char)(b[0] - 32);
            }
            int length = key.length();
            int i = 1;
            while (i < length) {
                if (b[i] >= 'A' && b[i] <= 'Z') {
                    b[i] = (char)(b[i] + 32);
                }
                ++i;
            }
            string = new String((char[])string);
        }
        return string;
    }

    public static String readLine(ByteArrayInputStream is) {
        ByteArrayInputStream byteArrayInputStream;
        return Headers.readLine(new StringBuilder(256), byteArrayInputStream);
    }

    /*
     * WARNING - void declaration
     */
    public static String readLine(StringBuilder sb, ByteArrayInputStream is) {
        StringBuilder stringBuilder;
        int nextByte;
        while ((nextByte = is.read()) != -1) {
            void var3_3;
            char nextChar = (char)nextByte;
            if (nextChar == '\r') {
                char c = (char)is.read();
                nextByte = c;
                if (c == '\n') {
                    break;
                }
            } else if (nextChar == '\n') break;
            sb.append((char)var3_3);
        }
        return stringBuilder.toString();
    }

    /*
     * WARNING - void declaration
     */
    protected String[] splitHeader(String sb) {
        void var1_1;
        void var3_3;
        void var2_2;
        int nameStart;
        int nameEnd = nameStart = this.findNonWhitespace(sb, 0);
        while (nameEnd < sb.length()) {
            char ch = sb.charAt(nameEnd);
            if (ch == ':' || Character.isWhitespace(ch)) break;
            ++nameEnd;
        }
        int colonEnd = nameEnd;
        while (colonEnd < sb.length()) {
            if (sb.charAt(colonEnd) == ':') {
                ++colonEnd;
                break;
            }
            ++colonEnd;
        }
        int valueStart = this.findNonWhitespace(sb, colonEnd);
        int valueEnd = this.findEndOfString(sb);
        return new String[]{sb.substring((int)var2_2, (int)var3_3), sb.length() >= valueStart && sb.length() >= valueEnd && valueStart < valueEnd ? var1_1.substring(valueStart, valueEnd) : null};
    }

    /*
     * WARNING - void declaration
     */
    protected int findNonWhitespace(String sb, int offset) {
        void var2_2;
        int result = offset;
        while (result < sb.length()) {
            if (!Character.isWhitespace(sb.charAt(result))) break;
            ++result;
        }
        return (int)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    protected int findEndOfString(String sb) {
        void var2_2;
        int result = sb.length();
        while (result > 0) {
            if (!Character.isWhitespace(sb.charAt(result - 1))) break;
            --result;
        }
        return (int)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public String toString() {
        void var1_1;
        StringBuilder headerString = new StringBuilder(512);
        for (Map.Entry<String, List<String>> headerEntry : this.entrySet()) {
            headerString.append(headerEntry.getKey()).append(": ");
            for (String v : headerEntry.getValue()) {
                void var2_3;
                headerString.append((String)var2_3).append(",");
            }
            StringBuilder stringBuilder = headerString;
            stringBuilder.delete(stringBuilder.length() - 1, headerString.length());
            headerString.append("\r\n");
        }
        return var1_1.toString();
    }
}

