/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.http;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class CacheControl {
    private int maxAge = -1;
    private int sharedMaxAge = -1;
    private boolean noCache = false;
    private List<String> noCacheFields = new ArrayList<String>();
    private boolean privateFlag = false;
    private List<String> privateFields = new ArrayList<String>();
    private boolean noStore = false;
    private boolean noTransform = true;
    private boolean mustRevalidate = false;
    private boolean proxyRevalidate = false;
    private Map<String, String> cacheExtensions = new HashMap<String, String>();

    public int getMaxAge() {
        return this.maxAge;
    }

    /*
     * WARNING - void declaration
     */
    public void setMaxAge(int maxAge) {
        void var1_1;
        this.maxAge = var1_1;
    }

    public int getSharedMaxAge() {
        return this.sharedMaxAge;
    }

    /*
     * WARNING - void declaration
     */
    public void setSharedMaxAge(int sharedMaxAge) {
        void var1_1;
        this.sharedMaxAge = var1_1;
    }

    public boolean isNoCache() {
        return this.noCache;
    }

    /*
     * WARNING - void declaration
     */
    public void setNoCache(boolean noCache) {
        void var1_1;
        this.noCache = var1_1;
    }

    public List<String> getNoCacheFields() {
        return this.noCacheFields;
    }

    /*
     * WARNING - void declaration
     */
    public void setNoCacheFields(List<String> noCacheFields) {
        void var1_1;
        this.noCacheFields = var1_1;
    }

    public boolean isPrivateFlag() {
        return this.privateFlag;
    }

    /*
     * WARNING - void declaration
     */
    public void setPrivateFlag(boolean privateFlag) {
        void var1_1;
        this.privateFlag = var1_1;
    }

    public List<String> getPrivateFields() {
        return this.privateFields;
    }

    /*
     * WARNING - void declaration
     */
    public void setPrivateFields(List<String> privateFields) {
        void var1_1;
        this.privateFields = var1_1;
    }

    public boolean isNoStore() {
        return this.noStore;
    }

    /*
     * WARNING - void declaration
     */
    public void setNoStore(boolean noStore) {
        void var1_1;
        this.noStore = var1_1;
    }

    public boolean isNoTransform() {
        return this.noTransform;
    }

    /*
     * WARNING - void declaration
     */
    public void setNoTransform(boolean noTransform) {
        void var1_1;
        this.noTransform = var1_1;
    }

    public boolean isMustRevalidate() {
        return this.mustRevalidate;
    }

    /*
     * WARNING - void declaration
     */
    public void setMustRevalidate(boolean mustRevalidate) {
        void var1_1;
        this.mustRevalidate = var1_1;
    }

    public boolean isProxyRevalidate() {
        return this.proxyRevalidate;
    }

    /*
     * WARNING - void declaration
     */
    public void setProxyRevalidate(boolean proxyRevalidate) {
        void var1_1;
        this.proxyRevalidate = var1_1;
    }

    public Map<String, String> getCacheExtensions() {
        return this.cacheExtensions;
    }

    /*
     * WARNING - void declaration
     */
    public void setCacheExtensions(Map<String, String> cacheExtensions) {
        void var1_1;
        this.cacheExtensions = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static CacheControl valueOf(String s) throws IllegalArgumentException {
        void var1_1;
        if (s == null) {
            return null;
        }
        CacheControl result = new CacheControl();
        String[] stringArray = s = s.split(",");
        int n = ((String[])s).length;
        int n2 = 0;
        while (n2 < n) {
            Object object;
            Object lowercase;
            s = stringArray[n2];
            s = s.trim();
            Object nameValue = s.split("=");
            String name = nameValue[0].trim();
            String value = null;
            if (((String[])nameValue).length > 1) {
                value = nameValue[1].trim();
                if (value.startsWith("\"")) {
                    value = value.substring(1);
                }
                if (value.endsWith("\"")) {
                    value = value.substring(0, value.length() - 1);
                }
            }
            if ("no-cache".equals(lowercase = name.toLowerCase())) {
                result.setNoCache(true);
                if (value != null && !value.isEmpty()) {
                    result.getNoCacheFields().add(value);
                }
            } else if ("private".equals(lowercase)) {
                result.setPrivateFlag(true);
                if (value != null && !value.isEmpty()) {
                    result.getPrivateFields().add(value);
                }
            } else if ("no-store".equals(lowercase)) {
                result.setNoStore(true);
            } else if ("max-age".equals(lowercase)) {
                if (value == null) {
                    throw new IllegalArgumentException("CacheControl max-age header does not have a value: " + value);
                }
                result.setMaxAge(Integer.parseInt(value));
            } else if ("s-maxage".equals(lowercase)) {
                if (value == null) {
                    throw new IllegalArgumentException("CacheControl s-maxage header does not have a value: " + value);
                }
                result.setSharedMaxAge(Integer.parseInt(value));
            } else if ("no-transform".equals(lowercase)) {
                result.setNoTransform(true);
            } else if ("must-revalidate".equals(lowercase)) {
                result.setMustRevalidate(true);
            } else if ("proxy-revalidate".equals(lowercase)) {
                result.setProxyRevalidate(true);
            } else if (!"public".equals(object)) {
                if (value == null) {
                    value = "";
                }
                result.getCacheExtensions().put(name, value);
            }
            ++n2;
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public String toString() {
        void var1_1;
        List<String> list;
        StringBuilder sb = new StringBuilder();
        if (!this.isPrivateFlag()) {
            sb.append("public");
        }
        if (this.isMustRevalidate()) {
            this.append("must-revalidate", sb);
        }
        if (this.isNoTransform()) {
            this.append("no-transform", sb);
        }
        if (this.isNoStore()) {
            this.append("no-store", sb);
        }
        if (this.isProxyRevalidate()) {
            this.append("proxy-revalidate", sb);
        }
        if (this.getSharedMaxAge() >= 0) {
            this.append("s-maxage", sb).append("=").append(this.getSharedMaxAge());
        }
        if (this.getMaxAge() >= 0) {
            this.append("max-age", sb).append("=").append(this.getMaxAge());
        }
        if (this.isNoCache()) {
            list = this.getNoCacheFields();
            if (list.isEmpty()) {
                this.append("no-cache", sb);
            } else {
                for (String field : this.getNoCacheFields()) {
                    this.append("no-cache", sb).append("=\"").append(field).append("\"");
                }
            }
        }
        if (this.isPrivateFlag()) {
            list = this.getPrivateFields();
            if (list.isEmpty()) {
                this.append("private", sb);
            } else {
                for (String field : this.getPrivateFields()) {
                    Iterator<String> iterator;
                    this.append("private", sb).append("=\"").append((String)((Object)iterator)).append("\"");
                }
            }
        }
        for (String key : this.getCacheExtensions().keySet()) {
            String val = this.getCacheExtensions().get(key);
            this.append((String)((Object)list), sb);
            if (val == null || val.isEmpty()) continue;
            sb.append("=\"").append(val).append("\"");
        }
        return var1_1.toString();
    }

    /*
     * WARNING - void declaration
     */
    private StringBuilder append(String s, StringBuilder sb) {
        void var2_2;
        void var1_1;
        if (sb.length() > 0) {
            sb.append(", ");
        }
        sb.append((String)var1_1);
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(Object o) {
        void var1_1;
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CacheControl that = (CacheControl)o;
        if (this.maxAge != that.maxAge) {
            return false;
        }
        if (this.mustRevalidate != that.mustRevalidate) {
            return false;
        }
        if (this.noCache != that.noCache) {
            return false;
        }
        if (this.noStore != that.noStore) {
            return false;
        }
        if (this.noTransform != that.noTransform) {
            return false;
        }
        if (this.privateFlag != that.privateFlag) {
            return false;
        }
        if (this.proxyRevalidate != that.proxyRevalidate) {
            return false;
        }
        if (this.sharedMaxAge != that.sharedMaxAge) {
            return false;
        }
        if (!this.cacheExtensions.equals(that.cacheExtensions)) {
            return false;
        }
        if (!this.noCacheFields.equals(that.noCacheFields)) {
            return false;
        }
        return this.privateFields.equals(var1_1.privateFields);
    }

    /*
     * WARNING - void declaration
     */
    public int hashCode() {
        void var1_1;
        int result = this.maxAge;
        result = result * 31 + this.sharedMaxAge;
        result = result * 31 + (this.noCache ? 1 : 0);
        result = result * 31 + this.noCacheFields.hashCode();
        result = result * 31 + (this.privateFlag ? 1 : 0);
        result = result * 31 + this.privateFields.hashCode();
        result = result * 31 + (this.noStore ? 1 : 0);
        result = result * 31 + (this.noTransform ? 1 : 0);
        result = result * 31 + (this.mustRevalidate ? 1 : 0);
        result = result * 31 + (this.proxyRevalidate ? 1 : 0);
        var1_1 = var1_1 * 31 + this.cacheExtensions.hashCode();
        return (int)var1_1;
    }
}

