/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.controlpoint;

import java.util.List;
import org.jupnp.controlpoint.ControlPoint;
import org.jupnp.model.UnsupportedDataException;
import org.jupnp.model.gena.CancelReason;
import org.jupnp.model.gena.GENASubscription;
import org.jupnp.model.gena.LocalGENASubscription;
import org.jupnp.model.gena.RemoteGENASubscription;
import org.jupnp.model.message.UpnpResponse;
import org.jupnp.model.meta.Device;
import org.jupnp.model.meta.DeviceIdentity;
import org.jupnp.model.meta.LocalService;
import org.jupnp.model.meta.RemoteService;
import org.jupnp.model.meta.Service;
import org.jupnp.protocol.ProtocolCreationException;
import org.jupnp.protocol.sync.SendingSubscribe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SubscriptionCallback
implements Runnable {
    protected Logger logger = LoggerFactory.getLogger(SubscriptionCallback.class);
    protected final Service service;
    protected final Integer requestedDurationSeconds;
    private ControlPoint controlPoint;
    private GENASubscription subscription;

    /*
     * WARNING - void declaration
     */
    protected SubscriptionCallback(Service service) {
        void var1_1;
        this.service = var1_1;
        this.requestedDurationSeconds = 1800;
    }

    /*
     * WARNING - void declaration
     */
    protected SubscriptionCallback(Service service, int requestedDurationSeconds) {
        void var2_2;
        void var1_1;
        this.service = var1_1;
        this.requestedDurationSeconds = (int)var2_2;
    }

    public Service getService() {
        return this.service;
    }

    public synchronized ControlPoint getControlPoint() {
        return this.controlPoint;
    }

    /*
     * WARNING - void declaration
     */
    public synchronized void setControlPoint(ControlPoint controlPoint) {
        void var1_1;
        this.controlPoint = var1_1;
    }

    public synchronized GENASubscription getSubscription() {
        return this.subscription;
    }

    /*
     * WARNING - void declaration
     */
    public synchronized void setSubscription(GENASubscription subscription) {
        void var1_1;
        this.subscription = var1_1;
    }

    @Override
    public synchronized void run() {
        if (this.getControlPoint() == null) {
            throw new IllegalStateException("Callback must be executed through ControlPoint");
        }
        if (this.getService() instanceof LocalService) {
            SubscriptionCallback subscriptionCallback = this;
            subscriptionCallback.establishLocalSubscription((LocalService)subscriptionCallback.service);
            return;
        }
        if (this.getService() instanceof RemoteService) {
            SubscriptionCallback subscriptionCallback = this;
            subscriptionCallback.establishRemoteSubscription((RemoteService)subscriptionCallback.service);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void establishLocalSubscription(LocalService service) {
        if (this.getControlPoint().getRegistry().getLocalDevice(((DeviceIdentity)((Device)service.getDevice()).getIdentity()).getUdn(), false) == null) {
            this.logger.trace("Local device service is currently not registered, failing subscription immediately");
            this.failed(null, null, new IllegalStateException("Local device is not registered"));
            return;
        }
        LocalGENASubscription localSubscription = null;
        try {
            localSubscription = new LocalGENASubscription(service, Integer.MAX_VALUE, List.of()){
                {
                    void var3_3;
                    void var2_2;
                    super((LocalService)var2_2, (Integer)var3_3, $anonymous2);
                }

                /*
                 * WARNING - void declaration
                 */
                public void failed(Exception e) {
                    SubscriptionCallback subscriptionCallback = SubscriptionCallback.this;
                    synchronized (subscriptionCallback) {
                        void var1_1;
                        SubscriptionCallback.this.setSubscription(null);
                        SubscriptionCallback.this.failed(null, null, (Exception)var1_1);
                        return;
                    }
                }

                @Override
                public void established() {
                    SubscriptionCallback subscriptionCallback = SubscriptionCallback.this;
                    synchronized (subscriptionCallback) {
                        SubscriptionCallback.this.setSubscription(this);
                        SubscriptionCallback.this.established(this);
                        return;
                    }
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public void ended(CancelReason reason) {
                    SubscriptionCallback subscriptionCallback = SubscriptionCallback.this;
                    synchronized (subscriptionCallback) {
                        void var1_1;
                        SubscriptionCallback.this.setSubscription(null);
                        SubscriptionCallback.this.ended(this, (CancelReason)var1_1, null);
                        return;
                    }
                }

                @Override
                public void eventReceived() {
                    SubscriptionCallback subscriptionCallback = SubscriptionCallback.this;
                    synchronized (subscriptionCallback) {
                        SubscriptionCallback.this.logger.trace("Local service state updated, notifying callback, sequence is: {}", (Object)this.getCurrentSequence());
                        SubscriptionCallback.this.eventReceived(this);
                        this.incrementSequence();
                        return;
                    }
                }
            };
            this.logger.trace("Local device service is currently registered, also registering subscription");
            this.getControlPoint().getRegistry().addLocalSubscription(localSubscription);
            this.logger.trace("Notifying subscription callback of local subscription availability");
            localSubscription.establish();
            this.logger.trace("Simulating first initial event for local subscription callback, sequence: {}", (Object)localSubscription.getCurrentSequence());
            this.eventReceived(localSubscription);
            localSubscription.incrementSequence();
            this.logger.trace("Starting to monitor state changes of local service");
            localSubscription.registerOnService();
            return;
        }
        catch (Exception e) {
            void var1_2;
            void var2_3;
            this.logger.trace("Local callback creation failed", (Throwable)e);
            if (localSubscription != null) {
                this.getControlPoint().getRegistry().removeLocalSubscription(localSubscription);
            }
            this.failed((GENASubscription)var2_3, null, (Exception)var1_2);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void establishRemoteSubscription(RemoteService service) {
        void var1_1;
        RemoteGENASubscription remoteSubscription = new RemoteGENASubscription(service, this.requestedDurationSeconds){
            {
                void var3_3;
                void var2_2;
                super((RemoteService)var2_2, (int)var3_3);
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public void failed(UpnpResponse responseStatus) {
                SubscriptionCallback subscriptionCallback = SubscriptionCallback.this;
                synchronized (subscriptionCallback) {
                    void var1_1;
                    SubscriptionCallback.this.setSubscription(null);
                    SubscriptionCallback.this.failed(this, (UpnpResponse)var1_1, null);
                    return;
                }
            }

            @Override
            public void established() {
                SubscriptionCallback subscriptionCallback = SubscriptionCallback.this;
                synchronized (subscriptionCallback) {
                    SubscriptionCallback.this.setSubscription(this);
                    SubscriptionCallback.this.established(this);
                    return;
                }
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public void ended(CancelReason reason, UpnpResponse responseStatus) {
                SubscriptionCallback subscriptionCallback = SubscriptionCallback.this;
                synchronized (subscriptionCallback) {
                    void var2_2;
                    void var1_1;
                    SubscriptionCallback.this.setSubscription(null);
                    SubscriptionCallback.this.ended(this, (CancelReason)var1_1, (UpnpResponse)var2_2);
                    return;
                }
            }

            @Override
            public void eventReceived() {
                SubscriptionCallback subscriptionCallback = SubscriptionCallback.this;
                synchronized (subscriptionCallback) {
                    SubscriptionCallback.this.eventReceived(this);
                    return;
                }
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public void eventsMissed(int numberOfMissedEvents) {
                SubscriptionCallback subscriptionCallback = SubscriptionCallback.this;
                synchronized (subscriptionCallback) {
                    void var1_1;
                    SubscriptionCallback.this.eventsMissed(this, (int)var1_1);
                    return;
                }
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public void invalidMessage(UnsupportedDataException e) {
                SubscriptionCallback subscriptionCallback = SubscriptionCallback.this;
                synchronized (subscriptionCallback) {
                    void var1_1;
                    SubscriptionCallback.this.invalidMessage(this, (UnsupportedDataException)var1_1);
                    return;
                }
            }
        };
        try {
            SendingSubscribe protocol = this.getControlPoint().getProtocolFactory().createSendingSubscribe(remoteSubscription);
        }
        catch (ProtocolCreationException e) {
            SubscriptionCallback subscriptionCallback = this;
            subscriptionCallback.failed(subscriptionCallback.subscription, null, e);
            return;
        }
        var1_1.run();
    }

    public synchronized void end() {
        if (this.subscription == null) {
            return;
        }
        if (this.subscription instanceof LocalGENASubscription) {
            SubscriptionCallback subscriptionCallback = this;
            subscriptionCallback.endLocalSubscription((LocalGENASubscription)subscriptionCallback.subscription);
            return;
        }
        if (this.subscription instanceof RemoteGENASubscription) {
            SubscriptionCallback subscriptionCallback = this;
            subscriptionCallback.endRemoteSubscription((RemoteGENASubscription)subscriptionCallback.subscription);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void endLocalSubscription(LocalGENASubscription subscription) {
        void var1_1;
        this.logger.trace("Removing local subscription and ending it in callback: {}", (Object)subscription);
        this.getControlPoint().getRegistry().removeLocalSubscription(subscription);
        var1_1.end(null);
    }

    /*
     * WARNING - void declaration
     */
    private void endRemoteSubscription(RemoteGENASubscription subscription) {
        void var1_1;
        this.logger.trace("Ending remote subscription: {}", (Object)subscription);
        this.getControlPoint().getConfiguration().getSyncProtocolExecutorService().execute(this.getControlPoint().getProtocolFactory().createSendingUnsubscribe((RemoteGENASubscription)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    protected void failed(GENASubscription subscription, UpnpResponse responseStatus, Exception exception) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.failed((GENASubscription)var1_1, responseStatus, exception, SubscriptionCallback.createDefaultFailureMessage((UpnpResponse)var2_2, (Exception)var3_3));
    }

    protected abstract void failed(GENASubscription var1, UpnpResponse var2, Exception var3, String var4);

    protected abstract void established(GENASubscription var1);

    protected abstract void ended(GENASubscription var1, CancelReason var2, UpnpResponse var3);

    protected abstract void eventReceived(GENASubscription var1);

    protected abstract void eventsMissed(GENASubscription var1, int var2);

    /*
     * WARNING - void declaration
     */
    public static String createDefaultFailureMessage(UpnpResponse responseStatus, Exception exception) {
        void var2_2;
        void var1_1;
        UpnpResponse upnpResponse;
        Object message = "Subscription failed: ";
        message = responseStatus != null ? (String)message + " HTTP response was: " + upnpResponse.getResponseDetails() : (exception != null ? (String)message + " Exception occurred: " + String.valueOf(var1_1) : (String)message + " No response received.");
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    protected void invalidMessage(RemoteGENASubscription remoteGENASubscription, UnsupportedDataException e) {
        this.logger.info("Invalid event message received", (Throwable)e);
        if (this.logger.isTraceEnabled()) {
            void var2_2;
            this.logger.trace("------------------------------------------------------------------------------");
            this.logger.trace(e.getData() != null ? var2_2.getData().toString() : "null");
            this.logger.trace("------------------------------------------------------------------------------");
        }
    }

    public String toString() {
        return "(SubscriptionCallback) " + String.valueOf(this.getService());
    }
}

