/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.controlpoint;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.jupnp.UpnpServiceConfiguration;
import org.jupnp.controlpoint.ActionCallback;
import org.jupnp.controlpoint.ControlPoint;
import org.jupnp.controlpoint.SubscriptionCallback;
import org.jupnp.controlpoint.event.ExecuteAction;
import org.jupnp.controlpoint.event.Search;
import org.jupnp.model.message.header.MXHeader;
import org.jupnp.model.message.header.STAllHeader;
import org.jupnp.model.message.header.UpnpHeader;
import org.jupnp.protocol.ProtocolFactory;
import org.jupnp.registry.Registry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ControlPointImpl
implements ControlPoint {
    private final Logger logger = LoggerFactory.getLogger(ControlPointImpl.class);
    protected UpnpServiceConfiguration configuration;
    protected ProtocolFactory protocolFactory;
    protected Registry registry;

    protected ControlPointImpl() {
    }

    /*
     * WARNING - void declaration
     */
    public ControlPointImpl(UpnpServiceConfiguration configuration, ProtocolFactory protocolFactory, Registry registry) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logger.trace("Creating ControlPoint: {}", (Object)this.getClass().getName());
        this.configuration = var1_1;
        this.protocolFactory = var2_2;
        this.registry = var3_3;
    }

    @Override
    public UpnpServiceConfiguration getConfiguration() {
        return this.configuration;
    }

    @Override
    public ProtocolFactory getProtocolFactory() {
        return this.protocolFactory;
    }

    @Override
    public Registry getRegistry() {
        return this.registry;
    }

    /*
     * WARNING - void declaration
     */
    public void search(Search search) {
        void var1_1;
        this.search(search.getSearchType(), var1_1.getMxSeconds());
    }

    @Override
    public void search() {
        this.search(new STAllHeader(), MXHeader.DEFAULT_VALUE);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void search(UpnpHeader searchType) {
        void var1_1;
        this.search((UpnpHeader)var1_1, MXHeader.DEFAULT_VALUE);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void search(int mxSeconds) {
        void var1_1;
        this.search(new STAllHeader(), (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void search(UpnpHeader searchType, int mxSeconds) {
        void var2_2;
        void var1_1;
        this.logger.trace("Sending asynchronous search for: {}", (Object)searchType.getString());
        this.getConfiguration().getAsyncProtocolExecutor().execute(this.getProtocolFactory().createSendingSearch((UpnpHeader)var1_1, (int)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    public void execute(ExecuteAction executeAction) {
        void var1_1;
        this.execute(var1_1.getCallback());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Future execute(ActionCallback callback) {
        void var1_1;
        this.logger.trace("Invoking action in background: {}", (Object)callback);
        callback.setControlPoint(this);
        ExecutorService executorService = this.getConfiguration().getSyncProtocolExecutorService();
        return executorService.submit((Runnable)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void execute(SubscriptionCallback callback) {
        void var1_1;
        this.logger.trace("Invoking subscription in background: {}", (Object)callback);
        callback.setControlPoint(this);
        this.getConfiguration().getSyncProtocolExecutorService().execute((Runnable)var1_1);
    }
}

