/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.controlpoint;

import java.net.URL;
import org.jupnp.controlpoint.ControlPoint;
import org.jupnp.model.action.ActionException;
import org.jupnp.model.action.ActionInvocation;
import org.jupnp.model.message.UpnpResponse;
import org.jupnp.model.message.control.IncomingActionResponseMessage;
import org.jupnp.model.meta.LocalService;
import org.jupnp.model.meta.RemoteDevice;
import org.jupnp.model.meta.RemoteService;
import org.jupnp.protocol.sync.SendingAction;

public abstract class ActionCallback
implements Runnable {
    protected final ActionInvocation actionInvocation;
    protected ControlPoint controlPoint;

    /*
     * WARNING - void declaration
     */
    protected ActionCallback(ActionInvocation actionInvocation, ControlPoint controlPoint) {
        void var2_2;
        void var1_1;
        this.actionInvocation = var1_1;
        this.controlPoint = var2_2;
    }

    /*
     * WARNING - void declaration
     */
    protected ActionCallback(ActionInvocation actionInvocation) {
        void var1_1;
        this.actionInvocation = var1_1;
    }

    public ActionInvocation getActionInvocation() {
        return this.actionInvocation;
    }

    public synchronized ControlPoint getControlPoint() {
        return this.controlPoint;
    }

    /*
     * WARNING - void declaration
     */
    public synchronized ActionCallback setControlPoint(ControlPoint controlPoint) {
        void var1_1;
        this.controlPoint = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void run() {
        Object service = this.actionInvocation.getAction().getService();
        if (service instanceof LocalService) {
            service = (LocalService)service;
            ((LocalService)service).getExecutor(this.actionInvocation.getAction()).execute(this.actionInvocation);
            if (this.actionInvocation.getFailure() != null) {
                ActionCallback actionCallback = this;
                actionCallback.failure(actionCallback.actionInvocation, null);
                return;
            }
            ActionCallback actionCallback = this;
            actionCallback.success(actionCallback.actionInvocation);
            return;
        }
        if (service instanceof RemoteService) {
            void var2_2;
            if (this.getControlPoint() == null) {
                throw new IllegalStateException("Callback must be executed through ControlPoint");
            }
            RemoteService remoteService = (RemoteService)service;
            try {
                URL controLURL = ((RemoteDevice)remoteService.getDevice()).normalizeURI(remoteService.getControlURI());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                ActionCallback actionCallback = this;
                actionCallback.failure(actionCallback.actionInvocation, null, "bad control URL: " + String.valueOf(remoteService.getControlURI()));
                return;
            }
            SendingAction prot = this.getControlPoint().getProtocolFactory().createSendingAction(this.actionInvocation, (URL)var2_2);
            prot.run();
            IncomingActionResponseMessage response = (IncomingActionResponseMessage)prot.getOutputMessage();
            if (response == null) {
                ActionCallback actionCallback = this;
                actionCallback.failure(actionCallback.actionInvocation, null);
                return;
            }
            if (((UpnpResponse)response.getOperation()).isFailed()) {
                void var1_1;
                ActionCallback actionCallback = this;
                actionCallback.failure(actionCallback.actionInvocation, (UpnpResponse)var1_1.getOperation());
                return;
            }
            ActionCallback actionCallback = this;
            actionCallback.success(actionCallback.actionInvocation);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected String createDefaultFailureMessage(ActionInvocation invocation, UpnpResponse operation) {
        void var3_3;
        Object message = "Error: ";
        ActionException exception = invocation.getFailure();
        if (exception != null) {
            void var1_1;
            message = (String)message + var1_1.getMessage();
        }
        if (operation != null) {
            void var2_2;
            message = (String)message + " (HTTP response was: " + var2_2.getResponseDetails() + ")";
        }
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    protected void failure(ActionInvocation invocation, UpnpResponse operation) {
        void var2_2;
        void var1_1;
        this.failure(invocation, operation, this.createDefaultFailureMessage((ActionInvocation)var1_1, (UpnpResponse)var2_2));
    }

    public abstract void success(ActionInvocation var1);

    public abstract void failure(ActionInvocation var1, UpnpResponse var2, String var3);

    public String toString() {
        return "(ActionCallback) " + String.valueOf(this.actionInvocation);
    }

    public static final class Default
    extends ActionCallback {
        /*
         * WARNING - void declaration
         */
        public Default(ActionInvocation actionInvocation, ControlPoint controlPoint) {
            super((ActionInvocation)var1_1, (ControlPoint)var2_2);
            void var2_2;
            void var1_1;
        }

        @Override
        public final void success(ActionInvocation invocation) {
        }

        @Override
        public final void failure(ActionInvocation invocation, UpnpResponse operation, String defaultMsg) {
        }
    }
}

