/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.binding.xml;

import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.jupnp.binding.staging.MutableAction;
import org.jupnp.binding.staging.MutableActionArgument;
import org.jupnp.binding.staging.MutableAllowedValueRange;
import org.jupnp.binding.staging.MutableService;
import org.jupnp.binding.staging.MutableStateVariable;
import org.jupnp.binding.xml.Descriptor;
import org.jupnp.binding.xml.DescriptorBindingException;
import org.jupnp.binding.xml.ServiceDescriptorBinder;
import org.jupnp.binding.xml.UDA10ServiceDescriptorBinderImpl;
import org.jupnp.model.ValidationException;
import org.jupnp.model.meta.ActionArgument;
import org.jupnp.model.meta.Device;
import org.jupnp.model.meta.Service;
import org.jupnp.model.meta.StateVariableEventDetails;
import org.jupnp.model.types.CustomDatatype;
import org.jupnp.model.types.Datatype;
import org.jupnp.util.SpecificationViolationReporter;
import org.jupnp.xml.SAXParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class UDA10ServiceDescriptorBinderSAXImpl
extends UDA10ServiceDescriptorBinderImpl {
    private final Logger logger = LoggerFactory.getLogger(ServiceDescriptorBinder.class);

    /*
     * WARNING - void declaration
     */
    @Override
    public <S extends Service> S describe(S undescribedService, String descriptorXml) throws DescriptorBindingException, ValidationException {
        if (descriptorXml == null || descriptorXml.isEmpty()) {
            throw new DescriptorBindingException("Null or empty descriptor");
        }
        try {
            void var1_1;
            void var2_2;
            this.logger.trace("Reading service from XML descriptor");
            SAXParser parser = new SAXParser();
            MutableService descriptor = new MutableService();
            this.hydrateBasic(descriptor, undescribedService);
            new RootHandler(descriptor, parser);
            parser.parse(new InputSource(new StringReader(var2_2.trim())));
            return (S)descriptor.build((Device)var1_1.getDevice());
        }
        catch (ValidationException validationException) {
            ValidationException parser = validationException;
            throw validationException;
        }
        catch (Exception e) {
            void var3_5;
            throw new DescriptorBindingException("Could not parse service descriptor", (Throwable)var3_5);
        }
    }

    protected static class ActionArgumentHandler
    extends ServiceDescriptorHandler<MutableActionArgument> {
        public static final Descriptor.Service.ELEMENT EL = Descriptor.Service.ELEMENT.argument;

        /*
         * WARNING - void declaration
         */
        public ActionArgumentHandler(MutableActionArgument instance, ServiceDescriptorHandler parent) {
            super(var1_1, (ServiceDescriptorHandler)var2_2);
            void var2_2;
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void endElement(Descriptor.Service.ELEMENT element) throws SAXException {
            switch (element) {
                case name: {
                    ((MutableActionArgument)this.getInstance()).name = this.getCharacters();
                    return;
                }
                case direction: {
                    String directionString = this.getCharacters();
                    try {
                        ((MutableActionArgument)this.getInstance()).direction = ActionArgument.Direction.valueOf(directionString.toUpperCase(Locale.ENGLISH));
                        return;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        void var1_1;
                        SpecificationViolationReporter.report("Invalid action argument direction, assuming 'IN': {}", var1_1);
                        ((MutableActionArgument)this.getInstance()).direction = ActionArgument.Direction.IN;
                        return;
                    }
                }
                case relatedStateVariable: {
                    ((MutableActionArgument)this.getInstance()).relatedStateVariable = this.getCharacters();
                    return;
                }
                case retval: {
                    ((MutableActionArgument)this.getInstance()).retval = true;
                }
            }
        }

        @Override
        public boolean isLastElement(Descriptor.Service.ELEMENT element) {
            return element.equals((Object)EL);
        }
    }

    protected static class ActionArgumentListHandler
    extends ServiceDescriptorHandler<List<MutableActionArgument>> {
        public static final Descriptor.Service.ELEMENT EL = Descriptor.Service.ELEMENT.argumentList;

        /*
         * WARNING - void declaration
         */
        public ActionArgumentListHandler(List<MutableActionArgument> instance, ServiceDescriptorHandler parent) {
            super(var1_1, (ServiceDescriptorHandler)var2_2);
            void var2_2;
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void startElement(Descriptor.Service.ELEMENT element, Attributes attributes) throws SAXException {
            if (element.equals((Object)ActionArgumentHandler.EL)) {
                void var1_1;
                MutableActionArgument argument = new MutableActionArgument();
                ((List)this.getInstance()).add(argument);
                new ActionArgumentHandler((MutableActionArgument)var1_1, (ServiceDescriptorHandler)this);
            }
        }

        @Override
        public boolean isLastElement(Descriptor.Service.ELEMENT element) {
            return element.equals((Object)EL);
        }
    }

    protected static class ActionHandler
    extends ServiceDescriptorHandler<MutableAction> {
        public static final Descriptor.Service.ELEMENT EL = Descriptor.Service.ELEMENT.action;
        private static volatile /* synthetic */ int[] $SWITCH_TABLE$org$jupnp$binding$xml$Descriptor$Service$ELEMENT;

        /*
         * WARNING - void declaration
         */
        public ActionHandler(MutableAction instance, ServiceDescriptorHandler parent) {
            super(var1_1, (ServiceDescriptorHandler)var2_2);
            void var2_2;
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void startElement(Descriptor.Service.ELEMENT element, Attributes attributes) throws SAXException {
            if (element.equals((Object)ActionArgumentListHandler.EL)) {
                void var1_1;
                ArrayList<MutableActionArgument> arguments = new ArrayList<MutableActionArgument>();
                ((MutableAction)this.getInstance()).arguments = arguments;
                new ActionArgumentListHandler((List<MutableActionArgument>)var1_1, (ServiceDescriptorHandler)this);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void endElement(Descriptor.Service.ELEMENT element) throws SAXException {
            void var1_1;
            switch (ActionHandler.$SWITCH_TABLE$org$jupnp$binding$xml$Descriptor$Service$ELEMENT()[var1_1.ordinal()]) {
                case 7: {
                    ((MutableAction)this.getInstance()).name = this.getCharacters();
                }
            }
        }

        @Override
        public boolean isLastElement(Descriptor.Service.ELEMENT element) {
            return element.equals((Object)EL);
        }

        static /* synthetic */ int[] $SWITCH_TABLE$org$jupnp$binding$xml$Descriptor$Service$ELEMENT() {
            if ($SWITCH_TABLE$org$jupnp$binding$xml$Descriptor$Service$ELEMENT != null) {
                return $SWITCH_TABLE$org$jupnp$binding$xml$Descriptor$Service$ELEMENT;
            }
            int[] nArray = new int[Descriptor.Service.ELEMENT.values().length];
            try {
                nArray[Descriptor.Service.ELEMENT.action.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[Descriptor.Service.ELEMENT.actionList.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[Descriptor.Service.ELEMENT.allowedValue.ordinal()] = 18;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[Descriptor.Service.ELEMENT.allowedValueList.ordinal()] = 17;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[Descriptor.Service.ELEMENT.allowedValueRange.ordinal()] = 19;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[Descriptor.Service.ELEMENT.argument.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[Descriptor.Service.ELEMENT.argumentList.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[Descriptor.Service.ELEMENT.dataType.ordinal()] = 15;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[Descriptor.Service.ELEMENT.defaultValue.ordinal()] = 16;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[Descriptor.Service.ELEMENT.direction.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[Descriptor.Service.ELEMENT.major.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[Descriptor.Service.ELEMENT.maximum.ordinal()] = 21;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[Descriptor.Service.ELEMENT.minimum.ordinal()] = 20;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[Descriptor.Service.ELEMENT.minor.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[Descriptor.Service.ELEMENT.name.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[Descriptor.Service.ELEMENT.relatedStateVariable.ordinal()] = 11;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[Descriptor.Service.ELEMENT.retval.ordinal()] = 12;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[Descriptor.Service.ELEMENT.scpd.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[Descriptor.Service.ELEMENT.serviceStateTable.ordinal()] = 13;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[Descriptor.Service.ELEMENT.specVersion.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[Descriptor.Service.ELEMENT.stateVariable.ordinal()] = 14;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[Descriptor.Service.ELEMENT.step.ordinal()] = 22;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            $SWITCH_TABLE$org$jupnp$binding$xml$Descriptor$Service$ELEMENT = nArray;
            return nArray;
        }
    }

    protected static class ActionListHandler
    extends ServiceDescriptorHandler<List<MutableAction>> {
        public static final Descriptor.Service.ELEMENT EL = Descriptor.Service.ELEMENT.actionList;

        /*
         * WARNING - void declaration
         */
        public ActionListHandler(List<MutableAction> instance, ServiceDescriptorHandler parent) {
            super(var1_1, (ServiceDescriptorHandler)var2_2);
            void var2_2;
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void startElement(Descriptor.Service.ELEMENT element, Attributes attributes) throws SAXException {
            if (element.equals((Object)ActionHandler.EL)) {
                void var1_1;
                MutableAction action = new MutableAction();
                ((List)this.getInstance()).add(action);
                new ActionHandler((MutableAction)var1_1, (ServiceDescriptorHandler)this);
            }
        }

        @Override
        public boolean isLastElement(Descriptor.Service.ELEMENT element) {
            return element.equals((Object)EL);
        }
    }

    protected static class AllowedValueListHandler
    extends ServiceDescriptorHandler<List<String>> {
        public static final Descriptor.Service.ELEMENT EL = Descriptor.Service.ELEMENT.allowedValueList;
        private static volatile /* synthetic */ int[] $SWITCH_TABLE$org$jupnp$binding$xml$Descriptor$Service$ELEMENT;

        /*
         * WARNING - void declaration
         */
        public AllowedValueListHandler(List<String> instance, ServiceDescriptorHandler parent) {
            super(var1_1, (ServiceDescriptorHandler)var2_2);
            void var2_2;
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void endElement(Descriptor.Service.ELEMENT element) throws SAXException {
            void var1_1;
            switch (AllowedValueListHandler.$SWITCH_TABLE$org$jupnp$binding$xml$Descriptor$Service$ELEMENT()[var1_1.ordinal()]) {
                case 18: {
                    ((List)this.getInstance()).add(this.getCharacters());
                }
            }
        }

        @Override
        public boolean isLastElement(Descriptor.Service.ELEMENT element) {
            return element.equals((Object)EL);
        }

        static /* synthetic */ int[] $SWITCH_TABLE$org$jupnp$binding$xml$Descriptor$Service$ELEMENT() {
            if ($SWITCH_TABLE$org$jupnp$binding$xml$Descriptor$Service$ELEMENT != null) {
                return $SWITCH_TABLE$org$jupnp$binding$xml$Descriptor$Service$ELEMENT;
            }
            int[] nArray = new int[Descriptor.Service.ELEMENT.values().length];
            try {
                nArray[Descriptor.Service.ELEMENT.action.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[Descriptor.Service.ELEMENT.actionList.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[Descriptor.Service.ELEMENT.allowedValue.ordinal()] = 18;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[Descriptor.Service.ELEMENT.allowedValueList.ordinal()] = 17;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[Descriptor.Service.ELEMENT.allowedValueRange.ordinal()] = 19;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[Descriptor.Service.ELEMENT.argument.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[Descriptor.Service.ELEMENT.argumentList.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[Descriptor.Service.ELEMENT.dataType.ordinal()] = 15;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[Descriptor.Service.ELEMENT.defaultValue.ordinal()] = 16;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[Descriptor.Service.ELEMENT.direction.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[Descriptor.Service.ELEMENT.major.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[Descriptor.Service.ELEMENT.maximum.ordinal()] = 21;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[Descriptor.Service.ELEMENT.minimum.ordinal()] = 20;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[Descriptor.Service.ELEMENT.minor.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[Descriptor.Service.ELEMENT.name.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[Descriptor.Service.ELEMENT.relatedStateVariable.ordinal()] = 11;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[Descriptor.Service.ELEMENT.retval.ordinal()] = 12;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[Descriptor.Service.ELEMENT.scpd.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[Descriptor.Service.ELEMENT.serviceStateTable.ordinal()] = 13;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[Descriptor.Service.ELEMENT.specVersion.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[Descriptor.Service.ELEMENT.stateVariable.ordinal()] = 14;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[Descriptor.Service.ELEMENT.step.ordinal()] = 22;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            $SWITCH_TABLE$org$jupnp$binding$xml$Descriptor$Service$ELEMENT = nArray;
            return nArray;
        }
    }

    protected static class AllowedValueRangeHandler
    extends ServiceDescriptorHandler<MutableAllowedValueRange> {
        public static final Descriptor.Service.ELEMENT EL = Descriptor.Service.ELEMENT.allowedValueRange;
        private static volatile /* synthetic */ int[] $SWITCH_TABLE$org$jupnp$binding$xml$Descriptor$Service$ELEMENT;

        /*
         * WARNING - void declaration
         */
        public AllowedValueRangeHandler(MutableAllowedValueRange instance, ServiceDescriptorHandler parent) {
            super(var1_1, (ServiceDescriptorHandler)var2_2);
            void var2_2;
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void endElement(Descriptor.Service.ELEMENT element) throws SAXException {
            try {
                void var1_1;
                switch (AllowedValueRangeHandler.$SWITCH_TABLE$org$jupnp$binding$xml$Descriptor$Service$ELEMENT()[var1_1.ordinal()]) {
                    case 20: {
                        ((MutableAllowedValueRange)this.getInstance()).minimum = Long.valueOf(this.getCharacters());
                        return;
                    }
                    case 21: {
                        ((MutableAllowedValueRange)this.getInstance()).maximum = Long.valueOf(this.getCharacters());
                        return;
                    }
                    case 22: {
                        ((MutableAllowedValueRange)this.getInstance()).step = Long.valueOf(this.getCharacters());
                    }
                }
                return;
            }
            catch (Exception exception) {
                return;
            }
        }

        @Override
        public boolean isLastElement(Descriptor.Service.ELEMENT element) {
            return element.equals((Object)EL);
        }

        static /* synthetic */ int[] $SWITCH_TABLE$org$jupnp$binding$xml$Descriptor$Service$ELEMENT() {
            if ($SWITCH_TABLE$org$jupnp$binding$xml$Descriptor$Service$ELEMENT != null) {
                return $SWITCH_TABLE$org$jupnp$binding$xml$Descriptor$Service$ELEMENT;
            }
            int[] nArray = new int[Descriptor.Service.ELEMENT.values().length];
            try {
                nArray[Descriptor.Service.ELEMENT.action.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[Descriptor.Service.ELEMENT.actionList.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[Descriptor.Service.ELEMENT.allowedValue.ordinal()] = 18;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[Descriptor.Service.ELEMENT.allowedValueList.ordinal()] = 17;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[Descriptor.Service.ELEMENT.allowedValueRange.ordinal()] = 19;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[Descriptor.Service.ELEMENT.argument.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[Descriptor.Service.ELEMENT.argumentList.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[Descriptor.Service.ELEMENT.dataType.ordinal()] = 15;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[Descriptor.Service.ELEMENT.defaultValue.ordinal()] = 16;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[Descriptor.Service.ELEMENT.direction.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[Descriptor.Service.ELEMENT.major.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[Descriptor.Service.ELEMENT.maximum.ordinal()] = 21;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[Descriptor.Service.ELEMENT.minimum.ordinal()] = 20;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[Descriptor.Service.ELEMENT.minor.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[Descriptor.Service.ELEMENT.name.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[Descriptor.Service.ELEMENT.relatedStateVariable.ordinal()] = 11;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[Descriptor.Service.ELEMENT.retval.ordinal()] = 12;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[Descriptor.Service.ELEMENT.scpd.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[Descriptor.Service.ELEMENT.serviceStateTable.ordinal()] = 13;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[Descriptor.Service.ELEMENT.specVersion.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[Descriptor.Service.ELEMENT.stateVariable.ordinal()] = 14;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[Descriptor.Service.ELEMENT.step.ordinal()] = 22;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            $SWITCH_TABLE$org$jupnp$binding$xml$Descriptor$Service$ELEMENT = nArray;
            return nArray;
        }
    }

    protected static class RootHandler
    extends ServiceDescriptorHandler<MutableService> {
        /*
         * WARNING - void declaration
         */
        public RootHandler(MutableService instance, SAXParser parser) {
            super(var1_1, (SAXParser)var2_2);
            void var2_2;
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void startElement(Descriptor.Service.ELEMENT element, Attributes attributes) throws SAXException {
            void var1_1;
            if (element.equals((Object)ActionListHandler.EL)) {
                ArrayList<MutableAction> actions = new ArrayList<MutableAction>();
                ((MutableService)this.getInstance()).actions = actions;
                new ActionListHandler((List<MutableAction>)actions, (ServiceDescriptorHandler)this);
            }
            if (var1_1.equals((Object)StateVariableListHandler.EL)) {
                void var2_2;
                ArrayList<MutableStateVariable> stateVariables = new ArrayList<MutableStateVariable>();
                ((MutableService)this.getInstance()).stateVariables = stateVariables;
                new StateVariableListHandler((List<MutableStateVariable>)var2_2, (ServiceDescriptorHandler)this);
            }
        }
    }

    protected static class ServiceDescriptorHandler<I>
    extends SAXParser.Handler<I> {
        /*
         * WARNING - void declaration
         */
        public ServiceDescriptorHandler(I instance) {
            super(var1_1);
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public ServiceDescriptorHandler(I instance, SAXParser parser) {
            super(var1_1, (SAXParser)var2_2);
            void var2_2;
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public ServiceDescriptorHandler(I instance, ServiceDescriptorHandler parent) {
            super(var1_1, (SAXParser.Handler)var2_2);
            void var2_2;
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public ServiceDescriptorHandler(I instance, SAXParser parser, ServiceDescriptorHandler parent) {
            super(var1_1, (SAXParser)var2_2, (SAXParser.Handler)var3_3);
            void var3_3;
            void var2_2;
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            void var1_1;
            void var2_2;
            void var3_3;
            super.startElement(uri, localName, (String)var3_3, attributes);
            Descriptor.Service.ELEMENT el = Descriptor.Service.ELEMENT.valueOrNullOf((String)var2_2);
            if (el == null) {
                return;
            }
            this.startElement((Descriptor.Service.ELEMENT)var1_1, attributes);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            void var1_1;
            void var2_2;
            void var3_3;
            super.endElement(uri, localName, (String)var3_3);
            Descriptor.Service.ELEMENT el = Descriptor.Service.ELEMENT.valueOrNullOf((String)var2_2);
            if (el == null) {
                return;
            }
            this.endElement((Descriptor.Service.ELEMENT)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected boolean isLastElement(String uri, String localName, String qName) {
            void var1_1;
            Descriptor.Service.ELEMENT el = Descriptor.Service.ELEMENT.valueOrNullOf(localName);
            return el != null && this.isLastElement((Descriptor.Service.ELEMENT)var1_1);
        }

        public void startElement(Descriptor.Service.ELEMENT element, Attributes attributes) throws SAXException {
        }

        public void endElement(Descriptor.Service.ELEMENT element) throws SAXException {
        }

        public boolean isLastElement(Descriptor.Service.ELEMENT element) {
            return false;
        }
    }

    protected static class StateVariableHandler
    extends ServiceDescriptorHandler<MutableStateVariable> {
        public static final Descriptor.Service.ELEMENT EL = Descriptor.Service.ELEMENT.stateVariable;

        /*
         * WARNING - void declaration
         */
        public StateVariableHandler(MutableStateVariable instance, ServiceDescriptorHandler parent) {
            super(var1_1, (ServiceDescriptorHandler)var2_2);
            void var2_2;
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void startElement(Descriptor.Service.ELEMENT element, Attributes attributes) throws SAXException {
            void var1_1;
            if (element.equals((Object)AllowedValueListHandler.EL)) {
                ArrayList<String> allowedValues = new ArrayList<String>();
                ((MutableStateVariable)this.getInstance()).allowedValues = allowedValues;
                new AllowedValueListHandler((List<String>)allowedValues, (ServiceDescriptorHandler)this);
            }
            if (var1_1.equals((Object)AllowedValueRangeHandler.EL)) {
                void var2_2;
                MutableAllowedValueRange allowedValueRange;
                ((MutableStateVariable)this.getInstance()).allowedValueRange = allowedValueRange = new MutableAllowedValueRange();
                new AllowedValueRangeHandler((MutableAllowedValueRange)var2_2, (ServiceDescriptorHandler)this);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void endElement(Descriptor.Service.ELEMENT element) throws SAXException {
            switch (element) {
                case name: {
                    ((MutableStateVariable)this.getInstance()).name = this.getCharacters();
                    return;
                }
                case dataType: {
                    void var1_1;
                    void var2_2;
                    String dtName = this.getCharacters();
                    Datatype.Builtin builtin = Datatype.Builtin.getByDescriptorName(dtName);
                    ((MutableStateVariable)this.getInstance()).dataType = builtin != null ? var2_2.getDatatype() : new CustomDatatype((String)var1_1);
                    return;
                }
                case defaultValue: {
                    ((MutableStateVariable)this.getInstance()).defaultValue = this.getCharacters();
                }
            }
        }

        @Override
        public boolean isLastElement(Descriptor.Service.ELEMENT element) {
            return element.equals((Object)EL);
        }
    }

    protected static class StateVariableListHandler
    extends ServiceDescriptorHandler<List<MutableStateVariable>> {
        public static final Descriptor.Service.ELEMENT EL = Descriptor.Service.ELEMENT.serviceStateTable;

        /*
         * WARNING - void declaration
         */
        public StateVariableListHandler(List<MutableStateVariable> instance, ServiceDescriptorHandler parent) {
            super(var1_1, (ServiceDescriptorHandler)var2_2);
            void var2_2;
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void startElement(Descriptor.Service.ELEMENT element, Attributes attributes) throws SAXException {
            if (element.equals((Object)StateVariableHandler.EL)) {
                void var1_1;
                void var2_2;
                MutableStateVariable stateVariable = new MutableStateVariable();
                String sendEventsAttributeValue = attributes.getValue(Descriptor.Service.ATTRIBUTE.sendEvents.toString());
                stateVariable.eventDetails = new StateVariableEventDetails(sendEventsAttributeValue != null && var2_2.toUpperCase(Locale.ENGLISH).equals("YES"));
                ((List)this.getInstance()).add(stateVariable);
                new StateVariableHandler((MutableStateVariable)var1_1, (ServiceDescriptorHandler)this);
            }
        }

        @Override
        public boolean isLastElement(Descriptor.Service.ELEMENT element) {
            return element.equals((Object)EL);
        }
    }
}

