/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.binding.xml;

import java.io.StringReader;
import java.util.ArrayList;
import java.util.Locale;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.jupnp.binding.staging.MutableAction;
import org.jupnp.binding.staging.MutableActionArgument;
import org.jupnp.binding.staging.MutableAllowedValueRange;
import org.jupnp.binding.staging.MutableService;
import org.jupnp.binding.staging.MutableStateVariable;
import org.jupnp.binding.xml.Descriptor;
import org.jupnp.binding.xml.DescriptorBindingException;
import org.jupnp.binding.xml.ServiceDescriptorBinder;
import org.jupnp.model.ValidationException;
import org.jupnp.model.XMLUtil;
import org.jupnp.model.meta.Action;
import org.jupnp.model.meta.ActionArgument;
import org.jupnp.model.meta.Device;
import org.jupnp.model.meta.RemoteService;
import org.jupnp.model.meta.Service;
import org.jupnp.model.meta.StateVariable;
import org.jupnp.model.meta.StateVariableEventDetails;
import org.jupnp.model.types.CustomDatatype;
import org.jupnp.model.types.Datatype;
import org.jupnp.util.SpecificationViolationReporter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class UDA10ServiceDescriptorBinderImpl
implements ServiceDescriptorBinder,
ErrorHandler {
    private final Logger logger = LoggerFactory.getLogger(ServiceDescriptorBinder.class);

    /*
     * WARNING - void declaration
     */
    public <S extends Service> S describe(S undescribedService, String descriptorXml) throws DescriptorBindingException, ValidationException {
        if (descriptorXml == null || descriptorXml.isEmpty()) {
            throw new DescriptorBindingException("Null or empty descriptor");
        }
        try {
            void var2_2;
            void var1_1;
            this.logger.trace("Populating service from XML descriptor: {}", undescribedService);
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            DocumentBuilder documentBuilder = factory.newDocumentBuilder();
            documentBuilder.setErrorHandler(this);
            Document d = documentBuilder.parse(new InputSource(new StringReader(descriptorXml.trim())));
            return this.describe(var1_1, (Document)var2_2);
        }
        catch (ValidationException validationException) {
            ValidationException documentBuilder = validationException;
            throw validationException;
        }
        catch (Exception e) {
            void var3_5;
            throw new DescriptorBindingException("Could not parse service descriptor", (Throwable)var3_5);
        }
    }

    /*
     * WARNING - void declaration
     */
    public <S extends Service> S describe(S undescribedService, Document dom) throws DescriptorBindingException, ValidationException {
        try {
            void var1_1;
            void var2_2;
            this.logger.trace("Populating service from DOM: {}", undescribedService);
            MutableService descriptor = new MutableService();
            this.hydrateBasic(descriptor, undescribedService);
            Element rootElement = dom.getDocumentElement();
            this.hydrateRoot(descriptor, (Element)var2_2);
            return this.buildInstance(var1_1, descriptor);
        }
        catch (ValidationException validationException) {
            ValidationException descriptor = validationException;
            throw validationException;
        }
        catch (Exception e) {
            void var3_5;
            throw new DescriptorBindingException("Could not parse service DOM", (Throwable)var3_5);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected <S extends Service> S buildInstance(S undescribedService, MutableService descriptor) throws ValidationException {
        void var1_1;
        return (S)descriptor.build((Device)var1_1.getDevice());
    }

    /*
     * WARNING - void declaration
     */
    protected void hydrateBasic(MutableService descriptor, Service undescribedService) {
        descriptor.serviceId = undescribedService.getServiceId();
        descriptor.serviceType = undescribedService.getServiceType();
        if (undescribedService instanceof RemoteService) {
            void var2_2;
            RemoteService rs = (RemoteService)undescribedService;
            descriptor.controlURI = rs.getControlURI();
            descriptor.eventSubscriptionURI = rs.getEventSubscriptionURI();
            var1_1.descriptorURI = var2_2.getDescriptorURI();
        }
    }

    protected void hydrateRoot(MutableService descriptor, Element rootElement) throws DescriptorBindingException {
        if (!Descriptor.Service.ELEMENT.scpd.equals(rootElement)) {
            throw new DescriptorBindingException("Root element name is not <scpd>: " + rootElement.getNodeName());
        }
        NodeList rootChildren = rootElement.getChildNodes();
        int i = 0;
        while (i < rootChildren.getLength()) {
            Node rootChild = rootChildren.item(i);
            if (rootChild.getNodeType() == 1) {
                if (Descriptor.Service.ELEMENT.specVersion.equals(rootChild)) {
                    this.logger.trace("Ignoring UDA major/minor specVersion");
                } else if (Descriptor.Service.ELEMENT.actionList.equals(rootChild)) {
                    this.hydrateActionList(descriptor, rootChild);
                } else if (Descriptor.Service.ELEMENT.serviceStateTable.equals(rootChild)) {
                    this.hydrateServiceStateTableList(descriptor, rootChild);
                } else {
                    this.logger.trace("Ignoring unknown element: {}", (Object)rootChild.getNodeName());
                }
            }
            ++i;
        }
    }

    public void hydrateActionList(MutableService descriptor, Node actionListNode) throws DescriptorBindingException {
        NodeList actionListChildren = actionListNode.getChildNodes();
        int i = 0;
        while (i < actionListChildren.getLength()) {
            Node actionListChild = actionListChildren.item(i);
            if (actionListChild.getNodeType() == 1 && Descriptor.Service.ELEMENT.action.equals(actionListChild)) {
                MutableAction action = new MutableAction();
                this.hydrateAction(action, actionListChild);
                descriptor.actions.add(action);
            }
            ++i;
        }
    }

    public void hydrateAction(MutableAction action, Node actionNode) {
        NodeList actionNodeChildren = actionNode.getChildNodes();
        int i = 0;
        while (i < actionNodeChildren.getLength()) {
            Node actionNodeChild = actionNodeChildren.item(i);
            if (actionNodeChild.getNodeType() == 1) {
                if (Descriptor.Service.ELEMENT.name.equals(actionNodeChild)) {
                    action.name = XMLUtil.getTextContent(actionNodeChild);
                } else if (Descriptor.Service.ELEMENT.argumentList.equals(actionNodeChild)) {
                    NodeList argumentChildren = actionNodeChild.getChildNodes();
                    int j = 0;
                    while (j < argumentChildren.getLength()) {
                        Node argumentChild = argumentChildren.item(j);
                        if (argumentChild.getNodeType() == 1) {
                            MutableActionArgument actionArgument = new MutableActionArgument();
                            this.hydrateActionArgument(actionArgument, argumentChild);
                            action.arguments.add(actionArgument);
                        }
                        ++j;
                    }
                }
            }
            ++i;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void hydrateActionArgument(MutableActionArgument actionArgument, Node actionArgumentNode) {
        NodeList argumentNodeChildren = actionArgumentNode.getChildNodes();
        int i = 0;
        while (i < argumentNodeChildren.getLength()) {
            Node argumentNodeChild = argumentNodeChildren.item(i);
            if (argumentNodeChild.getNodeType() == 1) {
                void var4_4;
                if (Descriptor.Service.ELEMENT.name.equals(argumentNodeChild)) {
                    actionArgument.name = XMLUtil.getTextContent(argumentNodeChild);
                } else if (Descriptor.Service.ELEMENT.direction.equals(argumentNodeChild)) {
                    String directionString = XMLUtil.getTextContent(argumentNodeChild);
                    try {
                        actionArgument.direction = ActionArgument.Direction.valueOf(directionString.toUpperCase(Locale.ENGLISH));
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        SpecificationViolationReporter.report("Invalid action argument direction, assuming 'IN': {}", directionString);
                        actionArgument.direction = ActionArgument.Direction.IN;
                    }
                } else if (Descriptor.Service.ELEMENT.relatedStateVariable.equals((Node)var4_4)) {
                    actionArgument.relatedStateVariable = XMLUtil.getTextContent((Node)var4_4);
                } else if (Descriptor.Service.ELEMENT.retval.equals((Node)var4_4)) {
                    actionArgument.retval = true;
                }
            }
            ++i;
        }
    }

    public void hydrateServiceStateTableList(MutableService descriptor, Node serviceStateTableNode) {
        NodeList serviceStateTableChildren = serviceStateTableNode.getChildNodes();
        int i = 0;
        while (i < serviceStateTableChildren.getLength()) {
            Node serviceStateTableChild = serviceStateTableChildren.item(i);
            if (serviceStateTableChild.getNodeType() == 1 && Descriptor.Service.ELEMENT.stateVariable.equals(serviceStateTableChild)) {
                MutableStateVariable stateVariable = new MutableStateVariable();
                this.hydrateStateVariable(stateVariable, (Element)serviceStateTableChild);
                descriptor.stateVariables.add(stateVariable);
            }
            ++i;
        }
    }

    public void hydrateStateVariable(MutableStateVariable stateVariable, Element stateVariableElement) {
        stateVariable.eventDetails = new StateVariableEventDetails(stateVariableElement.getAttribute("sendEvents") != null && stateVariableElement.getAttribute(Descriptor.Service.ATTRIBUTE.sendEvents.toString()).toUpperCase(Locale.ENGLISH).equals("YES"));
        NodeList stateVariableChildren = stateVariableElement.getChildNodes();
        int i = 0;
        while (i < stateVariableChildren.getLength()) {
            Node stateVariableChild = stateVariableChildren.item(i);
            if (stateVariableChild.getNodeType() == 1) {
                int j;
                NodeList allowedValueListChildren;
                Datatype.Builtin builtin;
                if (Descriptor.Service.ELEMENT.name.equals(stateVariableChild)) {
                    stateVariable.name = XMLUtil.getTextContent(stateVariableChild);
                } else if (Descriptor.Service.ELEMENT.dataType.equals(stateVariableChild)) {
                    String dtName = XMLUtil.getTextContent(stateVariableChild);
                    builtin = Datatype.Builtin.getByDescriptorName(dtName);
                    stateVariable.dataType = builtin != null ? builtin.getDatatype() : new CustomDatatype(dtName);
                } else if (Descriptor.Service.ELEMENT.defaultValue.equals((Node)((Object)builtin))) {
                    stateVariable.defaultValue = XMLUtil.getTextContent((Node)((Object)builtin));
                } else if (Descriptor.Service.ELEMENT.allowedValueList.equals((Node)((Object)builtin))) {
                    ArrayList<String> allowedValues = new ArrayList<String>();
                    allowedValueListChildren = builtin.getChildNodes();
                    j = 0;
                    while (j < allowedValueListChildren.getLength()) {
                        Node allowedValueListChild = allowedValueListChildren.item(j);
                        if (allowedValueListChild.getNodeType() == 1 && Descriptor.Service.ELEMENT.allowedValue.equals(allowedValueListChild)) {
                            allowedValues.add(XMLUtil.getTextContent(allowedValueListChild));
                        }
                        ++j;
                    }
                    stateVariable.allowedValues = allowedValues;
                } else if (Descriptor.Service.ELEMENT.allowedValueRange.equals((Node)((Object)allowedValueListChildren))) {
                    MutableAllowedValueRange range = new MutableAllowedValueRange();
                    NodeList allowedValueRangeChildren = allowedValueListChildren.getChildNodes();
                    j = 0;
                    while (j < allowedValueRangeChildren.getLength()) {
                        Node allowedValueRangeChild = allowedValueRangeChildren.item(j);
                        if (allowedValueRangeChild.getNodeType() == 1) {
                            if (Descriptor.Service.ELEMENT.minimum.equals(allowedValueRangeChild)) {
                                try {
                                    range.minimum = Long.valueOf(XMLUtil.getTextContent(allowedValueRangeChild));
                                }
                                catch (Exception exception) {}
                            } else if (Descriptor.Service.ELEMENT.maximum.equals(allowedValueRangeChild)) {
                                try {
                                    range.maximum = Long.valueOf(XMLUtil.getTextContent(allowedValueRangeChild));
                                }
                                catch (Exception exception) {}
                            } else if (Descriptor.Service.ELEMENT.step.equals(allowedValueRangeChild)) {
                                try {
                                    range.step = Long.valueOf(XMLUtil.getTextContent(allowedValueRangeChild));
                                }
                                catch (Exception exception) {}
                            }
                        }
                        ++j;
                    }
                    stateVariable.allowedValueRange = range;
                }
            }
            ++i;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String generate(Service service) throws DescriptorBindingException {
        try {
            this.logger.trace("Generating XML descriptor from service model: {}", (Object)service);
            return XMLUtil.documentToString(this.buildDOM(service));
        }
        catch (Exception e) {
            void var1_2;
            throw new DescriptorBindingException("Could not build DOM: " + e.getMessage(), (Throwable)var1_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Document buildDOM(Service service) throws DescriptorBindingException {
        try {
            void var1_1;
            this.logger.trace("Generting XML descriptor from service model: {}", (Object)service);
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            Document d = factory.newDocumentBuilder().newDocument();
            this.generateScpd((Service)var1_1, d);
            return d;
        }
        catch (Exception e) {
            void var2_3;
            throw new DescriptorBindingException("Could not generate service descriptor: " + e.getMessage(), (Throwable)var2_3);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void generateScpd(Service serviceModel, Document descriptor) {
        void var3_3;
        void var2_2;
        void var1_1;
        Element scpdElement = descriptor.createElementNS("urn:schemas-upnp-org:service-1-0", Descriptor.Service.ELEMENT.scpd.toString());
        descriptor.appendChild(scpdElement);
        this.generateSpecVersion(serviceModel, descriptor, scpdElement);
        if (serviceModel.hasActions()) {
            this.generateActionList(serviceModel, descriptor, scpdElement);
        }
        this.generateServiceStateTable((Service)var1_1, (Document)var2_2, (Element)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    private void generateSpecVersion(Service serviceModel, Document descriptor, Element rootElement) {
        void var1_1;
        void var3_3;
        void var2_2;
        Element specVersionElement = XMLUtil.appendNewElement(descriptor, rootElement, Descriptor.Service.ELEMENT.specVersion);
        XMLUtil.appendNewElementIfNotNull(descriptor, specVersionElement, Descriptor.Service.ELEMENT.major, (Object)((Device)serviceModel.getDevice()).getVersion().getMajor());
        XMLUtil.appendNewElementIfNotNull((Document)var2_2, (Element)var3_3, Descriptor.Service.ELEMENT.minor, (Object)((Device)var1_1.getDevice()).getVersion().getMinor());
    }

    /*
     * WARNING - void declaration
     */
    private void generateActionList(Service serviceModel, Document descriptor, Element scpdElement) {
        Element actionListElement = XMLUtil.appendNewElement(descriptor, scpdElement, Descriptor.Service.ELEMENT.actionList);
        Action<S>[] actionArray = serviceModel.getActions();
        int n = actionArray.length;
        int n2 = 0;
        while (n2 < n) {
            Action action = actionArray[n2];
            if (!action.getName().equals("QueryStateVariable")) {
                void var1_1;
                this.generateAction((Action)var1_1, descriptor, actionListElement);
            }
            ++n2;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void generateAction(Action action, Document descriptor, Element actionListElement) {
        Element actionElement = XMLUtil.appendNewElement(descriptor, actionListElement, Descriptor.Service.ELEMENT.action);
        XMLUtil.appendNewElementIfNotNull(descriptor, actionElement, Descriptor.Service.ELEMENT.name, (Object)action.getName());
        if (action.hasArguments()) {
            Element argumentListElement = XMLUtil.appendNewElement(descriptor, actionElement, Descriptor.Service.ELEMENT.argumentList);
            ActionArgument[] actionArgumentArray = action.getArguments();
            int n = actionArgumentArray.length;
            int n2 = 0;
            while (n2 < n) {
                void var1_1;
                ActionArgument actionArgument = actionArgumentArray[n2];
                this.generateActionArgument((ActionArgument)var1_1, descriptor, argumentListElement);
                ++n2;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void generateActionArgument(ActionArgument actionArgument, Document descriptor, Element actionElement) {
        void var1_1;
        void var3_3;
        void var2_2;
        Element actionArgumentElement = XMLUtil.appendNewElement(descriptor, actionElement, Descriptor.Service.ELEMENT.argument);
        XMLUtil.appendNewElementIfNotNull(descriptor, actionArgumentElement, Descriptor.Service.ELEMENT.name, (Object)actionArgument.getName());
        XMLUtil.appendNewElementIfNotNull(descriptor, actionArgumentElement, Descriptor.Service.ELEMENT.direction, (Object)actionArgument.getDirection().toString().toLowerCase(Locale.ENGLISH));
        if (actionArgument.isReturnValue()) {
            SpecificationViolationReporter.report("Not producing <retval> element to be compatible with WMP12: {}", actionArgument);
        }
        XMLUtil.appendNewElementIfNotNull((Document)var2_2, (Element)var3_3, Descriptor.Service.ELEMENT.relatedStateVariable, (Object)var1_1.getRelatedStateVariableName());
    }

    /*
     * WARNING - void declaration
     */
    private void generateServiceStateTable(Service serviceModel, Document descriptor, Element scpdElement) {
        Element serviceStateTableElement = XMLUtil.appendNewElement(descriptor, scpdElement, Descriptor.Service.ELEMENT.serviceStateTable);
        StateVariable<S>[] stateVariableArray = serviceModel.getStateVariables();
        int n = stateVariableArray.length;
        int n2 = 0;
        while (n2 < n) {
            void var1_1;
            StateVariable stateVariable = stateVariableArray[n2];
            this.generateStateVariable((StateVariable)var1_1, descriptor, serviceStateTableElement);
            ++n2;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void generateStateVariable(StateVariable stateVariable, Document descriptor, Element serviveStateTableElement) {
        Element stateVariableElement = XMLUtil.appendNewElement(descriptor, serviveStateTableElement, Descriptor.Service.ELEMENT.stateVariable);
        XMLUtil.appendNewElementIfNotNull(descriptor, stateVariableElement, Descriptor.Service.ELEMENT.name, (Object)stateVariable.getName());
        if (stateVariable.getTypeDetails().getDatatype() instanceof CustomDatatype) {
            XMLUtil.appendNewElementIfNotNull(descriptor, stateVariableElement, Descriptor.Service.ELEMENT.dataType, (Object)((CustomDatatype)stateVariable.getTypeDetails().getDatatype()).getName());
        } else {
            XMLUtil.appendNewElementIfNotNull(descriptor, stateVariableElement, Descriptor.Service.ELEMENT.dataType, (Object)stateVariable.getTypeDetails().getDatatype().getBuiltin().getDescriptorName());
        }
        XMLUtil.appendNewElementIfNotNull(descriptor, stateVariableElement, Descriptor.Service.ELEMENT.defaultValue, (Object)stateVariable.getTypeDetails().getDefaultValue());
        if (stateVariable.getEventDetails().isSendEvents()) {
            stateVariableElement.setAttribute(Descriptor.Service.ATTRIBUTE.sendEvents.toString(), "yes");
        } else {
            stateVariableElement.setAttribute(Descriptor.Service.ATTRIBUTE.sendEvents.toString(), "no");
        }
        if (stateVariable.getTypeDetails().getAllowedValues() != null) {
            Element allowedValueListElement = XMLUtil.appendNewElement(descriptor, stateVariableElement, Descriptor.Service.ELEMENT.allowedValueList);
            String[] stringArray = stateVariable.getTypeDetails().getAllowedValues();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String allowedValue = stringArray[n2];
                XMLUtil.appendNewElementIfNotNull(descriptor, allowedValueListElement, Descriptor.Service.ELEMENT.allowedValue, (Object)allowedValue);
                ++n2;
            }
        }
        if (stateVariable.getTypeDetails().getAllowedValueRange() != null) {
            void var3_3;
            Element allowedValueRangeElement = XMLUtil.appendNewElement(descriptor, (Element)var3_3, Descriptor.Service.ELEMENT.allowedValueRange);
            XMLUtil.appendNewElementIfNotNull(descriptor, allowedValueRangeElement, Descriptor.Service.ELEMENT.minimum, (Object)stateVariable.getTypeDetails().getAllowedValueRange().getMinimum());
            XMLUtil.appendNewElementIfNotNull(descriptor, allowedValueRangeElement, Descriptor.Service.ELEMENT.maximum, (Object)stateVariable.getTypeDetails().getAllowedValueRange().getMaximum());
            if (stateVariable.getTypeDetails().getAllowedValueRange().getStep() >= 1L) {
                void var1_1;
                void var2_2;
                XMLUtil.appendNewElementIfNotNull((Document)var2_2, allowedValueRangeElement, Descriptor.Service.ELEMENT.step, (Object)var1_1.getTypeDetails().getAllowedValueRange().getStep());
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void warning(SAXParseException e) throws SAXException {
        void var1_1;
        this.logger.warn(var1_1.toString());
    }

    @Override
    public void error(SAXParseException e) throws SAXException {
        throw e;
    }

    @Override
    public void fatalError(SAXParseException e) throws SAXException {
        throw e;
    }
}

