/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.binding.xml;

import java.io.StringReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.jupnp.binding.staging.MutableDevice;
import org.jupnp.binding.staging.MutableIcon;
import org.jupnp.binding.staging.MutableService;
import org.jupnp.binding.staging.MutableUDAVersion;
import org.jupnp.binding.xml.Descriptor;
import org.jupnp.binding.xml.DescriptorBindingException;
import org.jupnp.binding.xml.DeviceDescriptorBinder;
import org.jupnp.binding.xml.UDA10DeviceDescriptorBinderImpl;
import org.jupnp.model.ValidationException;
import org.jupnp.model.meta.Device;
import org.jupnp.model.types.DLNACaps;
import org.jupnp.model.types.DLNADoc;
import org.jupnp.model.types.InvalidValueException;
import org.jupnp.model.types.ServiceId;
import org.jupnp.model.types.ServiceType;
import org.jupnp.model.types.UDN;
import org.jupnp.util.MimeType;
import org.jupnp.util.SpecificationViolationReporter;
import org.jupnp.xml.SAXParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class UDA10DeviceDescriptorBinderSAXImpl
extends UDA10DeviceDescriptorBinderImpl {
    private final Logger logger = LoggerFactory.getLogger(DeviceDescriptorBinder.class);

    /*
     * WARNING - void declaration
     */
    @Override
    public <D extends Device> D describe(D undescribedDevice, String descriptorXml) throws DescriptorBindingException, ValidationException {
        if (descriptorXml == null || descriptorXml.isEmpty()) {
            throw new DescriptorBindingException("Null or empty descriptor");
        }
        try {
            void var1_1;
            void var2_2;
            this.logger.trace("Populating device from XML descriptor: {}", undescribedDevice);
            SAXParser parser = new SAXParser();
            MutableDevice descriptor = new MutableDevice();
            new RootHandler(descriptor, parser);
            parser.parse(new InputSource(new StringReader(var2_2.trim())));
            return (D)descriptor.build((Device)var1_1);
        }
        catch (ValidationException validationException) {
            ValidationException parser = validationException;
            throw validationException;
        }
        catch (Exception e) {
            void var3_5;
            throw new DescriptorBindingException("Could not parse device descriptor", (Throwable)var3_5);
        }
    }

    protected static class DeviceDescriptorHandler<I>
    extends SAXParser.Handler<I> {
        /*
         * WARNING - void declaration
         */
        public DeviceDescriptorHandler(I instance) {
            super(var1_1);
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public DeviceDescriptorHandler(I instance, SAXParser parser) {
            super(var1_1, (SAXParser)var2_2);
            void var2_2;
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public DeviceDescriptorHandler(I instance, DeviceDescriptorHandler parent) {
            super(var1_1, (SAXParser.Handler)var2_2);
            void var2_2;
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public DeviceDescriptorHandler(I instance, SAXParser parser, DeviceDescriptorHandler parent) {
            super(var1_1, (SAXParser)var2_2, (SAXParser.Handler)var3_3);
            void var3_3;
            void var2_2;
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            void var1_1;
            void var2_2;
            void var3_3;
            super.startElement(uri, localName, (String)var3_3, attributes);
            Descriptor.Device.ELEMENT el = Descriptor.Device.ELEMENT.valueOrNullOf((String)var2_2);
            if (el == null) {
                return;
            }
            this.startElement((Descriptor.Device.ELEMENT)var1_1, attributes);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            void var1_1;
            void var2_2;
            void var3_3;
            super.endElement(uri, localName, (String)var3_3);
            Descriptor.Device.ELEMENT el = Descriptor.Device.ELEMENT.valueOrNullOf((String)var2_2);
            if (el == null) {
                return;
            }
            this.endElement((Descriptor.Device.ELEMENT)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected boolean isLastElement(String uri, String localName, String qName) {
            void var1_1;
            Descriptor.Device.ELEMENT el = Descriptor.Device.ELEMENT.valueOrNullOf(localName);
            return el != null && this.isLastElement((Descriptor.Device.ELEMENT)var1_1);
        }

        public void startElement(Descriptor.Device.ELEMENT element, Attributes attributes) throws SAXException {
        }

        public void endElement(Descriptor.Device.ELEMENT element) throws SAXException {
        }

        public boolean isLastElement(Descriptor.Device.ELEMENT element) {
            return false;
        }
    }

    protected static class DeviceHandler
    extends DeviceDescriptorHandler<MutableDevice> {
        public static final Descriptor.Device.ELEMENT EL = Descriptor.Device.ELEMENT.device;

        /*
         * WARNING - void declaration
         */
        public DeviceHandler(MutableDevice instance, DeviceDescriptorHandler parent) {
            super(var1_1, (DeviceDescriptorHandler)var2_2);
            void var2_2;
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void startElement(Descriptor.Device.ELEMENT element, Attributes attributes) throws SAXException {
            void var1_1;
            if (element.equals((Object)IconListHandler.EL)) {
                ArrayList<MutableIcon> icons = new ArrayList<MutableIcon>();
                ((MutableDevice)this.getInstance()).icons = icons;
                new IconListHandler((List<MutableIcon>)icons, (DeviceDescriptorHandler)this);
            }
            if (element.equals((Object)ServiceListHandler.EL)) {
                ArrayList<MutableService> services = new ArrayList<MutableService>();
                ((MutableDevice)this.getInstance()).services = services;
                new ServiceListHandler((List<MutableService>)services, (DeviceDescriptorHandler)this);
            }
            if (var1_1.equals((Object)DeviceListHandler.EL)) {
                void var2_2;
                ArrayList<MutableDevice> devices = new ArrayList<MutableDevice>();
                ((MutableDevice)this.getInstance()).embeddedDevices = devices;
                new DeviceListHandler((List<MutableDevice>)var2_2, (DeviceDescriptorHandler)this);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void endElement(Descriptor.Device.ELEMENT element) throws SAXException {
            switch (element) {
                case deviceType: {
                    ((MutableDevice)this.getInstance()).deviceType = this.getCharacters();
                    return;
                }
                case friendlyName: {
                    ((MutableDevice)this.getInstance()).friendlyName = this.getCharacters();
                    return;
                }
                case manufacturer: {
                    ((MutableDevice)this.getInstance()).manufacturer = this.getCharacters();
                    return;
                }
                case manufacturerURL: {
                    ((MutableDevice)this.getInstance()).manufacturerURI = UDA10DeviceDescriptorBinderSAXImpl.parseURI(this.getCharacters());
                    return;
                }
                case modelDescription: {
                    ((MutableDevice)this.getInstance()).modelDescription = this.getCharacters();
                    return;
                }
                case modelName: {
                    ((MutableDevice)this.getInstance()).modelName = this.getCharacters();
                    return;
                }
                case modelNumber: {
                    ((MutableDevice)this.getInstance()).modelNumber = this.getCharacters();
                    return;
                }
                case modelURL: {
                    ((MutableDevice)this.getInstance()).modelURI = UDA10DeviceDescriptorBinderSAXImpl.parseURI(this.getCharacters());
                    return;
                }
                case presentationURL: {
                    ((MutableDevice)this.getInstance()).presentationURI = UDA10DeviceDescriptorBinderSAXImpl.parseURI(this.getCharacters());
                    return;
                }
                case UPC: {
                    ((MutableDevice)this.getInstance()).upc = this.getCharacters();
                    return;
                }
                case serialNumber: {
                    ((MutableDevice)this.getInstance()).serialNumber = this.getCharacters();
                    return;
                }
                case UDN: {
                    ((MutableDevice)this.getInstance()).udn = UDN.valueOf(this.getCharacters());
                    return;
                }
                case X_DLNADOC: {
                    String txt = this.getCharacters();
                    try {
                        ((MutableDevice)this.getInstance()).dlnaDocs.add(DLNADoc.valueOf(txt));
                        return;
                    }
                    catch (InvalidValueException invalidValueException) {
                        void var1_1;
                        SpecificationViolationReporter.report("Invalid X_DLNADOC value, ignoring value: {}", var1_1);
                        return;
                    }
                }
                case X_DLNACAP: {
                    ((MutableDevice)this.getInstance()).dlnaCaps = DLNACaps.valueOf(this.getCharacters());
                }
            }
        }

        @Override
        public boolean isLastElement(Descriptor.Device.ELEMENT element) {
            return element.equals((Object)EL);
        }
    }

    protected static class DeviceListHandler
    extends DeviceDescriptorHandler<List<MutableDevice>> {
        public static final Descriptor.Device.ELEMENT EL = Descriptor.Device.ELEMENT.deviceList;

        /*
         * WARNING - void declaration
         */
        public DeviceListHandler(List<MutableDevice> instance, DeviceDescriptorHandler parent) {
            super(var1_1, (DeviceDescriptorHandler)var2_2);
            void var2_2;
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void startElement(Descriptor.Device.ELEMENT element, Attributes attributes) throws SAXException {
            if (element.equals((Object)DeviceHandler.EL)) {
                void var1_1;
                MutableDevice device = new MutableDevice();
                ((List)this.getInstance()).add(device);
                new DeviceHandler((MutableDevice)var1_1, (DeviceDescriptorHandler)this);
            }
        }

        @Override
        public boolean isLastElement(Descriptor.Device.ELEMENT element) {
            return element.equals((Object)EL);
        }
    }

    protected static class IconHandler
    extends DeviceDescriptorHandler<MutableIcon> {
        public static final Descriptor.Device.ELEMENT EL = Descriptor.Device.ELEMENT.icon;

        /*
         * WARNING - void declaration
         */
        public IconHandler(MutableIcon instance, DeviceDescriptorHandler parent) {
            super(var1_1, (DeviceDescriptorHandler)var2_2);
            void var2_2;
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void endElement(Descriptor.Device.ELEMENT element) throws SAXException {
            switch (element) {
                case width: {
                    ((MutableIcon)this.getInstance()).width = Integer.parseInt(this.getCharacters());
                    return;
                }
                case height: {
                    ((MutableIcon)this.getInstance()).height = Integer.parseInt(this.getCharacters());
                    return;
                }
                case depth: {
                    try {
                        ((MutableIcon)this.getInstance()).depth = Integer.parseInt(this.getCharacters());
                        return;
                    }
                    catch (NumberFormatException e) {
                        void var1_2;
                        SpecificationViolationReporter.report("Invalid icon depth '{}', using 16 as default: {}", this.getCharacters(), var1_2);
                        ((MutableIcon)this.getInstance()).depth = 16;
                        return;
                    }
                }
                case url: {
                    ((MutableIcon)this.getInstance()).uri = UDA10DeviceDescriptorBinderSAXImpl.parseURI(this.getCharacters());
                    return;
                }
                case mimetype: {
                    try {
                        ((MutableIcon)this.getInstance()).mimeType = this.getCharacters();
                        MimeType.valueOf(((MutableIcon)this.getInstance()).mimeType);
                        return;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        SpecificationViolationReporter.report("Ignoring invalid icon mime type: {}", ((MutableIcon)this.getInstance()).mimeType);
                        ((MutableIcon)this.getInstance()).mimeType = "";
                    }
                }
            }
        }

        @Override
        public boolean isLastElement(Descriptor.Device.ELEMENT element) {
            return element.equals((Object)EL);
        }
    }

    protected static class IconListHandler
    extends DeviceDescriptorHandler<List<MutableIcon>> {
        public static final Descriptor.Device.ELEMENT EL = Descriptor.Device.ELEMENT.iconList;

        /*
         * WARNING - void declaration
         */
        public IconListHandler(List<MutableIcon> instance, DeviceDescriptorHandler parent) {
            super(var1_1, (DeviceDescriptorHandler)var2_2);
            void var2_2;
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void startElement(Descriptor.Device.ELEMENT element, Attributes attributes) throws SAXException {
            if (element.equals((Object)IconHandler.EL)) {
                void var1_1;
                MutableIcon icon = new MutableIcon();
                ((List)this.getInstance()).add(icon);
                new IconHandler((MutableIcon)var1_1, (DeviceDescriptorHandler)this);
            }
        }

        @Override
        public boolean isLastElement(Descriptor.Device.ELEMENT element) {
            return element.equals((Object)EL);
        }
    }

    protected static class RootHandler
    extends DeviceDescriptorHandler<MutableDevice> {
        /*
         * WARNING - void declaration
         */
        public RootHandler(MutableDevice instance, SAXParser parser) {
            super(var1_1, (SAXParser)var2_2);
            void var2_2;
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void startElement(Descriptor.Device.ELEMENT element, Attributes attributes) throws SAXException {
            void var1_1;
            if (element.equals((Object)SpecVersionHandler.EL)) {
                void var2_2;
                MutableUDAVersion udaVersion;
                ((MutableDevice)this.getInstance()).udaVersion = udaVersion = new MutableUDAVersion();
                new SpecVersionHandler((MutableUDAVersion)var2_2, (DeviceDescriptorHandler)this);
            }
            if (var1_1.equals((Object)DeviceHandler.EL)) {
                new DeviceHandler((MutableDevice)this.getInstance(), (DeviceDescriptorHandler)this);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void endElement(Descriptor.Device.ELEMENT element) throws SAXException {
            switch (element) {
                case URLBase: {
                    try {
                        String urlString = this.getCharacters();
                        if (urlString != null && !urlString.isEmpty()) {
                            ((MutableDevice)this.getInstance()).baseURL = new URL(urlString);
                            return;
                        }
                        break;
                    }
                    catch (Exception e) {
                        void var1_2;
                        throw new SAXException("Invalid URLBase", (Exception)var1_2);
                    }
                }
            }
        }
    }

    protected static class ServiceHandler
    extends DeviceDescriptorHandler<MutableService> {
        public static final Descriptor.Device.ELEMENT EL = Descriptor.Device.ELEMENT.service;
        private static volatile /* synthetic */ int[] $SWITCH_TABLE$org$jupnp$binding$xml$Descriptor$Device$ELEMENT;

        /*
         * WARNING - void declaration
         */
        public ServiceHandler(MutableService instance, DeviceDescriptorHandler parent) {
            super(var1_1, (DeviceDescriptorHandler)var2_2);
            void var2_2;
            void var1_1;
        }

        @Override
        public void endElement(Descriptor.Device.ELEMENT element) throws SAXException {
            InvalidValueException invalidValueException;
            try {
                switch (ServiceHandler.$SWITCH_TABLE$org$jupnp$binding$xml$Descriptor$Device$ELEMENT()[((Enum)((Object)invalidValueException)).ordinal()]) {
                    case 32: {
                        ((MutableService)this.getInstance()).serviceType = ServiceType.valueOf(this.getCharacters());
                        return;
                    }
                    case 33: {
                        ((MutableService)this.getInstance()).serviceId = ServiceId.valueOf(this.getCharacters());
                        return;
                    }
                    case 34: {
                        ((MutableService)this.getInstance()).descriptorURI = UDA10DeviceDescriptorBinderSAXImpl.parseURI(this.getCharacters());
                        return;
                    }
                    case 35: {
                        ((MutableService)this.getInstance()).controlURI = UDA10DeviceDescriptorBinderSAXImpl.parseURI(this.getCharacters());
                        return;
                    }
                    case 36: {
                        ((MutableService)this.getInstance()).eventSubscriptionURI = UDA10DeviceDescriptorBinderSAXImpl.parseURI(this.getCharacters());
                    }
                }
                return;
            }
            catch (InvalidValueException invalidValueException2) {
                invalidValueException = invalidValueException2;
                SpecificationViolationReporter.report("Skipping invalid service declaration. " + invalidValueException2.getMessage(), new Object[0]);
                return;
            }
        }

        @Override
        public boolean isLastElement(Descriptor.Device.ELEMENT element) {
            return element.equals((Object)EL);
        }

        static /* synthetic */ int[] $SWITCH_TABLE$org$jupnp$binding$xml$Descriptor$Device$ELEMENT() {
            if ($SWITCH_TABLE$org$jupnp$binding$xml$Descriptor$Device$ELEMENT != null) {
                return $SWITCH_TABLE$org$jupnp$binding$xml$Descriptor$Device$ELEMENT;
            }
            int[] nArray = new int[Descriptor.Device.ELEMENT.values().length];
            try {
                nArray[Descriptor.Device.ELEMENT.ProductCap.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[Descriptor.Device.ELEMENT.SCPDURL.ordinal()] = 34;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[Descriptor.Device.ELEMENT.UDN.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[Descriptor.Device.ELEMENT.UPC.ordinal()] = 21;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[Descriptor.Device.ELEMENT.URLBase.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[Descriptor.Device.ELEMENT.X_DLNACAP.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[Descriptor.Device.ELEMENT.X_DLNADOC.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[Descriptor.Device.ELEMENT.X_ProductCap.ordinal()] = 11;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[Descriptor.Device.ELEMENT.controlURL.ordinal()] = 35;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[Descriptor.Device.ELEMENT.depth.ordinal()] = 27;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[Descriptor.Device.ELEMENT.device.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[Descriptor.Device.ELEMENT.deviceList.ordinal()] = 37;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[Descriptor.Device.ELEMENT.deviceType.ordinal()] = 12;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[Descriptor.Device.ELEMENT.eventSubURL.ordinal()] = 36;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[Descriptor.Device.ELEMENT.friendlyName.ordinal()] = 13;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[Descriptor.Device.ELEMENT.height.ordinal()] = 26;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[Descriptor.Device.ELEMENT.icon.ordinal()] = 24;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[Descriptor.Device.ELEMENT.iconList.ordinal()] = 23;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[Descriptor.Device.ELEMENT.major.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[Descriptor.Device.ELEMENT.manufacturer.ordinal()] = 14;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[Descriptor.Device.ELEMENT.manufacturerURL.ordinal()] = 15;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[Descriptor.Device.ELEMENT.mimetype.ordinal()] = 29;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[Descriptor.Device.ELEMENT.minor.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[Descriptor.Device.ELEMENT.modelDescription.ordinal()] = 16;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[Descriptor.Device.ELEMENT.modelName.ordinal()] = 17;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[Descriptor.Device.ELEMENT.modelNumber.ordinal()] = 18;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[Descriptor.Device.ELEMENT.modelURL.ordinal()] = 19;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[Descriptor.Device.ELEMENT.presentationURL.ordinal()] = 20;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[Descriptor.Device.ELEMENT.root.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[Descriptor.Device.ELEMENT.serialNumber.ordinal()] = 22;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[Descriptor.Device.ELEMENT.service.ordinal()] = 31;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[Descriptor.Device.ELEMENT.serviceId.ordinal()] = 33;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[Descriptor.Device.ELEMENT.serviceList.ordinal()] = 30;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[Descriptor.Device.ELEMENT.serviceType.ordinal()] = 32;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[Descriptor.Device.ELEMENT.specVersion.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[Descriptor.Device.ELEMENT.url.ordinal()] = 28;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[Descriptor.Device.ELEMENT.width.ordinal()] = 25;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            $SWITCH_TABLE$org$jupnp$binding$xml$Descriptor$Device$ELEMENT = nArray;
            return nArray;
        }
    }

    protected static class ServiceListHandler
    extends DeviceDescriptorHandler<List<MutableService>> {
        public static final Descriptor.Device.ELEMENT EL = Descriptor.Device.ELEMENT.serviceList;

        /*
         * WARNING - void declaration
         */
        public ServiceListHandler(List<MutableService> instance, DeviceDescriptorHandler parent) {
            super(var1_1, (DeviceDescriptorHandler)var2_2);
            void var2_2;
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void startElement(Descriptor.Device.ELEMENT element, Attributes attributes) throws SAXException {
            if (element.equals((Object)ServiceHandler.EL)) {
                void var1_1;
                MutableService service = new MutableService();
                ((List)this.getInstance()).add(service);
                new ServiceHandler((MutableService)var1_1, (DeviceDescriptorHandler)this);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean isLastElement(Descriptor.Device.ELEMENT element) {
            void var1_2;
            boolean last = element.equals((Object)EL);
            if (last) {
                ((List)this.getInstance()).removeIf(service -> {
                    MutableService mutableService;
                    return service.serviceType == null || mutableService.serviceId == null;
                });
            }
            return (boolean)var1_2;
        }
    }

    protected static class SpecVersionHandler
    extends DeviceDescriptorHandler<MutableUDAVersion> {
        public static final Descriptor.Device.ELEMENT EL = Descriptor.Device.ELEMENT.specVersion;

        /*
         * WARNING - void declaration
         */
        public SpecVersionHandler(MutableUDAVersion instance, DeviceDescriptorHandler parent) {
            super(var1_1, (DeviceDescriptorHandler)var2_2);
            void var2_2;
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void endElement(Descriptor.Device.ELEMENT element) throws SAXException {
            switch (element) {
                case major: {
                    String majorVersion = this.getCharacters().trim();
                    if (!majorVersion.equals("1")) {
                        SpecificationViolationReporter.report("Unsupported UDA major version, ignoring: " + majorVersion, new Object[0]);
                        majorVersion = "1";
                    }
                    ((MutableUDAVersion)this.getInstance()).major = Integer.parseInt(majorVersion);
                    return;
                }
                case minor: {
                    void var1_1;
                    String minorVersion = this.getCharacters().trim();
                    if (!minorVersion.equals("0")) {
                        SpecificationViolationReporter.report("Unsupported UDA minor version, ignoring: " + minorVersion, new Object[0]);
                        minorVersion = "0";
                    }
                    ((MutableUDAVersion)this.getInstance()).minor = Integer.parseInt((String)var1_1);
                }
            }
        }

        @Override
        public boolean isLastElement(Descriptor.Device.ELEMENT element) {
            return element.equals((Object)EL);
        }
    }
}

