/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.binding.xml;

import java.io.StringReader;
import java.net.URI;
import java.net.URL;
import java.util.Locale;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.jupnp.binding.staging.MutableDevice;
import org.jupnp.binding.staging.MutableIcon;
import org.jupnp.binding.staging.MutableService;
import org.jupnp.binding.xml.Descriptor;
import org.jupnp.binding.xml.DescriptorBindingException;
import org.jupnp.binding.xml.DeviceDescriptorBinder;
import org.jupnp.model.Namespace;
import org.jupnp.model.ValidationException;
import org.jupnp.model.XMLUtil;
import org.jupnp.model.meta.Device;
import org.jupnp.model.meta.DeviceDetails;
import org.jupnp.model.meta.DeviceIdentity;
import org.jupnp.model.meta.Icon;
import org.jupnp.model.meta.LocalDevice;
import org.jupnp.model.meta.LocalService;
import org.jupnp.model.meta.RemoteDevice;
import org.jupnp.model.meta.RemoteService;
import org.jupnp.model.meta.Service;
import org.jupnp.model.profile.RemoteClientInfo;
import org.jupnp.model.types.DLNACaps;
import org.jupnp.model.types.DLNADoc;
import org.jupnp.model.types.InvalidValueException;
import org.jupnp.model.types.ServiceId;
import org.jupnp.model.types.ServiceType;
import org.jupnp.model.types.UDN;
import org.jupnp.util.MimeType;
import org.jupnp.util.SpecificationViolationReporter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class UDA10DeviceDescriptorBinderImpl
implements DeviceDescriptorBinder,
ErrorHandler {
    private final Logger logger = LoggerFactory.getLogger(DeviceDescriptorBinder.class);

    /*
     * WARNING - void declaration
     */
    public <D extends Device> D describe(D undescribedDevice, String descriptorXml) throws DescriptorBindingException, ValidationException {
        if (descriptorXml == null || descriptorXml.isEmpty()) {
            throw new DescriptorBindingException("Null or empty descriptor");
        }
        try {
            void var2_2;
            void var1_1;
            this.logger.trace("Populating device from XML descriptor: {}", undescribedDevice);
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            try {
                factory.setAttribute("http://apache.org/xml/properties/locale", Locale.ROOT);
            }
            catch (IllegalArgumentException e) {
                this.logger.debug("Parser does not support 'http://apache.org/xml/properties/locale' attribute", (Throwable)e);
            }
            DocumentBuilder documentBuilder = factory.newDocumentBuilder();
            documentBuilder.setErrorHandler(this);
            Document d = documentBuilder.parse(new InputSource(new StringReader(descriptorXml.trim())));
            return this.describe(var1_1, (Document)var2_2);
        }
        catch (ValidationException validationException) {
            ValidationException factory = validationException;
            throw validationException;
        }
        catch (Exception e) {
            void var3_5;
            throw new DescriptorBindingException("Could not parse device descriptor", (Throwable)var3_5);
        }
    }

    /*
     * WARNING - void declaration
     */
    public <D extends Device> D describe(D undescribedDevice, Document dom) throws DescriptorBindingException, ValidationException {
        try {
            void var1_1;
            void var2_2;
            this.logger.trace("Populating device from DOM: {}", undescribedDevice);
            MutableDevice descriptor = new MutableDevice();
            Element rootElement = dom.getDocumentElement();
            this.hydrateRoot(descriptor, (Element)var2_2);
            return this.buildInstance(var1_1, descriptor);
        }
        catch (ValidationException validationException) {
            ValidationException descriptor = validationException;
            throw validationException;
        }
        catch (Exception e) {
            void var3_5;
            throw new DescriptorBindingException("Could not parse device DOM", (Throwable)var3_5);
        }
    }

    /*
     * WARNING - void declaration
     */
    public <D extends Device> D buildInstance(D undescribedDevice, MutableDevice descriptor) throws ValidationException {
        void var1_1;
        return (D)descriptor.build((Device)var1_1);
    }

    /*
     * Unable to fully structure code
     */
    protected void hydrateRoot(MutableDevice descriptor, Element rootElement) throws DescriptorBindingException {
        if (rootElement.getNamespaceURI() == null || !rootElement.getNamespaceURI().equals("urn:schemas-upnp-org:device-1-0")) {
            SpecificationViolationReporter.report("Wrong XML namespace declared on root element: {}", new Object[]{rootElement.getNamespaceURI()});
        }
        if (!rootElement.getNodeName().equals(Descriptor.Device.ELEMENT.root.name())) {
            throw new DescriptorBindingException("Root element name is not <root>: " + rootElement.getNodeName());
        }
        rootChildren = rootElement.getChildNodes();
        deviceNode = null;
        i = 0;
        while (i < rootChildren.getLength()) {
            rootChild = rootChildren.item(i);
            if (rootChild.getNodeType() == 1) {
                if (Descriptor.Device.ELEMENT.specVersion.equals(rootChild)) {
                    this.hydrateSpecVersion(descriptor, rootChild);
                } else if (Descriptor.Device.ELEMENT.URLBase.equals(rootChild)) {
                    try {
                        urlString = XMLUtil.getTextContent(rootChild);
                        if (urlString == null || urlString.isEmpty()) ** GOTO lbl28
                        descriptor.baseURL = new URL(urlString);
                    }
                    catch (Exception e) {
                        throw new DescriptorBindingException("Invalid URLBase: " + e.getMessage());
                    }
                } else if (Descriptor.Device.ELEMENT.device.equals((Node)var5_5)) {
                    if (deviceNode != null) {
                        throw new DescriptorBindingException("Found multiple <device> elements in <root>");
                    }
                    deviceNode = var5_5;
                } else {
                    this.logger.trace("Ignoring unknown element: {}", (Object)var5_5.getNodeName());
                }
            }
lbl28:
            // 7 sources

            ++i;
        }
        if (deviceNode == null) {
            throw new DescriptorBindingException("No <device> element in <root>");
        }
        this.hydrateDevice((MutableDevice)var1_1, (Node)var3_3);
    }

    public void hydrateSpecVersion(MutableDevice descriptor, Node specVersionNode) throws DescriptorBindingException {
        NodeList specVersionChildren = specVersionNode.getChildNodes();
        int i = 0;
        while (i < specVersionChildren.getLength()) {
            Node specVersionChild = specVersionChildren.item(i);
            if (specVersionChild.getNodeType() == 1) {
                String version;
                if (Descriptor.Device.ELEMENT.major.equals(specVersionChild)) {
                    version = XMLUtil.getTextContent(specVersionChild).trim();
                    if (!version.equals("1")) {
                        SpecificationViolationReporter.report("Unsupported UDA major version, ignoring: " + version, new Object[0]);
                        version = "1";
                    }
                    descriptor.udaVersion.major = Integer.parseInt(version);
                } else if (Descriptor.Device.ELEMENT.minor.equals((Node)((Object)version))) {
                    if (!(version = XMLUtil.getTextContent((Node)((Object)version)).trim()).equals("0")) {
                        SpecificationViolationReporter.report("Unsupported UDA minor version, ignoring: " + version, new Object[0]);
                        version = "0";
                    }
                    descriptor.udaVersion.minor = Integer.parseInt(version);
                }
            }
            ++i;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void hydrateDevice(MutableDevice descriptor, Node deviceNode) throws DescriptorBindingException {
        NodeList deviceNodeChildren = deviceNode.getChildNodes();
        int i = 0;
        while (i < deviceNodeChildren.getLength()) {
            Node deviceNodeChild = deviceNodeChildren.item(i);
            if (deviceNodeChild.getNodeType() == 1) {
                void var4_4;
                if (Descriptor.Device.ELEMENT.deviceType.equals(deviceNodeChild)) {
                    descriptor.deviceType = XMLUtil.getTextContent(deviceNodeChild);
                } else if (Descriptor.Device.ELEMENT.friendlyName.equals(deviceNodeChild)) {
                    descriptor.friendlyName = XMLUtil.getTextContent(deviceNodeChild);
                } else if (Descriptor.Device.ELEMENT.manufacturer.equals(deviceNodeChild)) {
                    descriptor.manufacturer = XMLUtil.getTextContent(deviceNodeChild);
                } else if (Descriptor.Device.ELEMENT.manufacturerURL.equals(deviceNodeChild)) {
                    descriptor.manufacturerURI = UDA10DeviceDescriptorBinderImpl.parseURI(XMLUtil.getTextContent(deviceNodeChild));
                } else if (Descriptor.Device.ELEMENT.modelDescription.equals(deviceNodeChild)) {
                    descriptor.modelDescription = XMLUtil.getTextContent(deviceNodeChild);
                } else if (Descriptor.Device.ELEMENT.modelName.equals(deviceNodeChild)) {
                    descriptor.modelName = XMLUtil.getTextContent(deviceNodeChild);
                } else if (Descriptor.Device.ELEMENT.modelNumber.equals(deviceNodeChild)) {
                    descriptor.modelNumber = XMLUtil.getTextContent(deviceNodeChild);
                } else if (Descriptor.Device.ELEMENT.modelURL.equals(deviceNodeChild)) {
                    descriptor.modelURI = UDA10DeviceDescriptorBinderImpl.parseURI(XMLUtil.getTextContent(deviceNodeChild));
                } else if (Descriptor.Device.ELEMENT.presentationURL.equals(deviceNodeChild)) {
                    descriptor.presentationURI = UDA10DeviceDescriptorBinderImpl.parseURI(XMLUtil.getTextContent(deviceNodeChild));
                } else if (Descriptor.Device.ELEMENT.UPC.equals(deviceNodeChild)) {
                    descriptor.upc = XMLUtil.getTextContent(deviceNodeChild);
                } else if (Descriptor.Device.ELEMENT.serialNumber.equals(deviceNodeChild)) {
                    descriptor.serialNumber = XMLUtil.getTextContent(deviceNodeChild);
                } else if (Descriptor.Device.ELEMENT.UDN.equals(deviceNodeChild)) {
                    descriptor.udn = UDN.valueOf(XMLUtil.getTextContent(deviceNodeChild));
                } else if (Descriptor.Device.ELEMENT.iconList.equals(deviceNodeChild)) {
                    this.hydrateIconList(descriptor, deviceNodeChild);
                } else if (Descriptor.Device.ELEMENT.serviceList.equals(deviceNodeChild)) {
                    this.hydrateServiceList(descriptor, deviceNodeChild);
                } else if (Descriptor.Device.ELEMENT.deviceList.equals(deviceNodeChild)) {
                    this.hydrateDeviceList(descriptor, deviceNodeChild);
                } else if (Descriptor.Device.ELEMENT.X_DLNADOC.equals(deviceNodeChild) && "dlna".equals(deviceNodeChild.getPrefix())) {
                    String txt = XMLUtil.getTextContent(deviceNodeChild);
                    try {
                        descriptor.dlnaDocs.add(DLNADoc.valueOf(txt));
                    }
                    catch (InvalidValueException invalidValueException) {
                        this.logger.info("Invalid X_DLNADOC value, ignoring value: {}", (Object)txt);
                    }
                } else if (Descriptor.Device.ELEMENT.X_DLNACAP.equals((Node)var4_4) && "dlna".equals(var4_4.getPrefix())) {
                    descriptor.dlnaCaps = DLNACaps.valueOf(XMLUtil.getTextContent((Node)var4_4));
                }
            }
            ++i;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void hydrateIconList(MutableDevice descriptor, Node iconListNode) throws DescriptorBindingException {
        NodeList iconListNodeChildren = iconListNode.getChildNodes();
        int i = 0;
        while (i < iconListNodeChildren.getLength()) {
            Node iconListNodeChild = iconListNodeChildren.item(i);
            if (iconListNodeChild.getNodeType() == 1 && Descriptor.Device.ELEMENT.icon.equals(iconListNodeChild)) {
                MutableIcon icon = new MutableIcon();
                NodeList iconChildren = iconListNodeChild.getChildNodes();
                int x = 0;
                while (x < iconChildren.getLength()) {
                    Node iconChild = iconChildren.item(x);
                    if (iconChild.getNodeType() == 1) {
                        void var7_7;
                        if (Descriptor.Device.ELEMENT.width.equals(iconChild)) {
                            icon.width = Integer.parseInt(XMLUtil.getTextContent(iconChild));
                        } else if (Descriptor.Device.ELEMENT.height.equals(iconChild)) {
                            icon.height = Integer.parseInt(XMLUtil.getTextContent(iconChild));
                        } else if (Descriptor.Device.ELEMENT.depth.equals(iconChild)) {
                            String depth = XMLUtil.getTextContent(iconChild);
                            try {
                                icon.depth = Integer.parseInt(depth);
                            }
                            catch (NumberFormatException e) {
                                SpecificationViolationReporter.report("Invalid icon depth '{}', using 16 as default: {}", depth, e);
                                icon.depth = 16;
                            }
                        } else if (Descriptor.Device.ELEMENT.url.equals((Node)var7_7)) {
                            icon.uri = UDA10DeviceDescriptorBinderImpl.parseURI(XMLUtil.getTextContent((Node)var7_7));
                        } else if (Descriptor.Device.ELEMENT.mimetype.equals((Node)var7_7)) {
                            try {
                                icon.mimeType = XMLUtil.getTextContent((Node)var7_7);
                                MimeType.valueOf(icon.mimeType);
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                SpecificationViolationReporter.report("Ignoring invalid icon mime type: " + icon.mimeType, new Object[0]);
                                icon.mimeType = "";
                            }
                        }
                    }
                    ++x;
                }
                descriptor.icons.add(icon);
            }
            ++i;
        }
    }

    public void hydrateServiceList(MutableDevice descriptor, Node serviceListNode) throws DescriptorBindingException {
        NodeList serviceListNodeChildren = serviceListNode.getChildNodes();
        int i = 0;
        while (i < serviceListNodeChildren.getLength()) {
            Node serviceListNodeChild = serviceListNodeChildren.item(i);
            if (serviceListNodeChild.getNodeType() == 1 && Descriptor.Device.ELEMENT.service.equals(serviceListNodeChild)) {
                NodeList serviceChildren = serviceListNodeChild.getChildNodes();
                try {
                    MutableService service = new MutableService();
                    int x = 0;
                    while (x < serviceChildren.getLength()) {
                        Node serviceChild = serviceChildren.item(x);
                        if (serviceChild.getNodeType() == 1) {
                            if (Descriptor.Device.ELEMENT.serviceType.equals(serviceChild)) {
                                service.serviceType = ServiceType.valueOf(XMLUtil.getTextContent(serviceChild));
                            } else if (Descriptor.Device.ELEMENT.serviceId.equals(serviceChild)) {
                                service.serviceId = ServiceId.valueOf(XMLUtil.getTextContent(serviceChild));
                            } else if (Descriptor.Device.ELEMENT.SCPDURL.equals(serviceChild)) {
                                service.descriptorURI = UDA10DeviceDescriptorBinderImpl.parseURI(XMLUtil.getTextContent(serviceChild));
                            } else if (Descriptor.Device.ELEMENT.controlURL.equals(serviceChild)) {
                                service.controlURI = UDA10DeviceDescriptorBinderImpl.parseURI(XMLUtil.getTextContent(serviceChild));
                            } else if (Descriptor.Device.ELEMENT.eventSubURL.equals(serviceChild)) {
                                service.eventSubscriptionURI = UDA10DeviceDescriptorBinderImpl.parseURI(XMLUtil.getTextContent(serviceChild));
                            }
                        }
                        ++x;
                    }
                    descriptor.services.add(service);
                }
                catch (InvalidValueException invalidValueException) {
                    InvalidValueException invalidValueException2 = invalidValueException;
                    SpecificationViolationReporter.report("Skipping invalid service declaration. " + invalidValueException.getMessage(), new Object[0]);
                }
            }
            ++i;
        }
    }

    public void hydrateDeviceList(MutableDevice descriptor, Node deviceListNode) throws DescriptorBindingException {
        NodeList deviceListNodeChildren = deviceListNode.getChildNodes();
        int i = 0;
        while (i < deviceListNodeChildren.getLength()) {
            Node deviceListNodeChild = deviceListNodeChildren.item(i);
            if (deviceListNodeChild.getNodeType() == 1 && Descriptor.Device.ELEMENT.device.equals(deviceListNodeChild)) {
                MutableDevice embeddedDevice = new MutableDevice();
                new MutableDevice().parentDevice = descriptor;
                descriptor.embeddedDevices.add(embeddedDevice);
                this.hydrateDevice(embeddedDevice, deviceListNodeChild);
            }
            ++i;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String generate(Device deviceModel, RemoteClientInfo info, Namespace namespace) throws DescriptorBindingException {
        try {
            void var3_4;
            void var2_3;
            this.logger.trace("Generating XML descriptor from device model: {}", (Object)deviceModel);
            return XMLUtil.documentToString(this.buildDOM(deviceModel, (RemoteClientInfo)var2_3, (Namespace)var3_4));
        }
        catch (Exception e) {
            void var1_2;
            throw new DescriptorBindingException("Could not build DOM: " + e.getMessage(), (Throwable)var1_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Document buildDOM(Device deviceModel, RemoteClientInfo info, Namespace namespace) throws DescriptorBindingException {
        try {
            void var2_2;
            void var1_1;
            void var3_3;
            this.logger.trace("Generating DOM from device model: {}", (Object)deviceModel);
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            Document d = factory.newDocumentBuilder().newDocument();
            this.generateRoot((Namespace)var3_3, (Device)var1_1, d, (RemoteClientInfo)var2_2);
            return d;
        }
        catch (Exception e) {
            throw new DescriptorBindingException("Could not generate device descriptor: " + e.getMessage(), e);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void generateRoot(Namespace namespace, Device deviceModel, Document descriptor, RemoteClientInfo info) {
        void var3_3;
        void var2_2;
        void var1_1;
        Element rootElement = descriptor.createElementNS("urn:schemas-upnp-org:device-1-0", Descriptor.Device.ELEMENT.root.toString());
        descriptor.appendChild(rootElement);
        this.generateSpecVersion(namespace, deviceModel, descriptor, rootElement);
        this.generateDevice((Namespace)var1_1, (Device)var2_2, (Document)var3_3, rootElement, info);
    }

    /*
     * WARNING - void declaration
     */
    protected void generateSpecVersion(Namespace namespace, Device deviceModel, Document descriptor, Element rootElement) {
        void var2_2;
        void var1_1;
        void var3_3;
        Element specVersionElement = XMLUtil.appendNewElement(descriptor, rootElement, Descriptor.Device.ELEMENT.specVersion);
        XMLUtil.appendNewElementIfNotNull(descriptor, specVersionElement, Descriptor.Device.ELEMENT.major, (Object)deviceModel.getVersion().getMajor());
        XMLUtil.appendNewElementIfNotNull((Document)var3_3, (Element)var1_1, Descriptor.Device.ELEMENT.minor, (Object)var2_2.getVersion().getMinor());
    }

    /*
     * WARNING - void declaration
     */
    protected void generateDevice(Namespace namespace, Device deviceModel, Document descriptor, Element rootElement, RemoteClientInfo info) {
        void var3_3;
        void var2_2;
        void var1_1;
        Element deviceElement = XMLUtil.appendNewElement(descriptor, rootElement, Descriptor.Device.ELEMENT.device);
        XMLUtil.appendNewElementIfNotNull(descriptor, deviceElement, Descriptor.Device.ELEMENT.deviceType, (Object)deviceModel.getType());
        DeviceDetails deviceModelDetails = deviceModel.getDetails(info);
        XMLUtil.appendNewElementIfNotNull(descriptor, deviceElement, Descriptor.Device.ELEMENT.friendlyName, (Object)deviceModelDetails.getFriendlyName());
        if (deviceModelDetails.getManufacturerDetails() != null) {
            XMLUtil.appendNewElementIfNotNull(descriptor, deviceElement, Descriptor.Device.ELEMENT.manufacturer, (Object)deviceModelDetails.getManufacturerDetails().getManufacturer());
            XMLUtil.appendNewElementIfNotNull(descriptor, deviceElement, Descriptor.Device.ELEMENT.manufacturerURL, (Object)deviceModelDetails.getManufacturerDetails().getManufacturerURI());
        }
        if (deviceModelDetails.getModelDetails() != null) {
            XMLUtil.appendNewElementIfNotNull(descriptor, deviceElement, Descriptor.Device.ELEMENT.modelDescription, (Object)deviceModelDetails.getModelDetails().getModelDescription());
            XMLUtil.appendNewElementIfNotNull(descriptor, deviceElement, Descriptor.Device.ELEMENT.modelName, (Object)deviceModelDetails.getModelDetails().getModelName());
            XMLUtil.appendNewElementIfNotNull(descriptor, deviceElement, Descriptor.Device.ELEMENT.modelNumber, (Object)deviceModelDetails.getModelDetails().getModelNumber());
            XMLUtil.appendNewElementIfNotNull(descriptor, deviceElement, Descriptor.Device.ELEMENT.modelURL, (Object)deviceModelDetails.getModelDetails().getModelURI());
        }
        XMLUtil.appendNewElementIfNotNull(descriptor, deviceElement, Descriptor.Device.ELEMENT.serialNumber, (Object)deviceModelDetails.getSerialNumber());
        XMLUtil.appendNewElementIfNotNull(descriptor, deviceElement, Descriptor.Device.ELEMENT.UDN, (Object)((DeviceIdentity)deviceModel.getIdentity()).getUdn());
        XMLUtil.appendNewElementIfNotNull(descriptor, deviceElement, Descriptor.Device.ELEMENT.presentationURL, (Object)deviceModelDetails.getPresentationURI());
        XMLUtil.appendNewElementIfNotNull(descriptor, deviceElement, Descriptor.Device.ELEMENT.UPC, (Object)deviceModelDetails.getUpc());
        if (deviceModelDetails.getDlnaDocs() != null) {
            DLNADoc[] dLNADocArray = deviceModelDetails.getDlnaDocs();
            int n = dLNADocArray.length;
            int n2 = 0;
            while (n2 < n) {
                DLNADoc dlnaDoc = dLNADocArray[n2];
                XMLUtil.appendNewElementIfNotNull(descriptor, deviceElement, "dlna:" + String.valueOf((Object)Descriptor.Device.ELEMENT.X_DLNADOC), (Object)dlnaDoc, "urn:schemas-dlna-org:device-1-0");
                ++n2;
            }
        }
        XMLUtil.appendNewElementIfNotNull(descriptor, deviceElement, "dlna:" + String.valueOf((Object)Descriptor.Device.ELEMENT.X_DLNACAP), (Object)deviceModelDetails.getDlnaCaps(), "urn:schemas-dlna-org:device-1-0");
        XMLUtil.appendNewElementIfNotNull(descriptor, deviceElement, "sec:" + String.valueOf((Object)Descriptor.Device.ELEMENT.ProductCap), (Object)deviceModelDetails.getSecProductCaps(), "http://www.sec.co.kr/dlna");
        XMLUtil.appendNewElementIfNotNull(descriptor, deviceElement, "sec:" + String.valueOf((Object)Descriptor.Device.ELEMENT.X_ProductCap), (Object)deviceModelDetails.getSecProductCaps(), "http://www.sec.co.kr/dlna");
        this.generateIconList(namespace, deviceModel, descriptor, deviceElement);
        this.generateServiceList(namespace, deviceModel, descriptor, deviceElement);
        this.generateDeviceList((Namespace)var1_1, (Device)var2_2, (Document)var3_3, deviceElement, info);
    }

    protected void generateIconList(Namespace namespace, Device deviceModel, Document descriptor, Element deviceElement) {
        if (!deviceModel.hasIcons()) {
            return;
        }
        Element iconListElement = XMLUtil.appendNewElement(descriptor, deviceElement, Descriptor.Device.ELEMENT.iconList);
        Icon[] iconArray = deviceModel.getIcons();
        int n = iconArray.length;
        int n2 = 0;
        while (n2 < n) {
            Icon icon = iconArray[n2];
            Element iconElement = XMLUtil.appendNewElement(descriptor, iconListElement, Descriptor.Device.ELEMENT.icon);
            XMLUtil.appendNewElementIfNotNull(descriptor, iconElement, Descriptor.Device.ELEMENT.mimetype, (Object)icon.getMimeType());
            XMLUtil.appendNewElementIfNotNull(descriptor, iconElement, Descriptor.Device.ELEMENT.width, (Object)icon.getWidth());
            XMLUtil.appendNewElementIfNotNull(descriptor, iconElement, Descriptor.Device.ELEMENT.height, (Object)icon.getHeight());
            XMLUtil.appendNewElementIfNotNull(descriptor, iconElement, Descriptor.Device.ELEMENT.depth, (Object)icon.getDepth());
            if (deviceModel instanceof RemoteDevice) {
                XMLUtil.appendNewElementIfNotNull(descriptor, iconElement, Descriptor.Device.ELEMENT.url, (Object)icon.getUri());
            } else if (deviceModel instanceof LocalDevice) {
                XMLUtil.appendNewElementIfNotNull(descriptor, iconElement, Descriptor.Device.ELEMENT.url, (Object)namespace.getIconPath(icon));
            }
            ++n2;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void generateServiceList(Namespace namespace, Device deviceModel, Document descriptor, Element deviceElement) {
        if (!deviceModel.hasServices()) {
            return;
        }
        Element serviceListElement = XMLUtil.appendNewElement(descriptor, deviceElement, Descriptor.Device.ELEMENT.serviceList);
        Service[] serviceArray = deviceModel.getServices();
        int n = serviceArray.length;
        int n2 = 0;
        while (n2 < n) {
            RemoteService rs;
            Service service = serviceArray[n2];
            Element serviceElement = XMLUtil.appendNewElement(descriptor, serviceListElement, Descriptor.Device.ELEMENT.service);
            XMLUtil.appendNewElementIfNotNull(descriptor, serviceElement, Descriptor.Device.ELEMENT.serviceType, (Object)service.getServiceType());
            XMLUtil.appendNewElementIfNotNull(descriptor, serviceElement, Descriptor.Device.ELEMENT.serviceId, (Object)service.getServiceId());
            if (service instanceof RemoteService) {
                rs = (RemoteService)service;
                XMLUtil.appendNewElementIfNotNull(descriptor, serviceElement, Descriptor.Device.ELEMENT.SCPDURL, (Object)rs.getDescriptorURI());
                XMLUtil.appendNewElementIfNotNull(descriptor, serviceElement, Descriptor.Device.ELEMENT.controlURL, (Object)rs.getControlURI());
                XMLUtil.appendNewElementIfNotNull(descriptor, serviceElement, Descriptor.Device.ELEMENT.eventSubURL, (Object)rs.getEventSubscriptionURI());
            } else if (rs instanceof LocalService) {
                void var2_2;
                LocalService ls = (LocalService)((Object)rs);
                XMLUtil.appendNewElementIfNotNull(descriptor, serviceElement, Descriptor.Device.ELEMENT.SCPDURL, (Object)namespace.getDescriptorPath(ls));
                XMLUtil.appendNewElementIfNotNull(descriptor, serviceElement, Descriptor.Device.ELEMENT.controlURL, (Object)namespace.getControlPath(ls));
                XMLUtil.appendNewElementIfNotNull(descriptor, serviceElement, Descriptor.Device.ELEMENT.eventSubURL, (Object)namespace.getEventSubscriptionPath((Service)var2_2));
            }
            ++n2;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void generateDeviceList(Namespace namespace, Device deviceModel, Document descriptor, Element deviceElement, RemoteClientInfo info) {
        if (!deviceModel.hasEmbeddedDevices()) {
            return;
        }
        Element deviceListElement = XMLUtil.appendNewElement(descriptor, deviceElement, Descriptor.Device.ELEMENT.deviceList);
        Device[] deviceArray = deviceModel.getEmbeddedDevices();
        int n = deviceArray.length;
        int n2 = 0;
        while (n2 < n) {
            void var2_2;
            Device device = deviceArray[n2];
            this.generateDevice(namespace, (Device)var2_2, descriptor, deviceListElement, info);
            ++n2;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void warning(SAXParseException e) throws SAXException {
        void var1_1;
        this.logger.warn(var1_1.toString());
    }

    @Override
    public void error(SAXParseException e) throws SAXException {
        throw e;
    }

    @Override
    public void fatalError(SAXParseException e) throws SAXException {
        throw e;
    }

    /*
     * WARNING - void declaration
     */
    protected static URI parseURI(String uri) {
        if (((String)uri).startsWith("www.")) {
            uri = "http://" + (String)uri;
        }
        if (((String)uri).contains(" ")) {
            uri = ((String)uri).replaceAll(" ", "%20");
        }
        try {
            return URI.create((String)uri);
        }
        catch (IllegalArgumentException | NullPointerException e) {
            Logger logger = LoggerFactory.getLogger(DeviceDescriptorBinder.class);
            logger.trace("Illegal URI, trying with ./ prefix", (Throwable)e);
            try {
                return URI.create("./" + (String)uri);
            }
            catch (IllegalArgumentException e2) {
                void var1_2;
                String string;
                SpecificationViolationReporter.report("Illegal URI '{}', ignoring value", string, var1_2);
                return null;
            }
        }
    }
}

