/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.binding.xml;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jupnp.binding.xml.DescriptorBindingException;
import org.jupnp.binding.xml.ServiceDescriptorBinder;
import org.jupnp.binding.xml.UDA10ServiceDescriptorBinderSAXImpl;
import org.jupnp.model.ValidationException;
import org.jupnp.model.meta.Service;
import org.jupnp.util.SpecificationViolationReporter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecoveringUDA10ServiceDescriptorBinderSAXImpl
extends UDA10ServiceDescriptorBinderSAXImpl {
    private final Logger logger = LoggerFactory.getLogger(ServiceDescriptorBinder.class);

    /*
     * WARNING - void declaration
     */
    @Override
    public <S extends Service> S describe(S undescribedService, String descriptorXml) throws DescriptorBindingException, ValidationException {
        if (descriptorXml == null || descriptorXml.isEmpty()) {
            throw new DescriptorBindingException("Null or empty descriptor");
        }
        try {
            void var1_1;
            this.logger.trace("Reading service from XML descriptor");
            String fixedXml = this.fixBOM(descriptorXml);
            fixedXml = this.fixRetval(fixedXml);
            fixedXml = this.fixQuotes(fixedXml);
            return super.describe(var1_1, fixedXml);
        }
        catch (DescriptorBindingException e) {
            void var2_3;
            this.logger.warn(var2_3.getMessage());
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected String fixBOM(String descriptorXml) {
        void var1_1;
        if (((String)descriptorXml).contains("<scpd xmlns=\"urn:Belkin:service-1-0\">")) {
            descriptorXml = ((String)descriptorXml).trim().replaceFirst("^([\\W]+)<", "<");
            descriptorXml = Pattern.compile("^([\\W]+)<").matcher(((String)descriptorXml).trim());
            String newXml = ((Matcher)descriptorXml).replaceFirst("<");
            SpecificationViolationReporter.report("Detected UTF-8 BOM, replacing it", new Object[0]);
            return var1_1.replaceAll("\u0000", " ");
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    protected String fixRetval(String descriptorXml) {
        void var1_1;
        if (descriptorXml.contains("<scpd xmlns=\"urn:Belkin:service-1-0\">") && descriptorXml.contains("<retval")) {
            SpecificationViolationReporter.report("Detected invalid service value 'retval', replacing it", new Object[0]);
            descriptorXml = descriptorXml.replaceAll("<retval/>", " ");
            return descriptorXml.replaceAll("<retval />", " ");
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    protected String fixQuotes(String descriptorXml) {
        void var1_1;
        if (descriptorXml.contains("<scpd xmlns=\"urn:Belkin:service-1-0\">") && descriptorXml.contains("Key\"")) {
            SpecificationViolationReporter.report("Detected invalid quotes, replacing it", new Object[0]);
            descriptorXml = descriptorXml.replaceAll("\"smartprivateKey\"", "smartprivateKey");
            return descriptorXml.replaceAll("\"pluginprivateKey\"", "pluginprivateKey");
        }
        return var1_1;
    }
}

