/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.binding.xml;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jupnp.binding.xml.DescriptorBindingException;
import org.jupnp.binding.xml.UDA10DeviceDescriptorBinderImpl;
import org.jupnp.model.ValidationException;
import org.jupnp.model.meta.Device;
import org.jupnp.model.meta.RemoteDevice;
import org.jupnp.model.meta.RemoteDeviceIdentity;
import org.jupnp.util.SpecificationViolationReporter;
import org.jupnp.xml.ParserException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXParseException;

public class RecoveringUDA10DeviceDescriptorBinderImpl
extends UDA10DeviceDescriptorBinderImpl {
    private final Logger logger = LoggerFactory.getLogger(RecoveringUDA10DeviceDescriptorBinderImpl.class);

    /*
     * WARNING - void declaration
     */
    @Override
    public <D extends Device> D describe(D undescribedDevice, String descriptorXml) throws DescriptorBindingException, ValidationException {
        block16: {
            D device = null;
            DescriptorBindingException originalException = null;
            try {
                try {
                    if (descriptorXml != null) {
                        descriptorXml = descriptorXml.trim();
                    }
                    String fixedXml = this.fixMimeTypes(descriptorXml);
                    fixedXml = this.fixWrongNamespaces(fixedXml);
                    device = super.describe(undescribedDevice, fixedXml = this.fixWemoMakerUDN(fixedXml));
                    if (this.isSonosGroupDevice(device)) {
                        throw new IllegalArgumentException("Ignore Sonos group devices due to invalid descriptor content.");
                    }
                    return device;
                }
                catch (DescriptorBindingException e) {
                    this.logger.warn("Regular parsing failed", (Throwable)e);
                    originalException = e;
                }
                catch (IllegalArgumentException e) {
                    this.handleInvalidDescriptor(descriptorXml, new DescriptorBindingException(e.getMessage()));
                }
                String fixedXml = this.fixGarbageLeadingChars(descriptorXml);
                if (fixedXml != null) {
                    try {
                        D d = super.describe(undescribedDevice, fixedXml);
                        device = d;
                        return d;
                    }
                    catch (DescriptorBindingException e) {
                        this.logger.warn("Removing leading garbage didn't work", (Throwable)e);
                    }
                }
                if ((fixedXml = this.fixGarbageTrailingChars(descriptorXml, originalException)) != null) {
                    try {
                        D d = super.describe(undescribedDevice, fixedXml);
                        device = d;
                        return d;
                    }
                    catch (DescriptorBindingException e) {
                        this.logger.warn("Removing trailing garbage didn't work", (Throwable)e);
                    }
                }
                DescriptorBindingException lastException = originalException;
                fixedXml = descriptorXml;
                int retryCount = 0;
                while (retryCount < 5) {
                    if ((fixedXml = this.fixMissingNamespaces(fixedXml, lastException)) == null) break;
                    try {
                        D d = super.describe(undescribedDevice, fixedXml);
                        device = d;
                        return d;
                    }
                    catch (DescriptorBindingException e) {
                        this.logger.warn("Fixing namespace prefix didn't work", (Throwable)e);
                        DescriptorBindingException descriptorBindingException = e;
                        ++retryCount;
                    }
                }
                this.handleInvalidDescriptor(descriptorXml, originalException);
            }
            catch (ValidationException e) {
                void var3_3;
                void var2_2;
                device = this.handleInvalidDevice((String)var2_2, device, e);
                if (device == null) break block16;
                return var3_3;
            }
        }
        throw new IllegalStateException("No device produced, did you swallow exceptions in your subclass?");
    }

    /*
     * WARNING - void declaration
     */
    private String fixGarbageLeadingChars(String descriptorXml) {
        void var2_2;
        void var1_1;
        int index = descriptorXml.indexOf("<?xml");
        if (index == -1) {
            return descriptorXml;
        }
        return var1_1.substring((int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    protected String fixGarbageTrailingChars(String descriptorXml, DescriptorBindingException e) {
        int index = descriptorXml.indexOf("</root>");
        if (index == -1) {
            SpecificationViolationReporter.report("No closing </root> element in descriptor", new Object[0]);
            return null;
        }
        if (descriptorXml.length() != index + 7) {
            void var2_3;
            void var1_1;
            SpecificationViolationReporter.report("Detected garbage characters after <root> node, removing", new Object[0]);
            return var1_1.substring(0, (int)var2_3) + "</root>";
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    protected String fixMimeTypes(String descriptorXml) {
        void var1_1;
        if (descriptorXml.contains("<mimetype>jpg</mimetype>")) {
            SpecificationViolationReporter.report("Detected invalid mimetype 'jpg', replacing it with 'image/jpeg'", new Object[0]);
            return descriptorXml.replaceAll("<mimetype>jpg</mimetype>", "<mimetype>image/jpeg</mimetype>");
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    protected String fixWrongNamespaces(String descriptorXml) {
        void var1_1;
        if (descriptorXml.contains("<root xmlns=\"urn:Belkin:device-1-0\">")) {
            SpecificationViolationReporter.report("Detected invalid root namespace 'urn:Belkin', replacing it with 'urn:schemas-upnp-org'", new Object[0]);
            return descriptorXml.replaceAll("<root xmlns=\"urn:Belkin:device-1-0\">", "<root xmlns=\"urn:schemas-upnp-org:device-1-0\">");
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    protected String fixMissingNamespaces(String descriptorXml, DescriptorBindingException e) {
        void var1_1;
        void var2_2;
        Throwable cause = e.getCause();
        if (!(cause instanceof SAXParseException) && !(cause instanceof ParserException)) {
            return null;
        }
        String message = cause.getMessage();
        if (message == null) {
            return null;
        }
        Pattern pattern = Pattern.compile("The prefix \"(.*)\" for element");
        Object matcher = pattern.matcher(message);
        if (!((Matcher)matcher).find() || ((Matcher)matcher).groupCount() != 1) {
            matcher = Pattern.compile("undefined prefix: ([^ ]*)");
            if (!((Matcher)(matcher = ((Pattern)matcher).matcher(message))).find() || ((Matcher)matcher).groupCount() != 1) {
                return null;
            }
        }
        String missingNS = ((Matcher)matcher).group(1);
        SpecificationViolationReporter.report("Fixing missing namespace declaration for: {}", missingNS);
        matcher = Pattern.compile("<root([^>]*)");
        matcher = ((Pattern)matcher).matcher(descriptorXml);
        if (!((Matcher)matcher).find() || ((Matcher)matcher).groupCount() != 1) {
            this.logger.trace("Could not find <root> element attributes");
            return null;
        }
        String rootAttributes = ((Matcher)matcher).group(1);
        this.logger.trace("Preserving existing <root> element attributes/namespace declarations: {}", (Object)((Matcher)matcher).group(0));
        matcher = Pattern.compile("<root[^>]*>(.*)</root>", 32);
        matcher = ((Pattern)matcher).matcher(descriptorXml);
        if (!((Matcher)matcher).find() || ((Matcher)matcher).groupCount() != 1) {
            this.logger.trace("Could not extract body of <root> element");
            return null;
        }
        String rootBody = ((Matcher)((Object)pattern)).group(1);
        return "<?xml version=\"1.0\" encoding=\"UTF-8\" ?><root " + String.format("xmlns:%s=\"urn:schemas-dlna-org:device-1-0\"", var2_2) + rootAttributes + ">" + (String)var1_1 + "</root>";
    }

    /*
     * WARNING - void declaration
     */
    protected String fixWemoMakerUDN(String descriptorXml) {
        void var1_1;
        if (descriptorXml.contains(":sensor:switch")) {
            SpecificationViolationReporter.report("Detected invalid UDN value ':sensor:switch', replacing it", new Object[0]);
            descriptorXml = descriptorXml.replaceAll(":sensor:switch", "");
            return descriptorXml.replaceAll(":sensor:switch", "");
        }
        return var1_1;
    }

    protected void handleInvalidDescriptor(String xml, DescriptorBindingException exception) throws DescriptorBindingException {
        throw exception;
    }

    protected <D extends Device> D handleInvalidDevice(String xml, D device, ValidationException exception) throws ValidationException {
        throw exception;
    }

    /*
     * WARNING - void declaration
     */
    private <D extends Device> boolean isSonosGroupDevice(D device) {
        if (device instanceof RemoteDevice) {
            void var1_1;
            RemoteDevice rd = (RemoteDevice)device;
            return this.isGroupInformationAvailable(rd) && rd.getDetails().getManufacturerDetails().getManufacturer().toLowerCase().contains("sonos") && rd.getType().toString().contains("urn:smartspeaker-audio:device:SpeakerGroup") && ((RemoteDeviceIdentity)var1_1.getIdentity()).getDescriptorURL().toString().endsWith("group_description.xml");
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private boolean isGroupInformationAvailable(RemoteDevice rd) {
        void var1_1;
        return rd != null && rd.getType() != null && rd.getIdentity() != null && rd.getDetails() != null && rd.getDetails().getManufacturerDetails() != null && rd.getDetails().getManufacturerDetails().getManufacturer() != null && ((RemoteDeviceIdentity)var1_1.getIdentity()).getDescriptorURL() != null;
    }
}

