/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.binding.staging;

import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.jupnp.binding.staging.MutableIcon;
import org.jupnp.binding.staging.MutableService;
import org.jupnp.binding.staging.MutableUDAVersion;
import org.jupnp.model.ValidationException;
import org.jupnp.model.meta.Device;
import org.jupnp.model.meta.DeviceDetails;
import org.jupnp.model.meta.Icon;
import org.jupnp.model.meta.ManufacturerDetails;
import org.jupnp.model.meta.ModelDetails;
import org.jupnp.model.meta.Service;
import org.jupnp.model.meta.UDAVersion;
import org.jupnp.model.types.DLNACaps;
import org.jupnp.model.types.DLNADoc;
import org.jupnp.model.types.DeviceType;
import org.jupnp.model.types.UDN;

public class MutableDevice {
    public UDN udn;
    public MutableUDAVersion udaVersion = new MutableUDAVersion();
    public URL baseURL;
    public String deviceType;
    public String friendlyName;
    public String manufacturer;
    public URI manufacturerURI;
    public String modelName;
    public String modelDescription;
    public String modelNumber;
    public URI modelURI;
    public String serialNumber;
    public String upc;
    public URI presentationURI;
    public List<DLNADoc> dlnaDocs = new ArrayList<DLNADoc>();
    public DLNACaps dlnaCaps;
    public List<MutableIcon> icons = new ArrayList<MutableIcon>();
    public List<MutableService> services = new ArrayList<MutableService>();
    public List<MutableDevice> embeddedDevices = new ArrayList<MutableDevice>();
    public MutableDevice parentDevice;

    /*
     * WARNING - void declaration
     */
    public Device build(Device prototype) throws ValidationException {
        void var1_1;
        return this.build((Device)var1_1, this.createDeviceVersion(), this.baseURL);
    }

    /*
     * WARNING - void declaration
     */
    public Device build(Device prototype, UDAVersion deviceVersion, URL baseURL) throws ValidationException {
        void var1_1;
        void var3_3;
        void var2_2;
        ArrayList<Device> embeddedDevicesList = new ArrayList<Device>();
        for (MutableDevice embeddedDevice : this.embeddedDevices) {
            embeddedDevicesList.add(embeddedDevice.build(prototype, deviceVersion, baseURL));
        }
        return prototype.newInstance(this.udn, (UDAVersion)var2_2, this.createDeviceType(), this.createDeviceDetails((URL)var3_3), this.createIcons(), this.createServices((Device)var1_1), embeddedDevicesList);
    }

    public UDAVersion createDeviceVersion() {
        return new UDAVersion(this.udaVersion.major, this.udaVersion.minor);
    }

    public DeviceType createDeviceType() {
        return DeviceType.valueOf(this.deviceType);
    }

    /*
     * WARNING - void declaration
     */
    public DeviceDetails createDeviceDetails(URL baseURL) {
        void var1_1;
        return new DeviceDetails((URL)var1_1, this.friendlyName, new ManufacturerDetails(this.manufacturer, this.manufacturerURI), new ModelDetails(this.modelName, this.modelDescription, this.modelNumber, this.modelURI), this.serialNumber, this.upc, this.presentationURI, this.dlnaDocs.toArray(new DLNADoc[this.dlnaDocs.size()]), this.dlnaCaps);
    }

    /*
     * WARNING - void declaration
     */
    public Icon[] createIcons() {
        void var1_1;
        Icon[] iconArray = new Icon[this.icons.size()];
        int i = 0;
        for (MutableIcon icon : this.icons) {
            void var3_4;
            iconArray[i++] = var3_4.build();
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public Service[] createServices(Device prototype) throws ValidationException {
        void var2_2;
        Service[] services = prototype.newServiceArray(this.services.size());
        int i = 0;
        for (MutableService service : this.services) {
            services[i++] = service.build(prototype);
        }
        return var2_2;
    }
}

