/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.jupnp.UpnpService;
import org.jupnp.UpnpServiceConfiguration;
import org.jupnp.controlpoint.ControlPoint;
import org.jupnp.controlpoint.ControlPointImpl;
import org.jupnp.model.message.header.STAllHeader;
import org.jupnp.protocol.ProtocolFactory;
import org.jupnp.protocol.ProtocolFactoryImpl;
import org.jupnp.registry.Registry;
import org.jupnp.registry.RegistryImpl;
import org.jupnp.transport.Router;
import org.jupnp.transport.RouterException;
import org.jupnp.transport.RouterImpl;
import org.jupnp.util.Exceptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpnpServiceImpl
implements UpnpService {
    private final Logger logger = LoggerFactory.getLogger(UpnpServiceImpl.class);
    protected boolean isConfigured = false;
    protected boolean isRunning = false;
    private volatile boolean isInitialSearchEnabled = true;
    private final Object lock = new Object();
    protected UpnpServiceConfiguration configuration;
    protected ProtocolFactory protocolFactory;
    protected Registry registry;
    protected ControlPoint controlPoint;
    protected Router router;
    protected ScheduledExecutorService scheduledExecutorService;
    protected volatile ScheduledFuture<?> scheduledFuture;

    public UpnpServiceImpl() {
    }

    /*
     * WARNING - void declaration
     */
    public UpnpServiceImpl(UpnpServiceConfiguration configuration) {
        void var1_1;
        this.configuration = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void activate(Config config) {
        void var1_1;
        this.scheduledFuture = null;
        this.scheduledExecutorService = UpnpServiceImpl.createExecutor();
        this.isInitialSearchEnabled = var1_1.initialSearchEnabled();
        this.startup();
    }

    public void deactivate() {
        if (this.scheduledFuture != null) {
            this.scheduledFuture.cancel(true);
        }
        this.scheduledExecutorService.shutdownNow();
        this.shutdown();
    }

    private static ScheduledExecutorService createExecutor() {
        return Executors.newSingleThreadScheduledExecutor(runnable -> {
            Runnable runnable2;
            Runnable thread = new Thread(runnable, "Upnp Service Delayed Startup Thread");
            ((Thread)thread).setUncaughtExceptionHandler((thread1, exception) -> {
                void var1_1;
                throw new IllegalStateException((Throwable)var1_1);
            });
            return runnable2;
        });
    }

    /*
     * WARNING - void declaration
     */
    public void setUpnpServiceConfiguration(UpnpServiceConfiguration configuration) {
        void var1_1;
        this.configuration = var1_1;
        if (this.isRunning) {
            this.logger.debug("New OSGi UpnpServiceConfiguration is bound while UPnP service is running; restart needed");
            this.restart(true);
        }
    }

    public void unsetUpnpServiceConfiguration(UpnpServiceConfiguration configuration) {
        this.configuration = null;
    }

    protected ProtocolFactory createProtocolFactory() {
        return new ProtocolFactoryImpl(this);
    }

    protected Registry createRegistry(ProtocolFactory protocolFactory) {
        return new RegistryImpl(this);
    }

    /*
     * WARNING - void declaration
     */
    protected Router createRouter(ProtocolFactory protocolFactory, Registry registry) {
        void var1_1;
        return new RouterImpl(this.getConfiguration(), (ProtocolFactory)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    protected ControlPoint createControlPoint(ProtocolFactory protocolFactory, Registry registry) {
        void var2_2;
        void var1_1;
        return new ControlPointImpl(this.getConfiguration(), (ProtocolFactory)var1_1, (Registry)var2_2);
    }

    @Override
    public UpnpServiceConfiguration getConfiguration() {
        return this.configuration;
    }

    @Override
    public ControlPoint getControlPoint() {
        return this.controlPoint;
    }

    @Override
    public ProtocolFactory getProtocolFactory() {
        return this.protocolFactory;
    }

    @Override
    public Registry getRegistry() {
        return this.registry;
    }

    @Override
    public Router getRouter() {
        return this.router;
    }

    @Override
    public synchronized void shutdown() {
        this.shutdown(false);
    }

    /*
     * WARNING - void declaration
     */
    protected void shutdown(boolean separateThread) {
        void var2_2;
        void var1_1;
        Runnable shutdown = () -> {
            Object object = this.lock;
            synchronized (object) {
                if (this.isRunning) {
                    this.logger.info("Shutting down UPnP service...");
                    this.shutdownRegistry();
                    this.shutdownConfiguration();
                    this.shutdownRouter();
                    this.logger.info("UPnP service shutdown completed");
                    this.isRunning = false;
                }
                return;
            }
        };
        if (var1_1 != false) {
            new Thread(shutdown).start();
            return;
        }
        var2_2.run();
    }

    /*
     * WARNING - void declaration
     */
    private void restart(boolean separateThread) {
        void var2_2;
        void var1_1;
        Runnable restart = () -> {
            this.shutdown();
            this.startup();
        };
        if (var1_1 != false) {
            new Thread(restart).start();
            return;
        }
        var2_2.run();
    }

    protected void shutdownRegistry() {
        this.getRegistry().shutdown();
    }

    /*
     * WARNING - void declaration
     */
    protected void shutdownRouter() {
        try {
            this.getRouter().shutdown();
            return;
        }
        catch (RouterException routerException) {
            void var1_1;
            RouterException e = routerException;
            Throwable throwable = Exceptions.unwrap(routerException);
            if (throwable instanceof InterruptedException) {
                this.logger.debug("Router shutdown was interrupted", (Throwable)e);
                return;
            }
            throw new RuntimeException("Router error on shutdown", (Throwable)var1_1);
        }
    }

    protected void shutdownConfiguration() {
        this.getConfiguration().shutdown();
    }

    /*
     * WARNING - void declaration
     */
    private void delayedStartup(int msDelay) {
        void var1_1;
        void var2_2;
        Runnable startup = this::startup;
        if (this.scheduledFuture != null) {
            this.scheduledFuture.cancel(true);
        }
        this.scheduledFuture = this.scheduledExecutorService.schedule((Runnable)var2_2, (long)var1_1, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void startup() {
        Object object = this.lock;
        synchronized (object) {
            if (!this.isRunning) {
                this.logger.info("Starting UPnP service...");
                this.logger.debug("Using configuration: {}", (Object)this.getConfiguration().getClass().getName());
                this.protocolFactory = this.createProtocolFactory();
                this.registry = this.createRegistry(this.protocolFactory);
                this.router = this.createRouter(this.protocolFactory, this.registry);
                try {
                    this.router.enable();
                }
                catch (RouterException e) {
                    void var2_2;
                    throw new RuntimeException("Enabling network router failed", (Throwable)var2_2);
                }
                this.controlPoint = this.createControlPoint(this.protocolFactory, this.registry);
                this.logger.debug("UPnP service started successfully");
                this.isRunning = true;
                if (this.isInitialSearchEnabled) {
                    this.controlPoint.search(new STAllHeader());
                }
            }
            return;
        }
    }

    public static @interface Config {
        public boolean initialSearchEnabled() default true;
    }
}

